# Security policy

## Introduction

BioSimulations and BioSimulators welcome feedback from security researchers and the general public to help improve our security. If you believe you have discovered a vulnerability, privacy issue, exposed data, or other security issues in any of our assets, we want to hear from you. This policy outlines steps for reporting vulnerabilities to us, what we expect, and what you can expect from us.

## Systems in scope

This policy applies to any assets owned, operated, or maintained by BioSimulations or BioSimulators.

BioSimulations and BioSimulators are updated on a rolling release. If any security issues are found, only the latest releases and deployments will contain any security fixes.

## Systems out of scope

This policy does not apply to assets not owned, operated, or maintained by BioSimulations or BioSimulators. 

Vulnerabilities discovered or suspected in out-of-scope systems should be reported to the appropriate vendor or applicable authority.

## Our commitments

When working with us, you can expect us to:

- Respond to your report promptly, and work with you to understand and validate your report;
- Work to remediate discovered vulnerabilities in a timely manner, within our operational constraints;
- Strive to keep you informed about our progress addressing the vulnerability; and
- Extend Safe Harbor for your vulnerability research that is related to this policy.

## Our expectations

In participating in our vulnerability disclosure program in good faith, we ask that you:

- Play by the rules, including following this policy and any other relevant agreements. If there is any inconsistency between this policy and any other applicable terms, the terms of this policy will prevail;
- Report any vulnerability you’ve discovered promptly;
- Avoid violating the privacy of others, disrupting our systems, destroying data, and/or harming user experience;
- Use only our development deployments (eg. api.biosimulations.dev) for testing and research purposes unless you strongly believe there are deployment-specific vulnerabilities;
- Use only the official channels outlined below to discuss vulnerability information with us;
- Provide us a reasonable amount of time (at least 90 days from the initial report) to resolve the issue before you disclose it publicly;
- Perform testing only on in-scope systems, and respect systems and activities which are out-of-scope;
- If a vulnerability provides unintended access to data: Limit the amount of data you access to the minimum required for effectively demonstrating a proof of concept; and cease testing and submit a report immediately if you encounter any user data during testing, such as Personally Identifiable Information (PII), Personal Healthcare Information (PHI), credit card data, or proprietary information;
- You should only interact with test accounts you own or with explicit permission from the account holder; and
- Do not engage in extortion.  

## Official channels for reporting vulnerabilities

Please report security issues to our lead developers via [info@biosimulations.org](mailto:info@biosimulations.org). Please provide as much relevant information as possible. The more details you provide, the easier it will be for us to triage and fix the issue.

## Safe harbor

When conducting vulnerability research, according to this policy, we consider this research conducted under this policy to be:

- Authorized concerning any applicable anti-hacking laws, and we will not initiate or support legal action against you for accidental, good-faith violations of this policy;
- Authorized concerning any relevant anti-circumvention laws, and we will not bring a claim against you for circumvention of technology controls;
- Exempt from restrictions in our Terms of Service (TOS) that would interfere with conducting security research, and we waive those restrictions on a limited basis; and
- Lawful, helpful to the overall security of the internet, and conducted in good faith.

You are expected, as always, to comply with all applicable laws. If legal action is initiated by a third party against you and you have complied with this policy, we will take steps to make it known that your actions were conducted in compliance with this policy.

If at any time you have concerns or are uncertain whether your security research is consistent with this policy, please submit a report through our official channel before going any further.

!!!note
    Safe Harbor applies only to legal claims under the control of BioSimulations and BioSimulators. This policy does not bind independent third parties.
