/**
 * BioSimulations COMBINE API
 * Endpoints for working with models (e.g., [CellML](https://cellml.org/), [SBML](http://sbml.org/)), simulation experiments (e.g., [Simulation Experiment Description Language (SED-ML)](https://sed-ml.org/)), metadata ([OMEX Metadata](https://sys-bio.github.io/libOmexMeta/)), and simulation projects ([COMBINE/OMEX archives](https://combinearchive.org/)).  Note, this API may change significantly in the future.
 *
 * The version of the OpenAPI document: 0.1
 * Contact: info@biosimulations.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { SedParameter } from './sedParameter';
import { SedVariable } from './sedVariable';
import { SedTarget } from './sedTarget';

/**
 * Dynamic change to an attribute of a model
 */
export interface SedSetValueComputeModelChange {
  /**
   * Type.
   */
  _type: SedSetValueComputeModelChangeTypeEnum;
  /**
   * Unique identifier within its parent SED-ML document.
   */
  id?: string;
  /**
   * Brief description
   */
  name?: string;
  /**
   * Identifier of the model to modify
   */
  model: string;
  target: SedTarget;
  /**
   * Symbol within the model to modify
   */
  symbol?: string;
  /**
   * Parameters of the mathematical expression
   */
  parameters: Array<SedParameter>;
  /**
   * Variables of the mathematical expression
   */
  variables: Array<SedVariable>;
  /**
   * Identifier for the range used in the mathematical expression
   */
  range?: string;
  /**
   * Mathematical expression
   */
  math: string;
}
export enum SedSetValueComputeModelChangeTypeEnum {
  SedSetValueComputeModelChange = 'SedSetValueComputeModelChange',
}
