/**
 * BioSimulations COMBINE API
 * Endpoints for working with models (e.g., [CellML](https://cellml.org/), [SBML](http://sbml.org/)), simulation experiments (e.g., [Simulation Experiment Description Language (SED-ML)](https://sed-ml.org/)), metadata ([OMEX Metadata](https://sys-bio.github.io/libOmexMeta/)), and simulation projects ([COMBINE/OMEX archives](https://combinearchive.org/)).  Note, this API may change significantly in the future.
 *
 * The version of the OpenAPI document: 0.1
 * Contact: info@biosimulations.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/* tslint:disable:no-unused-variable member-ordering */

import { Inject, Injectable, Optional } from '@angular/core';
import {
  HttpClient,
  HttpHeaders,
  HttpParams,
  HttpResponse,
  HttpEvent,
  HttpParameterCodec,
  HttpContext,
} from '@angular/common/http';
import { CustomHttpParameterCodec } from '../encoder';
import { Observable } from 'rxjs';

import { BioSimulationsCombineArchiveElementMetadata } from '../model/bioSimulationsCombineArchiveElementMetadata';

import { CombineArchive } from '../model/combineArchive';

import { CombineArchiveFileContent } from '../model/combineArchiveFileContent';

import { CombineArchiveManifest } from '../model/combineArchiveManifest';

import { CombineArchiveSedDocSpecs } from '../model/combineArchiveSedDocSpecs';

import { Environment } from '../model/environment';

import { FilenameOrUrl } from '../model/filenameOrUrl';

import { RdfTriple } from '../model/rdfTriple';

import { SimulationRunResults } from '../model/simulationRunResults';

import { ValidationReport } from '../model/validationReport';

import { BASE_PATH, COLLECTION_FORMATS } from '../variables';
import { Configuration } from '../configuration';

@Injectable({
  providedIn: 'root',
})
export class SimulationProjectsService {
  protected basePath = 'https://combine.api.biosimulations.dev';
  public defaultHeaders = new HttpHeaders();
  public configuration = new Configuration();
  public encoder: HttpParameterCodec;

  constructor(
    protected httpClient: HttpClient,
    @Optional() @Inject(BASE_PATH) basePath: string | string[],
    @Optional() configuration: Configuration,
  ) {
    if (configuration) {
      this.configuration = configuration;
    }
    if (typeof this.configuration.basePath !== 'string') {
      if (Array.isArray(basePath) && basePath.length > 0) {
        basePath = basePath[0];
      }

      if (typeof basePath !== 'string') {
        basePath = this.basePath;
      }
      this.configuration.basePath = basePath;
    }
    this.encoder = this.configuration.encoder || new CustomHttpParameterCodec();
  }

  /**
   * @param consumes string[] mime-types
   * @return true: consumes contains 'multipart/form-data', false: otherwise
   */
  private canConsumeForm(consumes: string[]): boolean {
    const form = 'multipart/form-data';
    for (const consume of consumes) {
      if (form === consume) {
        return true;
      }
    }
    return false;
  }

  private addToHttpParams(httpParams: HttpParams, value: any, key?: string): HttpParams {
    if (typeof value === 'object' && value instanceof Date === false) {
      httpParams = this.addToHttpParamsRecursive(httpParams, value);
    } else {
      httpParams = this.addToHttpParamsRecursive(httpParams, value, key);
    }
    return httpParams;
  }

  private addToHttpParamsRecursive(httpParams: HttpParams, value?: any, key?: string): HttpParams {
    if (value == null) {
      return httpParams;
    }

    if (typeof value === 'object') {
      if (Array.isArray(value)) {
        (value as any[]).forEach((elem) => (httpParams = this.addToHttpParamsRecursive(httpParams, elem, key)));
      } else if (value instanceof Date) {
        if (key != null) {
          httpParams = httpParams.append(key, (value as Date).toISOString().substr(0, 10));
        } else {
          throw Error('key may not be null if value is Date');
        }
      } else {
        Object.keys(value).forEach(
          (k) => (httpParams = this.addToHttpParamsRecursive(httpParams, value[k], key != null ? `${key}.${k}` : k)),
        );
      }
    } else if (key != null) {
      httpParams = httpParams.append(key, value);
    } else {
      throw Error('key may not be null if value is not object or array');
    }
    return httpParams;
  }

  /**
   * Add content items to a COMBINE/OMEX archive
   * Add content items to a COMBINE/OMEX archive.
   * @param archive
   * @param files Files to add to the COMBINE/OMEX archive and, optionally, the archive.
   * @param newContent
   * @param overwriteLocations Whether to overwrite the location if it already exists, or to add the content at an alternative location (indicated location plus a unique integer).  Default: true
   * @param download Whether to download the modified COMBINE/OMEX archive or return a URL where it can be retrieved.  Default: false
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public combineApiHandlersCombineAddFileHandler(
    archive: FilenameOrUrl,
    files: Array<Blob>,
    newContent: CombineArchiveFileContent,
    overwriteLocations?: boolean,
    download?: boolean,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/zip' | 'application/json'; context?: HttpContext },
  ): Observable<Blob>;
  public combineApiHandlersCombineAddFileHandler(
    archive: FilenameOrUrl,
    files: Array<Blob>,
    newContent: CombineArchiveFileContent,
    overwriteLocations?: boolean,
    download?: boolean,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/zip' | 'application/json'; context?: HttpContext },
  ): Observable<HttpResponse<Blob>>;
  public combineApiHandlersCombineAddFileHandler(
    archive: FilenameOrUrl,
    files: Array<Blob>,
    newContent: CombineArchiveFileContent,
    overwriteLocations?: boolean,
    download?: boolean,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/zip' | 'application/json'; context?: HttpContext },
  ): Observable<HttpEvent<Blob>>;
  public combineApiHandlersCombineAddFileHandler(
    archive: FilenameOrUrl,
    files: Array<Blob>,
    newContent: CombineArchiveFileContent,
    overwriteLocations?: boolean,
    download?: boolean,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/zip' | 'application/json'; context?: HttpContext },
  ): Observable<any> {
    if (archive === null || archive === undefined) {
      throw new Error(
        'Required parameter archive was null or undefined when calling combineApiHandlersCombineAddFileHandler.',
      );
    }
    if (files === null || files === undefined) {
      throw new Error(
        'Required parameter files was null or undefined when calling combineApiHandlersCombineAddFileHandler.',
      );
    }
    if (newContent === null || newContent === undefined) {
      throw new Error(
        'Required parameter newContent was null or undefined when calling combineApiHandlersCombineAddFileHandler.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined = options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/zip', 'application/json'];
      localVarHttpHeaderAcceptSelected = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set('Accept', localVarHttpHeaderAcceptSelected);
    }

    let localVarHttpContext: HttpContext | undefined = options && options.context;
    if (localVarHttpContext === undefined) {
      localVarHttpContext = new HttpContext();
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    let localVarUseForm = false;
    let localVarConvertFormParamsToString = false;
    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    localVarUseForm = canConsumeForm;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    if (archive !== undefined) {
      localVarFormParams =
        (localVarFormParams.append(
          'archive',
          localVarUseForm ? new Blob([JSON.stringify(archive)], { type: 'application/json' }) : <any>archive,
        ) as any) || localVarFormParams;
    }
    if (overwriteLocations !== undefined) {
      localVarFormParams =
        (localVarFormParams.append('overwriteLocations', <any>overwriteLocations) as any) || localVarFormParams;
    }
    if (download !== undefined) {
      localVarFormParams = (localVarFormParams.append('download', <any>download) as any) || localVarFormParams;
    }
    if (files) {
      if (localVarUseForm) {
        files.forEach((element) => {
          localVarFormParams = (localVarFormParams.append('files', <any>element) as any) || localVarFormParams;
        });
      } else {
        localVarFormParams =
          (localVarFormParams.append('files', [...files].join(COLLECTION_FORMATS['csv'])) as any) || localVarFormParams;
      }
    }
    if (newContent !== undefined) {
      localVarFormParams =
        (localVarFormParams.append(
          'newContent',
          localVarUseForm ? new Blob([JSON.stringify(newContent)], { type: 'application/json' }) : <any>newContent,
        ) as any) || localVarFormParams;
    }

    let localVarPath = `/combine/file`;
    return this.httpClient.request('post', `${this.configuration.basePath}${localVarPath}`, {
      context: localVarHttpContext,
      body: localVarConvertFormParamsToString ? localVarFormParams.toString() : localVarFormParams,
      responseType: 'blob',
      withCredentials: this.configuration.withCredentials,
      headers: localVarHeaders,
      observe: observe,
      reportProgress: reportProgress,
    });
  }

  /**
   * Create a COMBINE/OMEX archive from files and specifications of SED-ML documents.
   * Create a COMBINE/OMEX archive from files (e.g., BNGL, CellML, SBML) and specifications of SED-ML documents.
   * @param specs
   * @param files File (e.g., model) to place into the COMBINE/OMEX archive.
   * @param download Whether to download the archive or return a URL where the archive can be downloaded.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public combineApiHandlersCombineCreateHandler(
    specs: CombineArchive,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip'; context?: HttpContext },
  ): Observable<string>;
  public combineApiHandlersCombineCreateHandler(
    specs: CombineArchive,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip'; context?: HttpContext },
  ): Observable<HttpResponse<string>>;
  public combineApiHandlersCombineCreateHandler(
    specs: CombineArchive,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip'; context?: HttpContext },
  ): Observable<HttpEvent<string>>;
  public combineApiHandlersCombineCreateHandler(
    specs: CombineArchive,
    files?: Array<Blob>,
    download?: boolean,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip'; context?: HttpContext },
  ): Observable<any> {
    if (specs === null || specs === undefined) {
      throw new Error(
        'Required parameter specs was null or undefined when calling combineApiHandlersCombineCreateHandler.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined = options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json', 'application/zip'];
      localVarHttpHeaderAcceptSelected = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set('Accept', localVarHttpHeaderAcceptSelected);
    }

    let localVarHttpContext: HttpContext | undefined = options && options.context;
    if (localVarHttpContext === undefined) {
      localVarHttpContext = new HttpContext();
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    let localVarUseForm = false;
    let localVarConvertFormParamsToString = false;
    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    localVarUseForm = canConsumeForm;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    if (specs !== undefined) {
      localVarFormParams =
        (localVarFormParams.append(
          'specs',
          localVarUseForm ? new Blob([JSON.stringify(specs)], { type: 'application/json' }) : <any>specs,
        ) as any) || localVarFormParams;
    }
    if (files) {
      if (localVarUseForm) {
        files.forEach((element) => {
          localVarFormParams = (localVarFormParams.append('files', <any>element) as any) || localVarFormParams;
        });
      } else {
        localVarFormParams =
          (localVarFormParams.append('files', [...files].join(COLLECTION_FORMATS['csv'])) as any) || localVarFormParams;
      }
    }
    if (download !== undefined) {
      localVarFormParams = (localVarFormParams.append('download', <any>download) as any) || localVarFormParams;
    }

    let responseType_: 'text' | 'json' | 'blob' = 'json';
    if (localVarHttpHeaderAcceptSelected) {
      if (localVarHttpHeaderAcceptSelected.startsWith('text')) {
        responseType_ = 'text';
      } else if (this.configuration.isJsonMime(localVarHttpHeaderAcceptSelected)) {
        responseType_ = 'json';
      } else {
        responseType_ = 'blob';
      }
    }

    let localVarPath = `/combine/create`;
    return this.httpClient.request<string>('post', `${this.configuration.basePath}${localVarPath}`, {
      context: localVarHttpContext,
      body: localVarConvertFormParamsToString ? localVarFormParams.toString() : localVarFormParams,
      responseType: <any>responseType_,
      withCredentials: this.configuration.withCredentials,
      headers: localVarHeaders,
      observe: observe,
      reportProgress: reportProgress,
    });
  }

  /**
   * Get a file in a COMBINE/OMEX archive
   * Get a file at a location in a COMBINE/OMEX archive.
   * @param url URL for the COMBINE/OMEX archive.
   * @param location Location in the COMBINE/OMEX archive.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public combineApiHandlersCombineGetFileHandler(
    url: string,
    location: string,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/octet-stream' | 'application/json'; context?: HttpContext },
  ): Observable<Blob>;
  public combineApiHandlersCombineGetFileHandler(
    url: string,
    location: string,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/octet-stream' | 'application/json'; context?: HttpContext },
  ): Observable<HttpResponse<Blob>>;
  public combineApiHandlersCombineGetFileHandler(
    url: string,
    location: string,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/octet-stream' | 'application/json'; context?: HttpContext },
  ): Observable<HttpEvent<Blob>>;
  public combineApiHandlersCombineGetFileHandler(
    url: string,
    location: string,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/octet-stream' | 'application/json'; context?: HttpContext },
  ): Observable<any> {
    if (url === null || url === undefined) {
      throw new Error(
        'Required parameter url was null or undefined when calling combineApiHandlersCombineGetFileHandler.',
      );
    }
    if (location === null || location === undefined) {
      throw new Error(
        'Required parameter location was null or undefined when calling combineApiHandlersCombineGetFileHandler.',
      );
    }

    let localVarQueryParameters = new HttpParams({ encoder: this.encoder });
    if (url !== undefined && url !== null) {
      localVarQueryParameters = this.addToHttpParams(localVarQueryParameters, <any>url, 'url');
    }
    if (location !== undefined && location !== null) {
      localVarQueryParameters = this.addToHttpParams(localVarQueryParameters, <any>location, 'location');
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined = options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/octet-stream', 'application/json'];
      localVarHttpHeaderAcceptSelected = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set('Accept', localVarHttpHeaderAcceptSelected);
    }

    let localVarHttpContext: HttpContext | undefined = options && options.context;
    if (localVarHttpContext === undefined) {
      localVarHttpContext = new HttpContext();
    }

    let localVarPath = `/combine/file`;
    return this.httpClient.request('get', `${this.configuration.basePath}${localVarPath}`, {
      context: localVarHttpContext,
      params: localVarQueryParameters,
      responseType: 'blob',
      withCredentials: this.configuration.withCredentials,
      headers: localVarHeaders,
      observe: observe,
      reportProgress: reportProgress,
    });
  }

  /**
   * Get the specifications of an OMEX manifest or the OMEX manifest of a COMBINE archive
   * Get the specifications of an OMEX manifest or the OMEX manifest of a COMBINE archive
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public combineApiHandlersCombineGetManifestHandler(
    file?: Blob,
    url?: string,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<CombineArchiveManifest>;
  public combineApiHandlersCombineGetManifestHandler(
    file?: Blob,
    url?: string,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<HttpResponse<CombineArchiveManifest>>;
  public combineApiHandlersCombineGetManifestHandler(
    file?: Blob,
    url?: string,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<HttpEvent<CombineArchiveManifest>>;
  public combineApiHandlersCombineGetManifestHandler(
    file?: Blob,
    url?: string,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<any> {
    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined = options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json'];
      localVarHttpHeaderAcceptSelected = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set('Accept', localVarHttpHeaderAcceptSelected);
    }

    let localVarHttpContext: HttpContext | undefined = options && options.context;
    if (localVarHttpContext === undefined) {
      localVarHttpContext = new HttpContext();
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    let localVarUseForm = false;
    let localVarConvertFormParamsToString = false;
    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    localVarUseForm = canConsumeForm;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    if (file !== undefined) {
      localVarFormParams = (localVarFormParams.append('file', <any>file) as any) || localVarFormParams;
    }
    if (url !== undefined) {
      localVarFormParams = (localVarFormParams.append('url', <any>url) as any) || localVarFormParams;
    }

    let responseType_: 'text' | 'json' | 'blob' = 'json';
    if (localVarHttpHeaderAcceptSelected) {
      if (localVarHttpHeaderAcceptSelected.startsWith('text')) {
        responseType_ = 'text';
      } else if (this.configuration.isJsonMime(localVarHttpHeaderAcceptSelected)) {
        responseType_ = 'json';
      } else {
        responseType_ = 'blob';
      }
    }

    let localVarPath = `/combine/manifest`;
    return this.httpClient.request<CombineArchiveManifest>('post', `${this.configuration.basePath}${localVarPath}`, {
      context: localVarHttpContext,
      body: localVarConvertFormParamsToString ? localVarFormParams.toString() : localVarFormParams,
      responseType: <any>responseType_,
      withCredentials: this.configuration.withCredentials,
      headers: localVarHeaders,
      observe: observe,
      reportProgress: reportProgress,
    });
  }

  /**
   * Get the metadata about a COMBINE/OMEX archive
   * Get the metadata about a COMBINE/OMEX archive from the OMEX Metadata files in the archive encoded in BioSimulations\&#39; schema.
   * @param omexMetadataFormat OMEX Metadata format  Default: &#x60;rdfxml&#x60;
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public combineApiHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<Array<BioSimulationsCombineArchiveElementMetadata>>;
  public combineApiHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<HttpResponse<Array<BioSimulationsCombineArchiveElementMetadata>>>;
  public combineApiHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<HttpEvent<Array<BioSimulationsCombineArchiveElementMetadata>>>;
  public combineApiHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<any> {
    if (omexMetadataFormat === null || omexMetadataFormat === undefined) {
      throw new Error(
        'Required parameter omexMetadataFormat was null or undefined when calling combineApiHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined = options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json'];
      localVarHttpHeaderAcceptSelected = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set('Accept', localVarHttpHeaderAcceptSelected);
    }

    let localVarHttpContext: HttpContext | undefined = options && options.context;
    if (localVarHttpContext === undefined) {
      localVarHttpContext = new HttpContext();
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    let localVarUseForm = false;
    let localVarConvertFormParamsToString = false;
    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    localVarUseForm = canConsumeForm;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    if (file !== undefined) {
      localVarFormParams = (localVarFormParams.append('file', <any>file) as any) || localVarFormParams;
    }
    if (url !== undefined) {
      localVarFormParams = (localVarFormParams.append('url', <any>url) as any) || localVarFormParams;
    }
    if (omexMetadataFormat !== undefined) {
      localVarFormParams =
        (localVarFormParams.append('omexMetadataFormat', <any>omexMetadataFormat) as any) || localVarFormParams;
    }

    let responseType_: 'text' | 'json' | 'blob' = 'json';
    if (localVarHttpHeaderAcceptSelected) {
      if (localVarHttpHeaderAcceptSelected.startsWith('text')) {
        responseType_ = 'text';
      } else if (this.configuration.isJsonMime(localVarHttpHeaderAcceptSelected)) {
        responseType_ = 'json';
      } else {
        responseType_ = 'blob';
      }
    }

    let localVarPath = `/combine/metadata/biosimulations`;
    return this.httpClient.request<Array<BioSimulationsCombineArchiveElementMetadata>>(
      'post',
      `${this.configuration.basePath}${localVarPath}`,
      {
        context: localVarHttpContext,
        body: localVarConvertFormParamsToString ? localVarFormParams.toString() : localVarFormParams,
        responseType: <any>responseType_,
        withCredentials: this.configuration.withCredentials,
        headers: localVarHeaders,
        observe: observe,
        reportProgress: reportProgress,
      },
    );
  }

  /**
   * Get the metadata about a COMBINE/OMEX archive
   * Get the metadata about a COMBINE/OMEX archive from the OMEX Metadata files as a list of RDF triples.
   * @param omexMetadataFormat OMEX Metadata format  Default: &#x60;rdfxml&#x60;
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public combineApiHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<Array<RdfTriple>>;
  public combineApiHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<HttpResponse<Array<RdfTriple>>>;
  public combineApiHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<HttpEvent<Array<RdfTriple>>>;
  public combineApiHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<any> {
    if (omexMetadataFormat === null || omexMetadataFormat === undefined) {
      throw new Error(
        'Required parameter omexMetadataFormat was null or undefined when calling combineApiHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined = options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json'];
      localVarHttpHeaderAcceptSelected = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set('Accept', localVarHttpHeaderAcceptSelected);
    }

    let localVarHttpContext: HttpContext | undefined = options && options.context;
    if (localVarHttpContext === undefined) {
      localVarHttpContext = new HttpContext();
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    let localVarUseForm = false;
    let localVarConvertFormParamsToString = false;
    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    localVarUseForm = canConsumeForm;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    if (file !== undefined) {
      localVarFormParams = (localVarFormParams.append('file', <any>file) as any) || localVarFormParams;
    }
    if (url !== undefined) {
      localVarFormParams = (localVarFormParams.append('url', <any>url) as any) || localVarFormParams;
    }
    if (omexMetadataFormat !== undefined) {
      localVarFormParams =
        (localVarFormParams.append('omexMetadataFormat', <any>omexMetadataFormat) as any) || localVarFormParams;
    }

    let responseType_: 'text' | 'json' | 'blob' = 'json';
    if (localVarHttpHeaderAcceptSelected) {
      if (localVarHttpHeaderAcceptSelected.startsWith('text')) {
        responseType_ = 'text';
      } else if (this.configuration.isJsonMime(localVarHttpHeaderAcceptSelected)) {
        responseType_ = 'json';
      } else {
        responseType_ = 'blob';
      }
    }

    let localVarPath = `/combine/metadata/rdf`;
    return this.httpClient.request<Array<RdfTriple>>('post', `${this.configuration.basePath}${localVarPath}`, {
      context: localVarHttpContext,
      body: localVarConvertFormParamsToString ? localVarFormParams.toString() : localVarFormParams,
      responseType: <any>responseType_,
      withCredentials: this.configuration.withCredentials,
      headers: localVarHeaders,
      observe: observe,
      reportProgress: reportProgress,
    });
  }

  /**
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public combineApiHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<CombineArchiveSedDocSpecs>;
  public combineApiHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<HttpResponse<CombineArchiveSedDocSpecs>>;
  public combineApiHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<HttpEvent<CombineArchiveSedDocSpecs>>;
  public combineApiHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<any> {
    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined = options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json'];
      localVarHttpHeaderAcceptSelected = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set('Accept', localVarHttpHeaderAcceptSelected);
    }

    let localVarHttpContext: HttpContext | undefined = options && options.context;
    if (localVarHttpContext === undefined) {
      localVarHttpContext = new HttpContext();
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    let localVarUseForm = false;
    let localVarConvertFormParamsToString = false;
    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    localVarUseForm = canConsumeForm;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    if (file !== undefined) {
      localVarFormParams = (localVarFormParams.append('file', <any>file) as any) || localVarFormParams;
    }
    if (url !== undefined) {
      localVarFormParams = (localVarFormParams.append('url', <any>url) as any) || localVarFormParams;
    }

    let responseType_: 'text' | 'json' | 'blob' = 'json';
    if (localVarHttpHeaderAcceptSelected) {
      if (localVarHttpHeaderAcceptSelected.startsWith('text')) {
        responseType_ = 'text';
      } else if (this.configuration.isJsonMime(localVarHttpHeaderAcceptSelected)) {
        responseType_ = 'json';
      } else {
        responseType_ = 'blob';
      }
    }

    let localVarPath = `/combine/sedml-specs`;
    return this.httpClient.request<CombineArchiveSedDocSpecs>('post', `${this.configuration.basePath}${localVarPath}`, {
      context: localVarHttpContext,
      body: localVarConvertFormParamsToString ? localVarFormParams.toString() : localVarFormParams,
      responseType: <any>responseType_,
      withCredentials: this.configuration.withCredentials,
      headers: localVarHeaders,
      observe: observe,
      reportProgress: reportProgress,
    });
  }

  /**
   * Modify the files and/or SED-ML documents in a COMBINE/OMEX archive
   * Modify the files or SED-ML documents in a COMBINE/OMEX archive.
   * @param specs
   * @param archive
   * @param files File (e.g., model) to place into the COMBINE/OMEX archive.
   * @param download Whether to download the modified archive or return a URL where the modified archive can be downloaded.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public combineApiHandlersCombineModifyHandler(
    specs: CombineArchive,
    archive: FilenameOrUrl,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip'; context?: HttpContext },
  ): Observable<string>;
  public combineApiHandlersCombineModifyHandler(
    specs: CombineArchive,
    archive: FilenameOrUrl,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip'; context?: HttpContext },
  ): Observable<HttpResponse<string>>;
  public combineApiHandlersCombineModifyHandler(
    specs: CombineArchive,
    archive: FilenameOrUrl,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip'; context?: HttpContext },
  ): Observable<HttpEvent<string>>;
  public combineApiHandlersCombineModifyHandler(
    specs: CombineArchive,
    archive: FilenameOrUrl,
    files?: Array<Blob>,
    download?: boolean,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip'; context?: HttpContext },
  ): Observable<any> {
    if (specs === null || specs === undefined) {
      throw new Error(
        'Required parameter specs was null or undefined when calling combineApiHandlersCombineModifyHandler.',
      );
    }
    if (archive === null || archive === undefined) {
      throw new Error(
        'Required parameter archive was null or undefined when calling combineApiHandlersCombineModifyHandler.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined = options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json', 'application/zip'];
      localVarHttpHeaderAcceptSelected = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set('Accept', localVarHttpHeaderAcceptSelected);
    }

    let localVarHttpContext: HttpContext | undefined = options && options.context;
    if (localVarHttpContext === undefined) {
      localVarHttpContext = new HttpContext();
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    let localVarUseForm = false;
    let localVarConvertFormParamsToString = false;
    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    localVarUseForm = canConsumeForm;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    if (specs !== undefined) {
      localVarFormParams =
        (localVarFormParams.append(
          'specs',
          localVarUseForm ? new Blob([JSON.stringify(specs)], { type: 'application/json' }) : <any>specs,
        ) as any) || localVarFormParams;
    }
    if (files) {
      if (localVarUseForm) {
        files.forEach((element) => {
          localVarFormParams = (localVarFormParams.append('files', <any>element) as any) || localVarFormParams;
        });
      } else {
        localVarFormParams =
          (localVarFormParams.append('files', [...files].join(COLLECTION_FORMATS['csv'])) as any) || localVarFormParams;
      }
    }
    if (download !== undefined) {
      localVarFormParams = (localVarFormParams.append('download', <any>download) as any) || localVarFormParams;
    }
    if (archive !== undefined) {
      localVarFormParams =
        (localVarFormParams.append(
          'archive',
          localVarUseForm ? new Blob([JSON.stringify(archive)], { type: 'application/json' }) : <any>archive,
        ) as any) || localVarFormParams;
    }

    let responseType_: 'text' | 'json' | 'blob' = 'json';
    if (localVarHttpHeaderAcceptSelected) {
      if (localVarHttpHeaderAcceptSelected.startsWith('text')) {
        responseType_ = 'text';
      } else if (this.configuration.isJsonMime(localVarHttpHeaderAcceptSelected)) {
        responseType_ = 'json';
      } else {
        responseType_ = 'blob';
      }
    }

    let localVarPath = `/combine/modify`;
    return this.httpClient.request<string>('post', `${this.configuration.basePath}${localVarPath}`, {
      context: localVarHttpContext,
      body: localVarConvertFormParamsToString ? localVarFormParams.toString() : localVarFormParams,
      responseType: <any>responseType_,
      withCredentials: this.configuration.withCredentials,
      headers: localVarHeaders,
      observe: observe,
      reportProgress: reportProgress,
    });
  }

  /**
   * Validate a COMBINE/OMEX archive and the simulation experiments and models inside it.
   * Validate a COMBINE/OMEX archive and the simulation experiments (SED-ML files) and models (e.g., SBML files) inside it.  Notes: * An OMEX Manifest file is required to validate OMEX Metadata files. As a result, the &#x60;validateOmexManifest&#x3D;false&#x60; option should often also be used with the &#x60;validateOmexMetadata&#x3D;false&#x60; option. * Currently, submission to BioSimulations requires metadata to be in RDF-XML format. * COMBINE/OMEX archives must pass all validation checks for publication to BioSimulations.
   * @param omexMetadataFormat OMEX Metadata format
   * @param omexMetadataSchema OMEX Metadata schema
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param validateOmexManifest Whether to validate the manifest of the archive.  Default: &#x60;true&#x60;.
   * @param validateSedml Whether to validate the SED-ML files in the archive.  Default: &#x60;true&#x60;.
   * @param validateSedmlModels Whether to validate the source (e.g., CellML, SBML file) of each model of each SED-ML file in the archive.  Default: &#x60;true&#x60;.
   * @param validateOmexMetadata Whether to validate the OMEX Metadata files in the archive according to [BioSimulators\\\&#39; conventions](https://docs.biosimulations.org/concepts/conventions/simulation-project-metadata/).  Default: &#x60;true&#x60;.
   * @param validateImages Whether to validate the image (BMP, GIF, PNG, JPEG, TIFF, WEBP) files in the archive.  Default: &#x60;true&#x60;.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public combineApiHandlersCombineValidateHandler(
    omexMetadataFormat: string,
    omexMetadataSchema: string,
    file?: Blob,
    url?: string,
    validateOmexManifest?: boolean,
    validateSedml?: boolean,
    validateSedmlModels?: boolean,
    validateOmexMetadata?: boolean,
    validateImages?: boolean,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<ValidationReport>;
  public combineApiHandlersCombineValidateHandler(
    omexMetadataFormat: string,
    omexMetadataSchema: string,
    file?: Blob,
    url?: string,
    validateOmexManifest?: boolean,
    validateSedml?: boolean,
    validateSedmlModels?: boolean,
    validateOmexMetadata?: boolean,
    validateImages?: boolean,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<HttpResponse<ValidationReport>>;
  public combineApiHandlersCombineValidateHandler(
    omexMetadataFormat: string,
    omexMetadataSchema: string,
    file?: Blob,
    url?: string,
    validateOmexManifest?: boolean,
    validateSedml?: boolean,
    validateSedmlModels?: boolean,
    validateOmexMetadata?: boolean,
    validateImages?: boolean,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<HttpEvent<ValidationReport>>;
  public combineApiHandlersCombineValidateHandler(
    omexMetadataFormat: string,
    omexMetadataSchema: string,
    file?: Blob,
    url?: string,
    validateOmexManifest?: boolean,
    validateSedml?: boolean,
    validateSedmlModels?: boolean,
    validateOmexMetadata?: boolean,
    validateImages?: boolean,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json'; context?: HttpContext },
  ): Observable<any> {
    if (omexMetadataFormat === null || omexMetadataFormat === undefined) {
      throw new Error(
        'Required parameter omexMetadataFormat was null or undefined when calling combineApiHandlersCombineValidateHandler.',
      );
    }
    if (omexMetadataSchema === null || omexMetadataSchema === undefined) {
      throw new Error(
        'Required parameter omexMetadataSchema was null or undefined when calling combineApiHandlersCombineValidateHandler.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined = options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json'];
      localVarHttpHeaderAcceptSelected = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set('Accept', localVarHttpHeaderAcceptSelected);
    }

    let localVarHttpContext: HttpContext | undefined = options && options.context;
    if (localVarHttpContext === undefined) {
      localVarHttpContext = new HttpContext();
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    let localVarUseForm = false;
    let localVarConvertFormParamsToString = false;
    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    localVarUseForm = canConsumeForm;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    if (file !== undefined) {
      localVarFormParams = (localVarFormParams.append('file', <any>file) as any) || localVarFormParams;
    }
    if (url !== undefined) {
      localVarFormParams = (localVarFormParams.append('url', <any>url) as any) || localVarFormParams;
    }
    if (omexMetadataFormat !== undefined) {
      localVarFormParams =
        (localVarFormParams.append('omexMetadataFormat', <any>omexMetadataFormat) as any) || localVarFormParams;
    }
    if (validateOmexManifest !== undefined) {
      localVarFormParams =
        (localVarFormParams.append('validateOmexManifest', <any>validateOmexManifest) as any) || localVarFormParams;
    }
    if (omexMetadataSchema !== undefined) {
      localVarFormParams =
        (localVarFormParams.append('omexMetadataSchema', <any>omexMetadataSchema) as any) || localVarFormParams;
    }
    if (validateSedml !== undefined) {
      localVarFormParams =
        (localVarFormParams.append('validateSedml', <any>validateSedml) as any) || localVarFormParams;
    }
    if (validateSedmlModels !== undefined) {
      localVarFormParams =
        (localVarFormParams.append('validateSedmlModels', <any>validateSedmlModels) as any) || localVarFormParams;
    }
    if (validateOmexMetadata !== undefined) {
      localVarFormParams =
        (localVarFormParams.append('validateOmexMetadata', <any>validateOmexMetadata) as any) || localVarFormParams;
    }
    if (validateImages !== undefined) {
      localVarFormParams =
        (localVarFormParams.append('validateImages', <any>validateImages) as any) || localVarFormParams;
    }

    let responseType_: 'text' | 'json' | 'blob' = 'json';
    if (localVarHttpHeaderAcceptSelected) {
      if (localVarHttpHeaderAcceptSelected.startsWith('text')) {
        responseType_ = 'text';
      } else if (this.configuration.isJsonMime(localVarHttpHeaderAcceptSelected)) {
        responseType_ = 'json';
      } else {
        responseType_ = 'blob';
      }
    }

    let localVarPath = `/combine/validate`;
    return this.httpClient.request<ValidationReport>('post', `${this.configuration.basePath}${localVarPath}`, {
      context: localVarHttpContext,
      body: localVarConvertFormParamsToString ? localVarFormParams.toString() : localVarFormParams,
      responseType: <any>responseType_,
      withCredentials: this.configuration.withCredentials,
      headers: localVarHeaders,
      observe: observe,
      reportProgress: reportProgress,
    });
  }

  /**
   * Execute a COMBINE/OMEX archive
   * Execute the simulations defined in SED-ML format in a COMBINE/OMEX archive and return the result of each report and plot.
   * @param simulator Id of a simulation tool registered with BioSimulators.
   * @param type Type
   * @param archiveUrl URL
   * @param archiveFile The two files uploaded in creating a combine archive
   * @param environment
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public combineApiHandlersRunRunHandler(
    simulator: string,
    type: string,
    archiveUrl?: string,
    archiveFile?: Blob,
    environment?: Environment,
    observe?: 'body',
    reportProgress?: boolean,
    options?: {
      httpHeaderAccept?: 'application/json' | 'application/x-hdf' | 'application/zip';
      context?: HttpContext;
    },
  ): Observable<SimulationRunResults>;
  public combineApiHandlersRunRunHandler(
    simulator: string,
    type: string,
    archiveUrl?: string,
    archiveFile?: Blob,
    environment?: Environment,
    observe?: 'response',
    reportProgress?: boolean,
    options?: {
      httpHeaderAccept?: 'application/json' | 'application/x-hdf' | 'application/zip';
      context?: HttpContext;
    },
  ): Observable<HttpResponse<SimulationRunResults>>;
  public combineApiHandlersRunRunHandler(
    simulator: string,
    type: string,
    archiveUrl?: string,
    archiveFile?: Blob,
    environment?: Environment,
    observe?: 'events',
    reportProgress?: boolean,
    options?: {
      httpHeaderAccept?: 'application/json' | 'application/x-hdf' | 'application/zip';
      context?: HttpContext;
    },
  ): Observable<HttpEvent<SimulationRunResults>>;
  public combineApiHandlersRunRunHandler(
    simulator: string,
    type: string,
    archiveUrl?: string,
    archiveFile?: Blob,
    environment?: Environment,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: {
      httpHeaderAccept?: 'application/json' | 'application/x-hdf' | 'application/zip';
      context?: HttpContext;
    },
  ): Observable<any> {
    if (simulator === null || simulator === undefined) {
      throw new Error(
        'Required parameter simulator was null or undefined when calling combineApiHandlersRunRunHandler.',
      );
    }
    if (type === null || type === undefined) {
      throw new Error('Required parameter type was null or undefined when calling combineApiHandlersRunRunHandler.');
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined = options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json', 'application/x-hdf', 'application/zip'];
      localVarHttpHeaderAcceptSelected = this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set('Accept', localVarHttpHeaderAcceptSelected);
    }

    let localVarHttpContext: HttpContext | undefined = options && options.context;
    if (localVarHttpContext === undefined) {
      localVarHttpContext = new HttpContext();
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    let localVarUseForm = false;
    let localVarConvertFormParamsToString = false;
    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    localVarUseForm = canConsumeForm;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    if (simulator !== undefined) {
      localVarFormParams = (localVarFormParams.append('simulator', <any>simulator) as any) || localVarFormParams;
    }
    if (archiveUrl !== undefined) {
      localVarFormParams = (localVarFormParams.append('archiveUrl', <any>archiveUrl) as any) || localVarFormParams;
    }
    if (archiveFile !== undefined) {
      localVarFormParams = (localVarFormParams.append('archiveFile', <any>archiveFile) as any) || localVarFormParams;
    }
    if (type !== undefined) {
      localVarFormParams = (localVarFormParams.append('_type', <any>type) as any) || localVarFormParams;
    }
    if (environment !== undefined) {
      localVarFormParams =
        (localVarFormParams.append(
          'environment',
          localVarUseForm ? new Blob([JSON.stringify(environment)], { type: 'application/json' }) : <any>environment,
        ) as any) || localVarFormParams;
    }

    let responseType_: 'text' | 'json' | 'blob' = 'json';
    if (localVarHttpHeaderAcceptSelected) {
      if (localVarHttpHeaderAcceptSelected.startsWith('text')) {
        responseType_ = 'text';
      } else if (this.configuration.isJsonMime(localVarHttpHeaderAcceptSelected)) {
        responseType_ = 'json';
      } else {
        responseType_ = 'blob';
      }
    }

    let localVarPath = `/run/run`;
    return this.httpClient.request<SimulationRunResults>('post', `${this.configuration.basePath}${localVarPath}`, {
      context: localVarHttpContext,
      body: localVarConvertFormParamsToString ? localVarFormParams.toString() : localVarFormParams,
      responseType: <any>responseType_,
      withCredentials: this.configuration.withCredentials,
      headers: localVarHeaders,
      observe: observe,
      reportProgress: reportProgress,
    });
  }
}
