# Our use of cookies and other similar local storage

## What are cookies and other local storage?

Cookies and local storage are mechanisms for storing information related to your use of BioSimulators and BioSimulations in your browser.

More information about cookies and local storage is available from [allaboutcookies.org](https://allaboutcookies.org) and [gdpr.eu/cookies](https://gdpr.eu/cookies).

## How do we use cookies and local storage?

BioSimulators and BioSimulations use cookies and local storage to improve your experience on our websites. This includes:

- Providing essential functionality, such as authentication and security.
- Helping us understand how users use our websites. This information helps us improve our websites.
- Collecting anonymous, aggregated information about visitors to our websites. This information helps us plan the resources needed to run our websites and report their impact to the funding agencies that support BioSimulators and BioSimulations.
- Enabling users to save their settings, such as their cookie preferences.

## What types of cookies and local storage do we use?

We only use first-party cookies and local storage. This means that we do not share cookies with any third parties or external companies. 

Our cookies and local storage do not contain any personal information. However, we do generate cookies that are unique to each client. These cookies cannot be used to identify you.

Below is a list of the types of cookies and local storage that we use. More information about each type of cookie is available at [allaboutcookies.org](https://allaboutcookies.org) and [gdpr.eu/cookies](https://gdpr.eu/cookies).


### Necessary cookies and local storage
These cookies are essential for our websites to function. 

Currently, we use cookies and local storage for the following purposes:

- Store cookie preferences: When you visit our websites and select your cookie preferences, we store those selections in your browser's local storage. This ensures that we do not collect information that you have not explicitly allowed.

- Enable authentication: For sections of our websites that require you to log into an account, we use cookies to verify that you are logged in. This enables us to ensure that only you have access to your account and its private resources. We use the following cookies for this purpose:
    - `auth0`, `auth0_compat`: These cookies are used to verify that you are logged in.
    - `did`, `did-compat`: These cookies are used to protect BioSimulators and BioSimulations from bots and other automated attacks.

- Store information about the simulation runs that you have submitted in the browser's local storage, to enable you to view the simulation runs you have loaded and submitted.

### Functional cookies and local storage

These cookies are used to support additional, non-essential functionality that provides users with a more personalized experience.

- Currently, we do not use functional cookies


### Performance cookies and local storage

These cookies are used to collect data for improving the performance of our websites.

Currently, we use cookies for the following purposes:

- `biosim_analytics_ga_XXXXXXXXXX`: This cookie allows us to distinguish between users who are new to our websites and users who have visited our websites before. This helps us accurately measure the utilization and performance of our websites.

- `biosim_analytics_la_XXXXXXXXXX`: This cookie is used to monitor how users interact with our websites. For example, which links users follow to navigate our websites. This information helps us improve our websites for users.

These cookies are used to gather information that is sent to Google Analytics. No personal information is collected or sent to Google Analytics. For more information, see <!-- * #no-spell-check* --> [Google Analytics](https://developers.google.com/analytics/devguides/collection/gtagjs/cookie-usage). 

### Tracking cookies and local storage

These cookies are used to track user's behavior and history for marketing and advertising purposes.

BioSimulations and BioSimulators DO NOT USE any tracking or targeting cookies for any purpose. 

BioSimulations and BioSimulators DO NOT COLLECT any personal information through the use of cookies.

## How to manage your cookies and local storage

You can set your browser to accept cookies, to see what cookies and local storage are being set for you, or to delete cookies or local storage.

You can also set your browser to block cookies. However, this may affect the functionality of our websites.

Upon your first visit to our websites, we will present you with an explanation of the cookies we use and options for disabling some or all of them. These selections will be saved in your browser's local storage.

If you wish to change your cookie preferences, clear the site data in your browser for our websites. When you visit our websites again, you will again be prompted to select your cookie preferences. More information about clearing your site data is available at [allaboutcookies.org](https://allaboutcookies.org) and [gdpr.eu/cookies](https://gdpr.eu/cookies).

## Updates to this policy

As we continue to develop BioSimulations and BioSimulators, we may have additional needs or technical requirements that may require us to change our this policy. We will post any changes to this policy on this page. Below is the date when this policy was last updated.
