% Figure 8

load ([ 'Figure8.mat']);
ng=512;
Ds=6;
x=(1:ng)/ng*Ds;
y=(ng:-1:1)/ng*Ds;

H=  figure('position',[0,0,1200,530]);
h1=axes('position',[0.035 0.11 0.42  0.88]);
imagesc(h1,x, y, -w_xy); %warm sst (bs >0) corresponds to upwelling, -w_xy>0
caxis([-1 1]*5.e-3);
set(h1,'ydir','normal','fontsize',12,'xlim',[1. 2.5],'ylim',[-5.5 -4]+Ds);
colormap(h1,'gray');

h2=copyobj(h1, H );
[cf,hf]= contour(h2,x,y,  -Pe_flux_xy, [ -30 -15:5:-5, -4  -2, -1, 1, 2,4,5,10,15,30]*1.e-3);
colormap(h2,'default');
hf.LineWidth=1;
h2.Visible = 'off';
h2cb=colorbar(h2,'fontsize',12);
h2.UserData = linkprop([h1, h2],.....
    {'Position','DataAspectRatio','xtick','ytick', ......
    'ydir','xdir','xlim','ylim'} );
xlabel('$x$','fontsize',20,'interpreter','latex');
ylabel('$y$','fontsize',20,'interpreter','latex');
text(0.83,1.9,'$(a)$','fontsize',30,'interpreter','latex','fontweight','bold')


 
h1=axes('position',[0.53 0.11 0.42  0.88]);
imagesc(h1,x,y, -bs_xy_avg,[-1 1]*.4)
set(h1,'fontsize',12,'ydir','normal','ylim',[-3.8 -2.4]+Ds,'xlim',[1.8 3.2],'ytick',[2.2:0.2:3.6],'xtick',[1.8:0.2:3.2]);
colormap(h1,'gray');
 
[~,xleft] = min(abs(x2-h1.XLim(1)));
[~,xright] = min(abs(x2-h1.XLim(2)));
[~,ybot] = min(abs(Ds-y2-h1.YLim(1)));
[~,ytop] = min(abs(Ds-y2-h1.YLim(2)));
h2 = copyobj(h1, H);  
colormap(h2,'default');
 [c2,hlb2] = contour(h2, x2(xleft:xright), Ds-y2(ybot+10:-1: ytop-10) , d_lambda(ybot+10:-1: ytop-10,xleft:xright),  [ -6:0.5:-1 -0.8    0.8 1:0.5:4  ]);

hlb2.LineWidth=1;
h2.Visible = 'off';
hb=colorbar(h2,'fontsize',12);
h2.UserData = linkprop([h2, h1],.....
    {'Position','DataAspectRatio','xtick','ytick', ......
    'ydir','xdir','xlim','ylim'} ); % 
set(h1,'ytick',[2.2:0.4:3.6],'xtick',[1.8 2 2.2 2.4 2.6 2.8 3 3.2]);
xlabel('$x$','fontsize',20,'interpreter','latex');
ylabel('$y$','fontsize',20,'interpreter','latex');
text(1.65,3.56,'$(b)$','fontsize',30,'interpreter','latex','fontweight','bold')

% print(gcf,[dir_out,'Figure8-fst_vs_fsle'],'-r300','-dpng');
% savefig(gcf,[dir_out,'Figure8-fst_vs_fsle.fig'],'compact');
% load([dir_out,'Figure8-fst_vs_fsle.mat'],'x','y','x2','y2','xleft','xright','ybot','ytop','d_lambda','Ds','Pe_flux_xy','w_xy');