load Figure6.mat

 H_xy=figure('position',[400,20,1500, 1200],'name','x,y');

set(groot,'CurrentFigure', H_xy)
h1=axes('position',[0.02,0.53,0.45,0.45]);
imagesc(h1,x,y,-bs_xy,[-1 1]*1.2);
set(h1,'DataAspectRatio',[1 ,1 1],'fontsize',14,'ydir','normal','xlim',[0.5 2.5],'ylim',[-4.5 -2.5]+Ds);
colormap(h1,'gray');
h1b=copyobj(h1, H_xy);
[c1,hlb1]=  contour(h1b,x,y,-Ke_flux_xy,[-2:0.5:-1 , -0.8:0.2:-0.2,   0.2:0.2:0.8, 1:0.5:2 ]*1.e-2);
hlb1.LineWidth=1;
%         contour(h1b,(1:ng)/ng*Ds, (1:ng)/ng*Ds,-Ke_flux_xy,30);
colormap(h1b,'default')
h1b.Visible = 'off';
hb=colorbar(h1b,'fontsize',16);
h1b.UserData = linkprop([h1,h1b],.....
    {'Position','DataAspectRatio','xtick','ytick', ......
    'ydir','xdir','xlim','ylim'} ); 
text(0.2,3.4,'$(a)$','fontsize',30,'interpreter','latex');
ylabel('$y$','interpreter','latex','fontsize',20)







h2=axes('position',[0.5,0.53,0.45,0.45]);
imagesc(h2,x,y,-bs_xy,[-1 1]*1.2);
set(h2,'DataAspectRatio',[1 ,1 1],'fontsize',14,'ydir','normal','xlim',[0.5 2.5],'ylim',[-4.5 -2.5]+Ds);
colormap(h2,'gray');
h2b=copyobj(h2, H_xy);
[c2,hlb2] =      contour(h2b, x, y,-Pe_flux_xy,[-15:5:-5 , -2:0.5:-0.5, 0.5:0.5:2, 5:5:15]*1.e-2);
hlb2.LineWidth = 1;
colormap(h2b,'default')
h2b.Visible = 'off';
hb=colorbar(h2b,'fontsize',16);
h2b.UserData = linkprop([h2, h2b],.....
    {'Position','DataAspectRatio','xtick','ytick', ......
    'ydir','xdir','xlim','ylim'} ); % add more props as needed
hb=colorbar(h2b, 'fontsize',14);
hb.Ticks=[-0.15 -0.1, -0.05 0 0.05 0.1 0.15];
text(0.2,3.4,'$(b)$','fontsize',30,'interpreter','latex');


set(groot,'CurrentFigure',H_xy)
h3=axes('position',[0.02,0.05,0.45,0.45]);
imagesc(h3,x,y , -bs_xy,[-1 1]*1.2);
set(h3,'DataAspectRatio',[1 ,1 1],'fontsize',14,'ydir','normal','xlim',[0.5 2.5],'ylim',Ds-[4.5 2.5]);
colormap(h3,'gray');
h3b=copyobj(h3, H_xy);
[c3,hlb3] = contour(h3b,x,y,-Ke_flux_xy2,[-2:0.2:-1 -0.9:0.1:-0.1 0.1:0.1:0.9, 1:0.2:2]*5.e-2);
hlb3.LineWidth=1;
colormap(h3b,'default')
h3b.Visible = 'off';
hb=colorbar(h3b,'fontsize',16);
h3b.UserData = linkprop([h3, h3b],.....
    {'Position','DataAspectRatio','xtick','ytick', ......
    'ydir','xdir','xlim','ylim'} ); % add more props
text(0.2,3.4,'$(c)$','fontsize',30,'interpreter','latex');
ylabel('$y$','interpreter','latex','fontsize',20)
% delete(h3b)
xlabel('$x$','interpreter','latex','fontsize',20)



h4=axes('position',[0.5,0.05,0.45,0.45]);
imagesc(h4,x,y,-bs_xy,[-1 1]*1.2);
set(h4,'DataAspectRatio',[1 ,1 1],'fontsize',14,'ydir','normal','xlim',[0.5 2.5],'ylim',Ds-[4.5 2.5]);
colormap(h4,'gray');
h4b=copyobj(h4, H_xy);
[c4,hlb4] =     contour(h4b,x,y,-Pe_flux_xy2,[-2:0.1:-0.1 0.1:0.1:2]*3.e-1);
hlb4.LineWidth=1;
colormap(h4b,'default');
h4b.Visible = 'off';
hb=colorbar(h4b,'fontsize',16);
h4b.UserData = linkprop([h4, h4b],.....
    {'Position','DataAspectRatio','xtick','ytick', ......
    'ydir','xdir','xlim','ylim'} ); % add more props
text(0.2,3.4,'$(d)$','fontsize',30,'interpreter','latex');
xlabel('$x$','interpreter','latex','fontsize',20)
