load Figure5.mat

epsilon_lt=[ 0.01,  0.05,  0.1, 0.15,  0.2 ];

H=figure('position',[500,100,800*0.84*3,800*0.8]);
% ('position',[0,0,1200,500])
H1=axes('position',[0.06,0.16,0.25,0.8]);
H2=axes('position',[0.38,0.16,0.25,0.8]);
H3=axes('position',[0.71,0.16,0.25,0.8]);
hold on
 
    set(H,'CurrentAxes',H1);
    logline=loglog(xk,KE ,'linewidth',1);
    hold on;
    
    
    set(H,'CurrentAxes',H2);
    loglog(xk,PE ,'linewidth',1  );
    hold on;
 

    set(H,'CurrentAxes',H3);
   h = loglog(xk,Gradient_zeta, 'linestyle','-','linewidth',2  );
    hold on;
   h_delta = loglog(xk, Gradient_delta,'linestyle',':','linewidth',2  );
     h_sigma =     loglog(xk,Gradient_sigma,'--','linewidth', 2  );
        for i=1:numel(h)
        h_delta(i).Color=h(i).Color;
        h_sigma(i).Color=h(i).Color;
        end


        


set(groot,'CurrentFigure', H);
set(H,'CurrentAxes',H1);
ppx=1 ;ppy=2e10;sw=10^3;
loglog( [ppx*sw,ppx] ,[ppy*(sw)^(-5/3),ppy],'k-','linewidth',2);
loglog( [ppx*sw,ppx] ,[ppy*(sw)^(-2),ppy]*0.5,'k--','linewidth',2);
 
legend(lg,  'fontsize',25,'box','off','location','southwest','interpreter','latex')
set(gca,'ylim',[10^5,4*10^9],'fontsize',20,'xlim',[1, 300],'xScale','log','yScale','log')
xlabel('$k$','fontsize',30,'interpreter','latex' )
ylabel('$\mathcal{K}_s(k)$','fontsize',30,'interpreter','latex') ;
text(0.4,3*10^9,'$(a)$','fontsize',35,'interpreter','latex')
grid on;


set(groot,'CurrentFigure', H);
set(H,'CurrentAxes',H2);
ppx=1 ;ppy=2e10;sw=10^3;
loglog( [ppx*sw,ppx] ,[ppy*(sw)^(-5/3),ppy],'k-','linewidth',2);
loglog( [ppx*sw,ppx] ,[ppy*(sw)^(-2),ppy]*0.5,'k--','linewidth',2);
set(gca,'ylim',[10^5,4*10^9],'fontsize',20,'xlim',[1, 300],'xScale','log','yScale','log')
xlabel('$k$','fontsize',30,'interpreter','latex' )
ylabel('$\mathcal{P}_s(k)$','fontsize',30,'interpreter','latex') ;
text(0.4,3*10^9,'$(b)$','fontsize',35,'interpreter','latex')
grid on

set(groot,'CurrentFigure', H);
set(H,'CurrentAxes', H3);
set(gca, 'fontsize',20, 'xlim',[1, 300],'ylim',[1.e-5, 1.e10], 'xScale', 'log', 'yScale','log')
grid on;
xlabel('$k$','fontsize',30,'interpreter','latex' )
ylabel('PSD', 'fontsize', 30,'interpreter','latex') ;
grid on;   box on;
 text(0.25,max(get(gca,'ylim'))*0.8, '$(c)$','fontsize',35,'interpreter','latex')

 hinsert=axes('position',[0.77,0.24,0.15,0.25]);
plot(ep,k,'bo-','linestyle','none','color','k','marker','o','markersize',8,'markerfacecolor','k');
hold on
set(gca,'fontsize',20,'xlim',[0.01 0.22],'ylim',[-20 150])
grid on;
xlabel('$\varepsilon$','interpreter','latex','fontsize',30);
ylabel('$k_{max}$','interpreter','latex','fontsize',30);

mdl=fitlm(ep,k,'linear','RobustOpts','on');



fep=linspace(0,0.2,100);
plot(fep,mdl.Coefficients.Estimate(2)*fep+mdl.Coefficients.Estimate(1),'k-')
text(0.03,130,'R^2=0.95','fontsize',20)




 


  
