# VASP calculations

Run VASP calculations at this step. 

- Prepare `INCAR`, `POSCAR`, `POTCAR`, and `KPOINTS`.

- Run VASP:

   ```console
   mpirun vasp_std
   ```

We provide examples of `INCAR` in the [agat/default_parameters.py](https://github.com/jzhang-github/AGAT/blob/main/agat/default_parameters.py), also shown below:
```console
SYSTEM = ML

Start parameter for this Run:
  ISTART = 0
  ICHARG = 2
  INIWAV = 1

Electronic Relaxation:
  ENCUT = 500
  PREC = Accurate
  ALGO = Fast
  NELM = 300
  NELMIN = 4
  EDIFF = 1E-06
  GGA = PE
  LREAL = A

Ionic Relaxation:
  EDIFFG = -0.05
  NSW = 300
  IBRION = 2
  ISIF = 3
  POTIM = 0.5

DOS related values:
  SIGMA = 0.1
  ISMEAR = 1

Spin polarized:
  ISPIN = 2
  MAGMOM = placeholder

File writing
  LWAVE = .FALSE.
  LCHARG = .FALSE.

Calculation of DOS
  NPAR = 8
  LORBIT = 11
  NCORE = 1
  IVDW = 11

```

The `KPOINTS`:
```console
Automatic mesh
0
Gamma
1 1 1
0.0 0.0 0.0
```

`POTCAR`:
Find in your VASP package.

`POSCAR`:
```console
Co Fe Ni Pd Pt
 1.0000000000000000
    10.4200280561206498    0.0000000000000000    0.0000000000000000
     0.0000000000000000   13.5360135071205985    0.0000000000000000
     0.0000000000000000    0.0000000000000000   22.7618759214902369
 Co  Fe  Ni  Pd  Pt
  29  29  28  29  29
Selective dynamics
Cartesian
  2.6465907224890586  2.0911526619251219  5.6126935592326479   F   F   F
  5.2566624973971452  5.0545463392322878  3.4602634907665206   F   F   F
  6.4796272358932923  2.8518560176779468  3.4261615440386803   F   F   F
  1.2536688932315689  7.2634938143357211  3.4695212453226314   F   F   F
  1.2615780846490059  8.7400165696567811  5.6449449241495815   F   F   F
  5.1789654400708640  7.9885980989164951  1.2603226976115356   F   F   F
  9.0995193749070502  8.7687082613853562  5.6297719567244844   F   F   F
  1.3315721097149376 13.3706089298270392  5.5929808386515401   F   F   F
  2.6112693571636409 11.0379282250798187  5.6406804406665652   F   F   F
  3.8986335965343173 10.2246991410760852  1.2553688760006469   F   F   F
  5.2141135144989486 11.0255270470942737  5.6280580464403860   F   F   F
  5.2480839325039828  0.6441177887581858  3.4385002239214493   F   F   F
  7.8058399490390782 10.9939479425510491  5.5956638860163599   F   F   F
 10.3987096361440940 12.5893687277722464  1.2229736014718122   F   F   F
 10.3795254096573384  0.5753441100739666  3.4369210374822821   F   F   F
  1.3719638644149521  1.3545438521007149  7.7260046147277421   T   T   T
  3.8816676040183578  1.3789148966987346  7.7090333237916697   T   T   T
  5.2171422236846725  2.1121676599433128 11.9205745667857848   T   T   T
  9.1201107315442176  4.3290838486896321 11.8925064712378052   T   T   T
  3.8693573374220884  5.8093633070511936  7.7106866926301718   T   T   T
  5.1588919672148794  6.5825947042117683 11.8969376709820320   T   T   T
  5.1966657400331444  9.4798495432020662  9.7649365322593535   T   T   T
  6.4937487334410156  5.8054557455357472  7.6562141367493091   T   T   T
  9.1163200277587517  8.8001161249299376 11.8788299894542462   T   T   T
  1.3139144469358714 11.7838705209709822  9.8123324278954360   T   T   T
  1.3062393421302834 13.3326848477314073 11.8708424120743192   T   T   T
  5.2058161505399250  0.6379452317496751  9.7677294371404368   T   T   T
  6.5355089480387294 13.3714183654315608 11.9454937505774268   T   T   T
  9.1149413858406447 11.7537997115696502  9.8224441346679736   T   T   T
  5.2057310651267379  2.1176509384037434  5.5940706697152898   F   F   F
  7.7941876942532984  5.0737629639455504  3.5116704024264660   F   F   F
 10.3788958086986405  5.0939354348605193  3.5266694943002008   F   F   F
  2.6275295661793669  8.0259836211449063  1.2577003291294913   F   F   F
  0.0132521721727654  8.0026725736133955  1.3085740935089889   F   F   F
  6.5332762009310246 11.8493735819077344  3.4152547868290335   F   F   F
  9.0845366517822459 11.8573994889879923  3.4098275172225905   F   F   F
  9.0936122837290352 13.3660781097254944  5.5719114801275342   F   F   F
  1.3658443967732976  2.9191598689519105  9.7542344718973304   T   T   T
  3.8785318882071631  2.8571763680106494  9.7437239416719166   T   T   T
  6.4715465423893654  1.3993144380051059  7.6739659639758369   T   T   T
  6.4767941704017824  2.8100125397732261  9.7614309995943991   T   T   T
  6.4647226903096708  4.3374021371167197 11.9114624969039955   T   T   T
  0.0774094386079398  5.0558289303879880  9.7220521355031888   T   T   T
  1.3201069315071403  5.8126738724649059  7.7143100324444234   T   T   T
  1.3258678923841172  8.7493383738870918 11.8623012319191456   T   T   T
  2.6391333950743379  6.5542426511055130 11.8548038395225976   T   T   T
  6.4774460269768461  8.7540671272726502 11.8893043513958165   T   T   T
  7.7742199128278964  6.5608627318040842 11.9143761693226722   T   T   T
  7.8391619160603083  8.0655296892309103  7.6560538159227489   T   T   T
  0.0065632415301624  8.0367686559451208  7.6621801564483185   T   T   T
  0.0010822882235683  9.5739657743759992  9.7129550995299869   T   T   T
  1.3014014109946852 10.2841282347983505  7.7171157601803255   T   T   T
  2.6002961488012870 12.5765707159278861  7.7231138302158895   T   T   T
  3.8734198507238689 10.2742993450368623  7.7434349254256629   T   T   T
  3.9157057854532944 13.3833523785040480 11.8785753676755821   T   T   T
  9.0658839326610678 13.3130086447644196 11.9235718348628374   T   T   T
 10.3752178112925204 11.0332305913798905 11.8471533064188215   T   T   T
  0.0487020859613106 12.5325050256594004  7.6999047993395493   T   T   T
  2.6317607568414583  3.6105995926676759  1.2920792345835335   F   F   F
  3.9548660010781576  2.8712667354173216  3.4647849985764001   F   F   F
  5.2229531255618298  3.6065806584933688  1.3256457706458051   F   F   F
  9.0794502077173522  2.8657206067182752  3.4506552531983732   F   F   F
  9.0952295092646622  4.3706279235424095  5.6271908484854221   F   F   F
 10.4152467950401117  3.6171454928491933  1.3405997857235450   F   F   F
  9.1090963007223262  7.2505398147607893  3.5027367058547050   F   F   F
 10.3876934370187080  6.5515070793492969  5.6519324971823020   F   F   F
 10.3882619487218637  9.4612254489043828  3.4714684656576353   F   F   F
  2.5938847719204392 12.5682290080207490  1.2700257815274136   F   F   F
  6.4928788797967139 13.3620233787993037  5.5889699329551181   F   F   F
  7.7907900995072694  0.5950201642574308  3.3843915768559585   F   F   F
  2.6152381948406820  3.6040802067505879  7.7327092750316613   T   T   T
  2.5927787377587905  5.0871187749387472  9.7583483515004126   T   T   T
  7.7577041069790083  2.1106668584865949 11.9185162061921552   T   T   T
  7.7899914955961318  3.6332470908393422  7.6758286511294100   T   T   T
  9.1110094293757591  2.8510230974550370  9.7488059221623686   T   T   T
  0.0368163649791567  3.6324641860740585  7.7256961756138711   T   T   T
  1.3453526869852435  7.2549116747931874  9.7032648582786116   T   T   T
  3.8806732730704159  7.2793456549231079  9.7647763454907306   T   T   T
  3.9030456256186192  8.7032316876174622 11.8495889577785007   T   T   T
  7.8417030249198758  9.5407196548063347  9.7376144338614985   T   T   T
  9.1406621344438790  5.8082465844227427  7.6343984098932891   T   T   T
  6.5257712972771209 10.2132653005190051  7.7574050126746288   T   T   T
  6.5410673145129419 11.7943430552070172  9.8080550650348748   T   T   T
  7.8224545341218139 11.0408534811514905 11.8819526274591230   T   T   T
  7.7758179096618782  0.6039706568796718  9.8041112329832103   T   T   T
  9.1359132321841656 10.2367060644619734  7.7651598888224154   T   T   T
  1.2978532860524157  2.8674465260294939  3.4786617301751925   F   F   F
  2.6071376408421649  5.0686833870712293  3.4902601624541236   F   F   F
  3.9382212597810486  4.3166181976912359  5.6069055114722364   F   F   F
  1.3203296216523799  5.8182979600483016  1.2774025159949352   F   F   F
  3.9285762827181130  5.8517977280215039  1.2561780151166011   F   F   F
  5.2472460688023759  6.5391868532221746  5.5826877427615260   F   F   F
  6.4832796991708213  5.8339323131899308  1.3162180708940898   F   F   F
  7.8269915801373005  6.5492923252371078  5.5748831358497410   F   F   F
  7.8147943592244120  9.4684251550469281  3.4413132110733429   F   F   F
  9.0981940675248101  5.8288699630651735  1.3583767170123651   F   F   F
  1.3092239378022972 10.2667973834800375  1.2510413096426969   F   F   F
  1.2799565434641564 11.8312586124581980  3.4695722590555955   F   F   F
  2.6269073116994295  0.6085987976128486  3.4717858060870865   F   F   F
  3.9299790020037926 11.8205395846119572  3.4853658321164684   F   F   F
  3.9149777696329759 13.3683487110941108  5.6206367695161967   F   F   F
  6.5186691595086712 10.2532180878954673  1.2902794140466454   F   F   F
 10.3998720032473475 10.9981170417608283  5.6191210584826115   F   F   F
  1.3467464957650424  4.3406027743582509 11.8325509286590105   T   T   T
  5.1392079340111252  5.0650990153381743  9.7845958190738695   T   T   T
  7.8093884118878272  5.0622211475374730  9.7408365269392938   T   T   T
  9.1058118319690102  1.3698416808940508  7.6937881103713321   T   T   T
  9.1588624461159451  7.2935898584344194  9.7159171236225106   T   T   T
  0.0550848089375399  6.5552913689789039 11.8976861277857040   T   T   T
  2.5888470893988140 11.0198114531220739 11.8308093213672567   T   T   T
  3.8712685040349735 11.8049556367800506  9.7807565270188821   T   T   T
  5.2420274465492058 10.9955382214010058 11.8628359647810360   T   T   T
  5.1549919611017971 12.5714247424516437  7.7005035438668639   T   T   T
  7.8141932799132796 12.5525837674716705  7.7256391808160583   T   T   T
  0.0156748447522792  0.5844755244715529  9.7907470061079085   T   T   T
  1.2974818382203355  1.3363714005746803  1.2946658431509059   F   F   F
  1.2811714810247039  4.3560386470197248  5.6490452784128733   F   F   F
  3.9467382612042168  1.3807951774351750  1.3144289652730974   F   F   F
  6.5046700672153319  1.3709531420328209  1.2717551727827461   F   F   F
  6.5203617003081344  4.3297613869959859  5.5616018987721487   F   F   F
  7.7726425986777485  2.1471665879812702  5.5753645790346056   F   F   F
  7.7674801245439200  3.5992247382844824  1.3611688317488382   F   F   F
  9.0806878089515113  1.3319068489182475  1.2550420730046359   F   F   F
 10.4160946513214334  2.1005672108293805  5.5878372737312887   F   F   F
  2.5773249993211778  6.5358782751972226  5.6501439123190584   F   F   F
  2.6035341167658808  9.4948230504947997  3.4684887150986938   F   F   F
  3.9313893855532744  7.2709741055966806  3.4245538749323474   F   F   F
  3.9169585332929504  8.7775717338898662  5.6342128927219983   F   F   F
  5.2354652281066922  9.4889885039447464  3.4555862270392557   F   F   F
  6.5394196616910332  7.2463697435662784  3.4563652541533707   F   F   F
  6.5490944346706774  8.7810870586860137  5.6111882592020592   F   F   F
  7.8004777099491776  7.9871689532176839  1.3464987357854272   F   F   F
  5.2442528692345967 12.5912802184712405  1.2878096256898068   F   F   F
  7.8171727315906256 12.6010880306119795  1.2304458227903150   F   F   F
  9.1016837258657617 10.2888833790866716  1.2845830677247181   F   F   F
  2.6401441637284258  2.1493389455120639 11.8497243811568236   T   T   T
  3.8952111075482239  4.3379605533675516 11.8799640631573293   T   T   T
  5.1783734831725754  3.5944992706901013  7.6768430662127507   T   T   T
  0.0023422694354796  2.1508753965095355 11.8758977477580192   T   T   T
  2.5765256423439191  8.0034316464276962  7.7078479036565719   T   T   T
  2.5788668782741726  9.5122144696964703  9.7476332976986839   T   T   T
  5.2011492880371106  8.0334459700151459  7.7107601714816827   T   T   T
  6.4629800623478859  7.2984756893064144  9.7595719459513361   T   T   T
  2.6226668800317867  0.6121094420507481  9.7483629277581372   T   T   T
```

