from crispy_forms.helper import FormHelper
from django import forms
from django.contrib.gis.forms import HiddenInput
from django.utils.translation import gettext_lazy as _
from pian.models import Pian


class PianCreateForm(forms.ModelForm):
    """
    Hlavní formulář pro vytvoření, editaci a zobrazení pianu.
    """
    class Meta:
        model = Pian
        fields = ("presnost", "geom", "geom_sjtsk", "geom_system")
        labels = {"presnost": _("pian.forms.pianCreateForm.presnost.label")}
        help_texts = {
            "presnost": _("pian.forms.pianCreateForm.presnost.tooltip"),
        }
        widgets = {
            "geom": HiddenInput(),
            "geom_sjtsk": HiddenInput(),
            "geom_system": HiddenInput(),
            "presnost": forms.Select(attrs={"class": "selectpicker", "data-multiple-separator": "; ", "data-live-search": "true"})
        }

    def __init__(self, *args, **kwargs):
        super(PianCreateForm, self).__init__(*args, **kwargs)
        self.helper = FormHelper(self)
        self.helper.form_tag = False
        self.fields["geom_system"].initial = "4326"
