# Generated by Django 3.2.11 on 2023-02-13 15:20

from django.db import migrations


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("pas", "0002_initial"),
        ("historie", "0002_initial"),
    ]

    operations = [
        migrations.RunSQL(
            sql="""
            CREATE OR REPLACE FUNCTION public.delete_history_spoluprace()
                RETURNS trigger
                LANGUAGE 'plpgsql'
                COST 100
                VOLATILE NOT LEAKPROOF
            AS $BODY$
                BEGIN
                    with deleted_historie as (
                    DELETE FROM historie_vazby AS hv
                    WHERE hv.id = old.historie
                    returning id
                    )
                    DELETE FROM historie AS h
                    WHERE h.vazba in (select id from deleted_historie)
                    ;
                    return OLD
                    ;
                END;   
            $BODY$;
            """,
            reverse_sql="DROP FUNCTION public.delete_history_spoluprace;",
        ),
        migrations.RunSQL(
            sql="""
            CREATE TRIGGER delete_history_spoluprace
                BEFORE DELETE
                ON uzivatel_spoluprace
                FOR EACH ROW
                EXECUTE FUNCTION delete_history_spoluprace();
            """,
            reverse_sql="DROP FUNCTION public.delete_history_spoluprace;",
        ),
        migrations.RunSQL(
            sql="""
            CREATE OR REPLACE FUNCTION public.deleted_soubor_history()
                RETURNS trigger
                LANGUAGE 'plpgsql'
                COST 100
                VOLATILE NOT LEAKPROOF
            AS $BODY$
                BEGIN
                    INSERT INTO historie (datum_zmeny, uzivatel, poznamka, vazba, typ_zmeny) SELECT NOW(), (SELECT id FROM auth_user WHERE email = 'amcr@arup.cas.cz'), nazev, historie, 'DEL' FROM old_table;
                    RETURN NEW;
                END;   
            $BODY$;
            """,
            reverse_sql="DROP FUNCTION public.deleted_soubor_history;",
        ),
        migrations.RunSQL(
            sql="""
            CREATE TRIGGER deleted_soubor_history
                AFTER DELETE
                ON soubor
                REFERENCING OLD TABLE AS old_table
                FOR EACH STATEMENT
                EXECUTE FUNCTION deleted_soubor_history();
            """,
            reverse_sql="DROP TRIGGER public.deleted_soubor_history;",
        ),
        migrations.RunSQL(
            sql="""
            CREATE OR REPLACE FUNCTION public.deleted_records_history()
                RETURNS trigger
                LANGUAGE 'plpgsql'
                COST 100
                VOLATILE NOT LEAKPROOF
            AS $BODY$
                BEGIN
                    INSERT INTO historie (datum_zmeny, uzivatel, poznamka, vazba, typ_zmeny) SELECT NOW(), (SELECT id FROM auth_user WHERE email = 'amcr@arup.cas.cz'), ident_cely, historie, 'DEL' FROM old_table;
                    RETURN NEW;
                END;    
            $BODY$;
            """,
            reverse_sql="DROP FUNCTION public.deleted_records_history;",
        ),
        migrations.RunSQL(
            sql="""
            CREATE TRIGGER deleted_records_history_archeologicky_zaznam
                AFTER DELETE
                ON archeologicky_zaznam
                REFERENCING OLD TABLE AS old_table
                FOR EACH STATEMENT
                EXECUTE FUNCTION deleted_records_history();
            """,
            reverse_sql="DROP TRIGGER public.deleted_records_history_archeologicky_zaznam;",
        ),
        migrations.RunSQL(
            sql="""
            CREATE TRIGGER deleted_records_history_auth_user
                AFTER DELETE
                ON auth_user
                REFERENCING OLD TABLE AS old_table
                FOR EACH STATEMENT
                EXECUTE FUNCTION deleted_records_history();
                """,
            reverse_sql="DROP TRIGGER public.deleted_records_history_auth_user;",
        ),
        migrations.RunSQL(
            sql="""
            CREATE TRIGGER deleted_records_history_projekt
                AFTER DELETE
                ON projekt
                REFERENCING OLD TABLE AS old_table
                FOR EACH STATEMENT
                EXECUTE FUNCTION deleted_records_history();
            """,
            reverse_sql="DROP TRIGGER public.deleted_records_history_projekt;",
        ),
        migrations.RunSQL(
            sql="""
            CREATE TRIGGER deleted_records_history_pian
                AFTER DELETE
                ON pian
                REFERENCING OLD TABLE AS old_table
                FOR EACH STATEMENT
                EXECUTE FUNCTION deleted_records_history();
            """,
            reverse_sql="DROP TRIGGER public.deleted_records_history_pian;",
        ),
        migrations.RunSQL(
            sql="""
            CREATE TRIGGER deleted_records_history_samostatny_nalez
                AFTER DELETE
                ON samostatny_nalez
                REFERENCING OLD TABLE AS old_table
                FOR EACH STATEMENT
                EXECUTE FUNCTION deleted_records_history();
            """,
            reverse_sql="DROP TRIGGER public.deleted_records_history_samostatny_nalez;",
        ),
        migrations.RunSQL(
            sql="""
            CREATE TRIGGER deleted_records_history_dokument
                AFTER DELETE
                ON dokument
                REFERENCING OLD TABLE AS old_table
                FOR EACH STATEMENT
                EXECUTE FUNCTION deleted_records_history();
            """,
            reverse_sql="DROP TRIGGER public.deleted_records_history_dokument;",
        ),
        migrations.RunSQL(
            sql="""
            CREATE TRIGGER deleted_records_history_externi_zdroj
                AFTER DELETE
                ON externi_zdroj
                REFERENCING OLD TABLE AS old_table
                FOR EACH STATEMENT
                EXECUTE FUNCTION deleted_records_history();
            """,
            reverse_sql="DROP TRIGGER public.deleted_records_history_externi_zdroj;",
        ),
    ]
