#!/bin/bash

set -e

echo Cloning CIRCT...
git clone https://github.com/llvm/circt.git
pushd onnx-mlir
git checkout 15c8a3e97ad3a02502c9d99e8402b10561ebe1a8
git submodule update --init --recursive

echo Cloning LLVM...
git clone -n https://github.com/llvm/llvm-project.git
pushd llvm-project
git checkout f66cd9e9556a53142a26a5c21a72e21f1579217c
popd

echo Building LLVM...
mkdir llvm-project/build
pushd llvm-project/build
cmake -G Ninja ../llvm \
   -DLLVM_ENABLE_PROJECTS=mlir \
   -DLLVM_TARGETS_TO_BUILD="host" \
   -DCMAKE_BUILD_TYPE=Release \
   -DLLVM_ENABLE_ASSERTIONS=ON \
   -DLLVM_ENABLE_RTTI=ON \
   -DLLVM_ENABLE_LIBEDIT=OFF \
   -DCMAKE_C_COMPILER=clang -DCMAKE_CXX_COMPILER=clang++ -DLLVM_USE_LINKER="lld"
cmake --build .
popd

echo Building ONNX-MLIR with Mull...
MLIR_DIR=$PWD/llvm-project/build/lib/cmake/mlir
mkdir build
pushd build
cmake -G Ninja \
        -DONNX_MLIR_ACCELERATORS=NNPA \
        -DMLIR_DIR=${MLIR_DIR} \
        -DLLVM_USE_LINKER=lld \
        -DCMAKE_C_COMPILER=clang \
        -DCMAKE_CXX_COMPILER=clang++ \
        -DCMAKE_BUILD_TYPE=Debug \
        -DCMAKE_CXX_FLAGS="-fprofile-instr-generate -fcoverage-mapping -fexperimental-new-pass-manager -fpass-plugin=/usr/lib/mull-ir-frontend-14 -g -grecord-command-line" \
        ..
cmake --build . -j 8
popd

echo Copying ONNX-MLIR binaries...
mkdir -p ../onnx-mlir-bin
cp -r build ../onnx-mlir-bin/onnx-mlir-mull
rm -rf build


echo Building ONNX-MLIR with coverage...
mkdir build
pushd build
cmake -G Ninja \
        -DONNX_MLIR_ACCELERATORS=NNPA \
        -DMLIR_DIR=${MLIR_DIR} \
        -DLLVM_USE_LINKER=lld \
        -DCMAKE_C_COMPILER=clang \
        -DCMAKE_CXX_COMPILER=clang++ \
        -DCMAKE_BUILD_TYPE=Debug \
        -DCMAKE_CXX_FLAGS="-fprofile-instr-generate -fcoverage-mapping" \
        ..
cmake --build .
popd

echo Copying ONNX-MLIR binaries...
mkdir -p ../onnx-mlir-bin
cp -r build ../onnx-mlir-bin/onnx-mlir-cov
rm -rf build

echo Done!