import os
import time
import sys
import shutil
import subprocess
from multiprocessing import Pool
from argparse import ArgumentParser
import random
import string
from pathlib import Path

from common import TARGET_CMD

parser = ArgumentParser()
parser.add_argument("input_dir", type=Path)
parser.add_argument("--output-dir", required=False, type=Path)
args = parser.parse_args()

if args.output_dir is None:
    output_dir = args.input_dir.parent / "reference-output"
else:
    output_dir = args.output_dir

os.makedirs(output_dir, exist_ok=True)
max_time = 0
for dirent in os.scandir(args.input_dir):
    if not dirent.name.endswith(".mlir"):
        continue
    print(dirent.path)
    output_path = os.path.join(output_dir, f"{os.path.splitext(dirent.name)[0]}")
    start_time = time.time()
    status = subprocess.run(
        [item.replace("%input", dirent.path) for item in TARGET_CMD],
        capture_output=True,
    )
    with open(output_path + ".returncode", "w") as f:
        f.write(str(status.returncode))
    with open(output_path + ".stdout", "wb") as f:
        f.write(status.stdout)
    with open(output_path + ".stderr", "wb") as f:
        f.write(status.stderr)
    elapsed_time = time.time() - start_time
    if elapsed_time > max_time:
        max_time = elapsed_time
with open(os.path.join(output_dir, "max_time.txt"), "w") as f:
    f.write(f"{max_time}")
