import os
import time
import sys
import shutil
import subprocess
from multiprocessing import Pool
from argparse import ArgumentParser
import random
import string

from common import TARGET_CMD

parser = ArgumentParser()
parser.add_argument("input_dir")
parser.add_argument("output_path")
args = parser.parse_args()

alphanumeric_chars = string.ascii_letters + string.digits
cache_dir = "/tmp/" + "".join([random.choice(alphanumeric_chars) for _ in range(10)])
profraw_dir = os.path.join(cache_dir, "profraw")
os.makedirs(profraw_dir)
for dirent in os.scandir(args.input_dir):
    if not dirent.name.endswith(".mlir"):
        continue
    print(dirent.path)
    profraw_path = os.path.join(profraw_dir, f"{dirent.name}.profraw")
    subprocess.run(
        [item.replace("%input", dirent.path) for item in TARGET_CMD],
        check=True,
        env={"LLVM_PROFILE_FILE": profraw_path} | os.environ,
    )

subprocess.run(
    " ".join(
        [
            "llvm-profdata",
            "merge",
            "-sparse",
            f"{profraw_dir}/*.profraw",
            "-o",
            args.output_path,
        ]
    ),
    shell=True,
)
shutil.rmtree(cache_dir)
