#!/bin/bash

# Get the absolute path of the current script
script_path="$(readlink -f "${BASH_SOURCE[0]}")"

# Get the directory of the current script
script_dir="$(dirname "$script_path")"

# Get common variables
. "$script_dir/common.sh"

NEXT_CMD="python -m mlirmut.scripts.eval_inputs \
    --max-threads $max_threads \
    --command-prefix "$binary_path $command_args" \
    $parent_path/generate \
    $parent_path/eval.csv"
echo "$NEXT_CMD"
eval "$NEXT_CMD"