root_dir="/path/to/synthfuzz-data/onnx-mlir"
parent_path="$root_dir/$1"
binary_path="/path/to/Projects/onnx-mlir-bin/onnx-mlir-2022/bin/onnx-mlir"
mull_binary_path="/path/to/Projects/onnx-mlir-bin/onnx-mlir-mull/bin/onnx-mlir"
command_args="--EmitLLVMIR"
MLIR_GEN_DIR=$(realpath "$script_dir/../mlirgen")
POP_DIR=$(realpath "$script_dir/../seed-pop")
COV_PATH="$root_dir/combined-cov.profdata"
max_threads=8

echo "Got variables:
root_dir: $root_dir
parent_path: $parent_path
binary_path: $binary_path
command_args: $command_args
MLIR_GEN_DIR: $MLIR_GEN_DIR
POP_DIR: $POP_DIR
max_threads: $max_threads
"

mkdir -p "$parent_path"

# Check if binary_path exists and is executable
if [ ! -x "$binary_path" ]; then
  echo "Error: $binary_path does not exist or is not executable."
  exit 1
fi

# Check if POP_DIR exists and is a directory
if [ ! -d "$POP_DIR" ]; then
  echo "Error: $POP_DIR does not exist or is not a directory."
  exit 1
fi

# Check if MLIR_GEN_DIR exists
if [ ! -d "$MLIR_GEN_DIR" ]; then
  echo "Error: $MLIR_GEN_DIR does not exist or is not a directory."
  exit 1
fi
