import os
import pickle
from lark import UnexpectedCharacters


def get_target_node(root, path):
    if len(path) == 0:
        return root
    if len(path) == 1:
        return root.children[path[0]]
    return get_target_node(root.children[path[0]], path[1:])


def load_templates(filepath: os.PathLike):
    with open(filepath, "rb") as f:
        templates = pickle.load(f)
        return templates
