#!/bin/bash

. common.sh

# Source and destination directories
src="./original_fir_files"
dest="./separated_mlir_files"

# Initialize a counter for the output filenames
counter=0

# Loop through each .fir file in the source directory
for file in "$src"/*.fir; do
    $firtool_path "$file" --format=fir --ir-fir -o "$dest/mlir_$counter.mlir"
    counter=$((counter + 1))
done

echo "Created $(($counter)) mlir files in $dest."
