#!/bin/bash

. common.sh

# Source and destination directories
src="./separated_mlir_files"
dest="./generic-cases"

# Initialize a counter for the output filenames
counter=0

for file in "$src"/*.mlir; do
    $circt_opt_path --mlir-print-op-generic "$file" > "$dest/$counter.mlir"
    counter=$((counter + 1))
done

echo "Created $(($counter)) mlir files in $dest."

