# Generated by Grammarinator 23.7

import itertools

from math import inf
from grammarinator.runtime import *

def mlir_serializer(root):
    def _walk(node):
        nonlocal src
        for child in node.children:
            _walk(child)

        if isinstance(node, UnlexerRule) and node.src:
            src += node.src
            if node.name == "BARE_ID" and node.right_sibling and isinstance(node.right_sibling, UnlexerRule) and node.right_sibling.name == "BARE_ID":
                src += ' '

        if (isinstance(node, UnparserRule) and (node.name in ['definition', 'function', 'module', 'generic_module', 'operation'])):
            src += '\n'
        
    src = ''
    _walk(root)
    return src


class mlir_2023Generator(Generator):


    def EOF(self, parent=None):
        pass
    EOF.min_depth = 0

    def bool_literal(self, parent=None):
        with RuleContext(self, UnparserRule(name='bool_literal', parent=parent)) as current:
            with AlternationContext(self, [1, 1], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.TRUE, self.FALSE][choice0](parent=current)
            return current
    bool_literal.min_depth = 1

    def decimal_literal(self, parent=None):
        with RuleContext(self, UnparserRule(name='decimal_literal', parent=parent)) as current:
            self.DIGITS(parent=current)
            return current
    decimal_literal.min_depth = 2

    def HEXADECIMAL_LITERAL(self, parent=None):
        with RuleContext(self, UnlexerRule(name='HEXADECIMAL_LITERAL', parent=parent)) as current:
            UnlexerRule(src='0x', parent=current)
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=1, max=inf):
                    UnlexerRule(src=self._model.charset(current, 0, self._charsets[1]), parent=current)
            return current
    HEXADECIMAL_LITERAL.min_depth = 0

    def integer_literal(self, parent=None):
        with RuleContext(self, UnparserRule(name='integer_literal', parent=parent)) as current:
            with AlternationContext(self, [3, 1], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.decimal_literal, self.HEXADECIMAL_LITERAL][choice0](parent=current)
            return current
    integer_literal.min_depth = 1

    def negated_integer_literal(self, parent=None):
        with RuleContext(self, UnparserRule(name='negated_integer_literal', parent=parent)) as current:
            UnlexerRule(src='-', parent=current)
            self.integer_literal(parent=current)
            return current
    negated_integer_literal.min_depth = 2

    def posneg_integer_literal(self, parent=None):
        with RuleContext(self, UnparserRule(name='posneg_integer_literal', parent=parent)) as current:
            with AlternationContext(self, [2, 3], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.integer_literal, self.negated_integer_literal][choice0](parent=current)
            return current
    posneg_integer_literal.min_depth = 2

    def string_literal(self, parent=None):
        with RuleContext(self, UnparserRule(name='string_literal', parent=parent)) as current:
            self.ESCAPED_STRING(parent=current)
            return current
    string_literal.min_depth = 1

    def constant_literal(self, parent=None):
        with RuleContext(self, UnparserRule(name='constant_literal', parent=parent)) as current:
            with AlternationContext(self, [2, 2, 1, 2], [1, 1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.bool_literal, self.integer_literal, self.FLOAT_LITERAL, self.string_literal][choice0](parent=current)
            return current
    constant_literal.min_depth = 1

    def suffix_id(self, parent=None):
        with RuleContext(self, UnparserRule(name='suffix_id', parent=parent)) as current:
            with AlternationContext(self, [2, 1], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.DIGITS, self.BARE_ID][choice0](parent=current)
            return current
    suffix_id.min_depth = 1

    def DIMENSION_ENTRY(self, parent=None):
        with RuleContext(self, UnlexerRule(name='DIMENSION_ENTRY', parent=parent)) as current:
            with AlternationContext(self, [0, 2], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                src = ['?', None][choice0]
                rule = [None, self.DIGITS][choice0]
                if src is not None:
                    UnlexerRule(src=src, parent=current)
                else:
                    rule(parent=current)
            UnlexerRule(src='x', parent=current)
            return current
    DIMENSION_ENTRY.min_depth = 0

    def static_dimension_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='static_dimension_list', parent=parent)) as current:
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=1, max=inf):
                    self.decimal_literal(parent=current)
                    UnlexerRule(src='x', parent=current)
            return current
    static_dimension_list.min_depth = 3

    def dimension_list_ranked(self, parent=None):
        with RuleContext(self, UnparserRule(name='dimension_list_ranked', parent=parent)) as current:
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=1, max=inf):
                    self.DIMENSION_ENTRY(parent=current)
            return current
    dimension_list_ranked.min_depth = 1

    def DIMENSION_LIST_UNRANKED(self, parent=None):
        with RuleContext(self, UnlexerRule(name='DIMENSION_LIST_UNRANKED', parent=parent)) as current:
            UnlexerRule(src='*x', parent=current)
            return current
    DIMENSION_LIST_UNRANKED.min_depth = 0

    def dimension_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='dimension_list', parent=parent)) as current:
            with AlternationContext(self, [2, 1], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.dimension_list_ranked, self.DIMENSION_LIST_UNRANKED][choice0](parent=current)
            return current
    dimension_list.min_depth = 1

    def ssa_id(self, parent=None):
        with RuleContext(self, UnparserRule(name='ssa_id', parent=parent)) as current:
            UnlexerRule(src='%', parent=current)
            self.suffix_id(parent=current)
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    UnlexerRule(src='#', parent=current)
                    self.DIGITS(parent=current)
            return current
    ssa_id.min_depth = 2

    def symbol_ref_id(self, parent=None):
        with RuleContext(self, UnparserRule(name='symbol_ref_id', parent=parent)) as current:
            UnlexerRule(src='@', parent=current)
            with AlternationContext(self, [2, 2], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.suffix_id, self.string_literal][choice0](parent=current)
            return current
    symbol_ref_id.min_depth = 2

    def block_id(self, parent=None):
        with RuleContext(self, UnparserRule(name='block_id', parent=parent)) as current:
            UnlexerRule(src='^', parent=current)
            self.suffix_id(parent=current)
            return current
    block_id.min_depth = 2

    def type_alias(self, parent=None):
        with RuleContext(self, UnparserRule(name='type_alias', parent=parent)) as current:
            UnlexerRule(src='!', parent=current)
            with AlternationContext(self, [2, 1], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.string_literal, self.BARE_ID][choice0](parent=current)
            return current
    type_alias.min_depth = 1

    def map_or_set_id(self, parent=None):
        with RuleContext(self, UnparserRule(name='map_or_set_id', parent=parent)) as current:
            UnlexerRule(src='#', parent=current)
            self.suffix_id(parent=current)
            return current
    map_or_set_id.min_depth = 2

    def attribute_alias(self, parent=None):
        with RuleContext(self, UnparserRule(name='attribute_alias', parent=parent)) as current:
            UnlexerRule(src='#', parent=current)
            with AlternationContext(self, [2, 1, 0], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                src = [None, None, 'loc'][choice0]
                rule = [self.string_literal, self.BARE_ID, None][choice0]
                if src is not None:
                    UnlexerRule(src=src, parent=current)
                else:
                    rule(parent=current)
            return current
    attribute_alias.min_depth = 0

    def ssa_id_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='ssa_id_list', parent=parent)) as current:
            self.ssa_id(parent=current)
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.ssa_id(parent=current)
            return current
    ssa_id_list.min_depth = 3

    def ssa_use(self, parent=None):
        with RuleContext(self, UnparserRule(name='ssa_use', parent=parent)) as current:
            with AlternationContext(self, [3, 2], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.ssa_id, self.constant_literal][choice0](parent=current)
            return current
    ssa_use.min_depth = 2

    def ssa_use_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='ssa_use_list', parent=parent)) as current:
            self.ssa_use(parent=current)
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.ssa_use(parent=current)
            return current
    ssa_use_list.min_depth = 3

    def none_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='none_type', parent=parent)) as current:
            self.NONE_TYPE_LITERAL(parent=current)
            return current
    none_type.min_depth = 1

    def index_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='index_type', parent=parent)) as current:
            self.INDEX_TYPE_LITERAL(parent=current)
            return current
    index_type.min_depth = 1

    def SIGNED_INTEGER_TYPE(self, parent=None):
        with RuleContext(self, UnlexerRule(name='SIGNED_INTEGER_TYPE', parent=parent)) as current:
            UnlexerRule(src='si', parent=current)
            self.NONZERO_DIGIT(parent=current)
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.DIGITS(parent=current)
            return current
    SIGNED_INTEGER_TYPE.min_depth = 1

    def UNSIGNED_INTEGER_TYPE(self, parent=None):
        with RuleContext(self, UnlexerRule(name='UNSIGNED_INTEGER_TYPE', parent=parent)) as current:
            UnlexerRule(src='ui', parent=current)
            self.NONZERO_DIGIT(parent=current)
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.DIGITS(parent=current)
            return current
    UNSIGNED_INTEGER_TYPE.min_depth = 1

    def SIGNLESS_INTEGER_TYPE(self, parent=None):
        with RuleContext(self, UnlexerRule(name='SIGNLESS_INTEGER_TYPE', parent=parent)) as current:
            UnlexerRule(src='i', parent=current)
            self.NONZERO_DIGIT(parent=current)
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.DIGITS(parent=current)
            return current
    SIGNLESS_INTEGER_TYPE.min_depth = 1

    def float_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='float_type', parent=parent)) as current:
            self.FLOAT_TYPE_LITERAL(parent=current)
            return current
    float_type.min_depth = 1

    def integer_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='integer_type', parent=parent)) as current:
            with AlternationContext(self, [2, 2, 2], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.SIGNED_INTEGER_TYPE, self.UNSIGNED_INTEGER_TYPE, self.SIGNLESS_INTEGER_TYPE][choice0](parent=current)
            return current
    integer_type.min_depth = 2

    def complex_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='complex_type', parent=parent)) as current:
            UnlexerRule(src='complex', parent=current)
            UnlexerRule(src='<', parent=current)
            self.type(parent=current)
            UnlexerRule(src='>', parent=current)
            return current
    complex_type.min_depth = 3

    def tuple_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='tuple_type', parent=parent)) as current:
            UnlexerRule(src='tuple', parent=current)
            UnlexerRule(src='<', parent=current)
            self.type_list_no_parens(parent=current)
            UnlexerRule(src='>', parent=current)
            return current
    tuple_type.min_depth = 4

    def vector_element_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='vector_element_type', parent=parent)) as current:
            with AlternationContext(self, [2, 3], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.float_type, self.integer_type][choice0](parent=current)
            return current
    vector_element_type.min_depth = 2

    def vector_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='vector_type', parent=parent)) as current:
            UnlexerRule(src='vector', parent=current)
            UnlexerRule(src='<', parent=current)
            self.static_dimension_list(parent=current)
            self.vector_element_type(parent=current)
            UnlexerRule(src='>', parent=current)
            return current
    vector_type.min_depth = 4

    def tensor_memref_element_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='tensor_memref_element_type', parent=parent)) as current:
            with AlternationContext(self, [3, 5, 4, 2], [1, 1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.vector_element_type, self.vector_type, self.complex_type, self.type_alias][choice0](parent=current)
            return current
    tensor_memref_element_type.min_depth = 2

    def ranked_tensor_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='ranked_tensor_type', parent=parent)) as current:
            UnlexerRule(src='tensor', parent=current)
            UnlexerRule(src='<', parent=current)
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.dimension_list_ranked(parent=current)
            self.tensor_memref_element_type(parent=current)
            UnlexerRule(src='>', parent=current)
            return current
    ranked_tensor_type.min_depth = 3

    def unranked_tensor_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='unranked_tensor_type', parent=parent)) as current:
            UnlexerRule(src='tensor', parent=current)
            UnlexerRule(src='<', parent=current)
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.DIMENSION_LIST_UNRANKED(parent=current)
            self.tensor_memref_element_type(parent=current)
            UnlexerRule(src='>', parent=current)
            return current
    unranked_tensor_type.min_depth = 3

    def tensor_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='tensor_type', parent=parent)) as current:
            with AlternationContext(self, [4, 4], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.ranked_tensor_type, self.unranked_tensor_type][choice0](parent=current)
            return current
    tensor_type.min_depth = 4

    def stride_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='stride_list', parent=parent)) as current:
            UnlexerRule(src='[', parent=current)
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    with AlternationContext(self, [0, 2], [1, 1]) as weights0:
                        choice0 = self._model.choice(current, 0, weights0)
                        src = ['?', None][choice0]
                        rule = [None, self.DIGITS][choice0]
                        if src is not None:
                            UnlexerRule(src=src, parent=current)
                        else:
                            rule(parent=current)
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 1, min=0, max=inf):
                            UnlexerRule(src=',', parent=current)
                            with AlternationContext(self, [0, 2], [1, 1]) as weights1:
                                choice1 = self._model.choice(current, 1, weights1)
                                src = ['?', None][choice1]
                                rule = [None, self.DIGITS][choice1]
                                if src is not None:
                                    UnlexerRule(src=src, parent=current)
                                else:
                                    rule(parent=current)
            UnlexerRule(src=']', parent=current)
            return current
    stride_list.min_depth = 0

    def strided_layout(self, parent=None):
        with RuleContext(self, UnparserRule(name='strided_layout', parent=parent)) as current:
            UnlexerRule(src='offset:', parent=current)
            with AlternationContext(self, [0, 2], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                src = ['?', None][choice0]
                rule = [None, self.DIGITS][choice0]
                if src is not None:
                    UnlexerRule(src=src, parent=current)
                else:
                    rule(parent=current)
            UnlexerRule(src=',', parent=current)
            UnlexerRule(src='strides: ', parent=current)
            self.stride_list(parent=current)
            return current
    strided_layout.min_depth = 1

    def layout_specification(self, parent=None):
        with RuleContext(self, UnparserRule(name='layout_specification', parent=parent)) as current:
            with AlternationContext(self, [4, 2], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.semi_affine_map, self.strided_layout][choice0](parent=current)
            return current
    layout_specification.min_depth = 2

    def memory_space(self, parent=None):
        with RuleContext(self, UnparserRule(name='memory_space', parent=parent)) as current:
            self.integer_literal(parent=current)
            return current
    memory_space.min_depth = 2

    def ranked_memref_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='ranked_memref_type', parent=parent)) as current:
            UnlexerRule(src='memref', parent=current)
            UnlexerRule(src='<', parent=current)
            self.dimension_list_ranked(parent=current)
            self.tensor_memref_element_type(parent=current)
            self.optional_layout_specification(parent=current)
            self.optional_memory_space(parent=current)
            UnlexerRule(src='>', parent=current)
            return current
    ranked_memref_type.min_depth = 3

    def unranked_memref_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='unranked_memref_type', parent=parent)) as current:
            UnlexerRule(src='memref', parent=current)
            UnlexerRule(src='<', parent=current)
            self.DIMENSION_LIST_UNRANKED(parent=current)
            self.tensor_memref_element_type(parent=current)
            self.optional_memory_space(parent=current)
            UnlexerRule(src='>', parent=current)
            return current
    unranked_memref_type.min_depth = 3

    def memref_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='memref_type', parent=parent)) as current:
            with AlternationContext(self, [4, 4], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.ranked_memref_type, self.unranked_memref_type][choice0](parent=current)
            return current
    memref_type.min_depth = 4

    def opaque_dialect_item(self, parent=None):
        with RuleContext(self, UnparserRule(name='opaque_dialect_item', parent=parent)) as current:
            self.BARE_ID(parent=current)
            UnlexerRule(src='<', parent=current)
            self.string_literal(parent=current)
            UnlexerRule(src='>', parent=current)
            return current
    opaque_dialect_item.min_depth = 2

    def pretty_dialect_item(self, parent=None):
        with RuleContext(self, UnparserRule(name='pretty_dialect_item', parent=parent)) as current:
            with AlternationContext(self, [1, 1], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    self.BARE_ID(parent=current)
                    if self._max_depth >= 3:
                        for _ in self._model.quantify(current, 0, min=0, max=1):
                            self.pretty_dialect_item_body(parent=current)
                elif choice0 == 1:
                    self.BARE_ID(parent=current)
                    UnlexerRule(src='.', parent=current)
                    with AlternationContext(self, [1, 1], [1, 1]) as weights1:
                        choice1 = self._model.choice(current, 1, weights1)
                        [self.BARE_ID, self.NONE_TYPE_LITERAL][choice1](parent=current)
                    if self._max_depth >= 3:
                        for _ in self._model.quantify(current, 1, min=0, max=1):
                            self.pretty_dialect_item_body(parent=current)
            return current
    pretty_dialect_item.min_depth = 1

    def pretty_dialect_item_body(self, parent=None):
        with RuleContext(self, UnparserRule(name='pretty_dialect_item_body', parent=parent)) as current:
            UnlexerRule(src='<', parent=current)
            self.pretty_dialect_item_contents(parent=current)
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.pretty_dialect_item_contents(parent=current)
            UnlexerRule(src='>', parent=current)
            return current
    pretty_dialect_item_body.min_depth = 2

    def pretty_dialect_item_contents(self, parent=None):
        with RuleContext(self, UnparserRule(name='pretty_dialect_item_contents', parent=parent)) as current:
            with AlternationContext(self, [2, 2, 2, 1, 2, 1, 3], [1, 1, 1, 1, 1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    UnlexerRule(src='(', parent=current)
                    self.pretty_dialect_item_contents(parent=current)
                    UnlexerRule(src=')', parent=current)
                elif choice0 == 1:
                    UnlexerRule(src='[', parent=current)
                    self.pretty_dialect_item_contents(parent=current)
                    UnlexerRule(src=']', parent=current)
                elif choice0 == 2:
                    UnlexerRule(src='{', parent=current)
                    self.pretty_dialect_item_contents(parent=current)
                    UnlexerRule(src='}', parent=current)
                elif choice0 == 3:
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 0, min=1, max=inf):
                            self.BARE_ID(parent=current)
                elif choice0 == 4:
                    self.constant_literal(parent=current)
                elif choice0 == 5:
                    self.stride_list(parent=current)
                elif choice0 == 6:
                    self.type(parent=current)
            return current
    pretty_dialect_item_contents.min_depth = 1

    def dialect_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='dialect_type', parent=parent)) as current:
            with AlternationContext(self, [2, 2, 2], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    UnlexerRule(src='!', parent=current)
                    with AlternationContext(self, [3, 2], [1, 1]) as weights1:
                        choice1 = self._model.choice(current, 1, weights1)
                        [self.opaque_dialect_item, self.pretty_dialect_item][choice1](parent=current)
                elif choice0 == 1:
                    UnlexerRule(src='uint<', parent=current)
                    self.DIGITS(parent=current)
                    UnlexerRule(src='>', parent=current)
                elif choice0 == 2:
                    UnlexerRule(src='!firrtl.uint<', parent=current)
                    self.DIGITS(parent=current)
                    UnlexerRule(src='>', parent=current)
            return current
    dialect_type.min_depth = 2

    def standard_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='standard_type', parent=parent)) as current:
            with AlternationContext(self, [4, 2, 3, 4, 2, 3, 5, 2, 5, 5, 5], [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.complex_type, self.float_type, self.function_type, self.llvm_function_type, self.index_type, self.integer_type, self.memref_type, self.none_type, self.tensor_type, self.tuple_type, self.vector_type][choice0](parent=current)
            return current
    standard_type.min_depth = 2

    def non_function_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='non_function_type', parent=parent)) as current:
            with AlternationContext(self, [2, 4, 2, 2, 3, 5, 2, 5, 5, 5, 3], [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.type_alias, self.complex_type, self.float_type, self.index_type, self.integer_type, self.memref_type, self.none_type, self.tensor_type, self.tuple_type, self.vector_type, self.dialect_type][choice0](parent=current)
            return current
    non_function_type.min_depth = 2

    def type(self, parent=None):
        with RuleContext(self, UnparserRule(name='type', parent=parent)) as current:
            with AlternationContext(self, [2, 3, 3], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.type_alias, self.dialect_type, self.standard_type][choice0](parent=current)
            return current
    type.min_depth = 2

    def type_list_no_parens(self, parent=None):
        with RuleContext(self, UnparserRule(name='type_list_no_parens', parent=parent)) as current:
            self.type(parent=current)
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.type(parent=current)
            return current
    type_list_no_parens.min_depth = 3

    def non_function_type_list_no_parens(self, parent=None):
        with RuleContext(self, UnparserRule(name='non_function_type_list_no_parens', parent=parent)) as current:
            self.non_function_type(parent=current)
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.non_function_type(parent=current)
            return current
    non_function_type_list_no_parens.min_depth = 3

    def type_list_parens(self, parent=None):
        with RuleContext(self, UnparserRule(name='type_list_parens', parent=parent)) as current:
            with AlternationContext(self, [0, 4], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    UnlexerRule(src='(', parent=current)
                    UnlexerRule(src=')', parent=current)
                elif choice0 == 1:
                    UnlexerRule(src='(', parent=current)
                    self.type_list_no_parens(parent=current)
                    UnlexerRule(src=')', parent=current)
            return current
    type_list_parens.min_depth = 0

    def non_function_type_list_parens(self, parent=None):
        with RuleContext(self, UnparserRule(name='non_function_type_list_parens', parent=parent)) as current:
            with AlternationContext(self, [0, 4], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    UnlexerRule(src='(', parent=current)
                    UnlexerRule(src=')', parent=current)
                elif choice0 == 1:
                    UnlexerRule(src='(', parent=current)
                    self.non_function_type_list_no_parens(parent=current)
                    UnlexerRule(src=')', parent=current)
            return current
    non_function_type_list_parens.min_depth = 0

    def function_result_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='function_result_type', parent=parent)) as current:
            with AlternationContext(self, [1, 4, 3], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.non_function_type_list_parens, self.non_function_type_list_no_parens, self.non_function_type][choice0](parent=current)
            return current
    function_result_type.min_depth = 1

    def function_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='function_type', parent=parent)) as current:
            self.function_result_type(parent=current)
            with AlternationContext(self, [0, 0, 0], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                UnlexerRule(src=['->', 'to', 'into'][choice0], parent=current)
            self.function_result_type(parent=current)
            return current
    function_type.min_depth = 2

    def llvm_function_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='llvm_function_type', parent=parent)) as current:
            self.non_function_type(parent=current)
            self.non_function_type_list_parens(parent=current)
            return current
    llvm_function_type.min_depth = 3

    def ssa_use_and_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='ssa_use_and_type', parent=parent)) as current:
            self.ssa_use(parent=current)
            UnlexerRule(src=':', parent=current)
            self.type(parent=current)
            return current
    ssa_use_and_type.min_depth = 3

    def ssa_use_and_type_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='ssa_use_and_type_list', parent=parent)) as current:
            self.ssa_use_and_type(parent=current)
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.ssa_use_and_type(parent=current)
            return current
    ssa_use_and_type_list.min_depth = 4

    def array_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='array_attribute', parent=parent)) as current:
            UnlexerRule(src='[', parent=current)
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.attribute_value(parent=current)
                    if self._max_depth >= 2:
                        for _ in self._model.quantify(current, 1, min=0, max=inf):
                            UnlexerRule(src=',', parent=current)
                            self.attribute_value(parent=current)
            UnlexerRule(src=']', parent=current)
            return current
    array_attribute.min_depth = 0

    def bool_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='bool_attribute', parent=parent)) as current:
            self.bool_literal(parent=current)
            return current
    bool_attribute.min_depth = 2

    def dictionary_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='dictionary_attribute', parent=parent)) as current:
            UnlexerRule(src='{', parent=current)
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.attribute_entry(parent=current)
                    if self._max_depth >= 2:
                        for _ in self._model.quantify(current, 1, min=0, max=inf):
                            UnlexerRule(src=',', parent=current)
                            self.attribute_entry(parent=current)
            UnlexerRule(src='}', parent=current)
            return current
    dictionary_attribute.min_depth = 0

    def elements_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='elements_attribute', parent=parent)) as current:
            with AlternationContext(self, [6, 6, 6], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.dense_elements_attribute, self.opaque_elements_attribute, self.sparse_elements_attribute][choice0](parent=current)
            return current
    elements_attribute.min_depth = 6

    def float_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='float_attribute', parent=parent)) as current:
            with AlternationContext(self, [1, 2], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    self.FLOAT_LITERAL(parent=current)
                    self.optional_float_type(parent=current)
                elif choice0 == 1:
                    self.HEXADECIMAL_LITERAL(parent=current)
                    UnlexerRule(src=':', parent=current)
                    self.float_type(parent=current)
            return current
    float_attribute.min_depth = 1

    def integer_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='integer_attribute', parent=parent)) as current:
            self.posneg_integer_literal(parent=current)
            self.optional_int_type(parent=current)
            return current
    integer_attribute.min_depth = 3

    def integer_set_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='integer_set_attribute', parent=parent)) as current:
            self.affine_map(parent=current)
            return current
    integer_set_attribute.min_depth = 4

    def string_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='string_attribute', parent=parent)) as current:
            self.string_literal(parent=current)
            self.optional_type(parent=current)
            return current
    string_attribute.min_depth = 2

    def symbol_ref_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='symbol_ref_attribute', parent=parent)) as current:
            self.symbol_ref_id(parent=current)
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src='::', parent=current)
                    self.symbol_ref_id(parent=current)
            return current
    symbol_ref_attribute.min_depth = 3

    def type_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='type_attribute', parent=parent)) as current:
            self.type(parent=current)
            return current
    type_attribute.min_depth = 3

    def unit_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='unit_attribute', parent=parent)) as current:
            UnlexerRule(src='unit', parent=current)
            return current
    unit_attribute.min_depth = 0

    def dense_elements_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='dense_elements_attribute', parent=parent)) as current:
            UnlexerRule(src='dense', parent=current)
            UnlexerRule(src='<', parent=current)
            self.attribute_value(parent=current)
            UnlexerRule(src='>', parent=current)
            UnlexerRule(src=':', parent=current)
            with AlternationContext(self, [5, 5], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.tensor_type, self.vector_type][choice0](parent=current)
            return current
    dense_elements_attribute.min_depth = 5

    def opaque_elements_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='opaque_elements_attribute', parent=parent)) as current:
            UnlexerRule(src='opaque', parent=current)
            UnlexerRule(src='<', parent=current)
            self.BARE_ID(parent=current)
            UnlexerRule(src=',', parent=current)
            self.HEXADECIMAL_LITERAL(parent=current)
            UnlexerRule(src='>', parent=current)
            UnlexerRule(src=':', parent=current)
            with AlternationContext(self, [5, 5], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.tensor_type, self.vector_type][choice0](parent=current)
            return current
    opaque_elements_attribute.min_depth = 5

    def sparse_elements_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='sparse_elements_attribute', parent=parent)) as current:
            UnlexerRule(src='sparse', parent=current)
            UnlexerRule(src='<', parent=current)
            self.attribute_value(parent=current)
            UnlexerRule(src=',', parent=current)
            self.attribute_value(parent=current)
            UnlexerRule(src='>', parent=current)
            UnlexerRule(src=':', parent=current)
            with AlternationContext(self, [5, 5], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.tensor_type, self.vector_type][choice0](parent=current)
            return current
    sparse_elements_attribute.min_depth = 5

    def standard_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='standard_attribute', parent=parent)) as current:
            with AlternationContext(self, [1, 3, 1, 7, 2, 4, 5, 3, 4, 4, 1], [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.array_attribute, self.bool_attribute, self.dictionary_attribute, self.elements_attribute, self.float_attribute, self.integer_attribute, self.integer_set_attribute, self.string_attribute, self.symbol_ref_attribute, self.type_attribute, self.unit_attribute][choice0](parent=current)
            return current
    standard_attribute.min_depth = 1

    def attribute_value(self, parent=None):
        with RuleContext(self, UnparserRule(name='attribute_value', parent=parent)) as current:
            with AlternationContext(self, [1, 3, 2], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.attribute_alias, self.dialect_attribute, self.standard_attribute][choice0](parent=current)
            return current
    attribute_value.min_depth = 1

    def unit_attribute_entry(self, parent=None):
        with RuleContext(self, UnparserRule(name='unit_attribute_entry', parent=parent)) as current:
            UnlexerRule(src='value', parent=current)
            return current
    unit_attribute_entry.min_depth = 0

    def dependent_attribute_entry(self, parent=None):
        with RuleContext(self, UnparserRule(name='dependent_attribute_entry', parent=parent)) as current:
            with AlternationContext(self, [1, 0, 1], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                src = [None, 'module', None][choice0]
                rule = [self.BARE_ID, None, self.unit_attribute_entry][choice0]
                if src is not None:
                    UnlexerRule(src=src, parent=current)
                else:
                    rule(parent=current)
            UnlexerRule(src='=', parent=current)
            self.attribute_value(parent=current)
            return current
    dependent_attribute_entry.min_depth = 2

    def dialect_attribute_entry(self, parent=None):
        with RuleContext(self, UnparserRule(name='dialect_attribute_entry', parent=parent)) as current:
            with AlternationContext(self, [1, 2, 2], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    self.BARE_ID(parent=current)
                    UnlexerRule(src='.', parent=current)
                    self.BARE_ID(parent=current)
                elif choice0 == 1:
                    self.BARE_ID(parent=current)
                    UnlexerRule(src='.', parent=current)
                    self.BARE_ID(parent=current)
                    UnlexerRule(src='=', parent=current)
                    self.attribute_value(parent=current)
                elif choice0 == 2:
                    self.string_literal(parent=current)
                    UnlexerRule(src='=', parent=current)
                    self.attribute_value(parent=current)
            return current
    dialect_attribute_entry.min_depth = 1

    def dialect_attribute(self, parent=None):
        with RuleContext(self, UnparserRule(name='dialect_attribute', parent=parent)) as current:
            UnlexerRule(src='#', parent=current)
            with AlternationContext(self, [3, 2], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.opaque_dialect_item, self.pretty_dialect_item][choice0](parent=current)
            return current
    dialect_attribute.min_depth = 2

    def property_dict(self, parent=None):
        with RuleContext(self, UnparserRule(name='property_dict', parent=parent)) as current:
            UnlexerRule(src='<', parent=current)
            self.attribute_dict(parent=current)
            UnlexerRule(src='>', parent=current)
            return current
    property_dict.min_depth = 1

    def attribute_entry(self, parent=None):
        with RuleContext(self, UnparserRule(name='attribute_entry', parent=parent)) as current:
            with AlternationContext(self, [2, 3, 1], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.dialect_attribute_entry, self.dependent_attribute_entry, self.unit_attribute_entry][choice0](parent=current)
            return current
    attribute_entry.min_depth = 1

    def attribute_dict(self, parent=None):
        with RuleContext(self, UnparserRule(name='attribute_dict', parent=parent)) as current:
            with AlternationContext(self, [0, 2], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    UnlexerRule(src='{', parent=current)
                    UnlexerRule(src='}', parent=current)
                elif choice0 == 1:
                    UnlexerRule(src='{', parent=current)
                    self.attribute_entry(parent=current)
                    if self._max_depth >= 2:
                        for _ in self._model.quantify(current, 0, min=0, max=inf):
                            UnlexerRule(src=',', parent=current)
                            self.attribute_entry(parent=current)
                    UnlexerRule(src='}', parent=current)
            return current
    attribute_dict.min_depth = 0

    def trailing_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='trailing_type', parent=parent)) as current:
            UnlexerRule(src=':', parent=current)
            with AlternationContext(self, [3, 2], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.function_type, self.function_result_type][choice0](parent=current)
            return current
    trailing_type.min_depth = 2

    def op_result(self, parent=None):
        with RuleContext(self, UnparserRule(name='op_result', parent=parent)) as current:
            self.ssa_id(parent=current)
            self.optional_int_literal(parent=current)
            return current
    op_result.min_depth = 3

    def op_result_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='op_result_list', parent=parent)) as current:
            self.op_result(parent=current)
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.op_result(parent=current)
            UnlexerRule(src='=', parent=current)
            return current
    op_result_list.min_depth = 4

    def location(self, parent=None):
        with RuleContext(self, UnparserRule(name='location', parent=parent)) as current:
            self.string_literal(parent=current)
            UnlexerRule(src=':', parent=current)
            self.decimal_literal(parent=current)
            UnlexerRule(src=':', parent=current)
            self.decimal_literal(parent=current)
            return current
    location.min_depth = 3

    def trailing_location(self, parent=None):
        with RuleContext(self, UnparserRule(name='trailing_location', parent=parent)) as current:
            UnlexerRule(src='loc', parent=current)
            UnlexerRule(src='(', parent=current)
            self.location(parent=current)
            UnlexerRule(src=')', parent=current)
            return current
    trailing_location.min_depth = 4

    def generic_operation(self, parent=None):
        with RuleContext(self, UnparserRule(name='generic_operation', parent=parent)) as current:
            self.string_literal(parent=current)
            UnlexerRule(src='(', parent=current)
            self.optional_ssa_use_list(parent=current)
            UnlexerRule(src=')', parent=current)
            self.optional_successor_list(parent=current)
            self.optional_prop_dict(parent=current)
            self.optional_region_list(parent=current)
            self.optional_attr_dict(parent=current)
            self.trailing_type(parent=current)
            return current
    generic_operation.min_depth = 3

    def custom_operation(self, parent=None):
        with RuleContext(self, UnparserRule(name='custom_operation', parent=parent)) as current:
            self.BARE_ID(parent=current)
            UnlexerRule(src='.', parent=current)
            self.BARE_ID(parent=current)
            self.optional_ssa_use_list(parent=current)
            self.trailing_type(parent=current)
            return current
    custom_operation.min_depth = 3

    def operation(self, parent=None):
        with RuleContext(self, UnparserRule(name='operation', parent=parent)) as current:
            self.optional_op_result_list(parent=current)
            with AlternationContext(self, [4, 4, 2, 4, 4], [1, 1, 1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.custom_operation, self.generic_operation, self.module, self.generic_module, self.function][choice0](parent=current)
            self.optional_trailing_loc(parent=current)
            return current
    operation.min_depth = 2

    def ssa_id_and_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='ssa_id_and_type', parent=parent)) as current:
            self.ssa_id(parent=current)
            UnlexerRule(src=':', parent=current)
            self.type(parent=current)
            return current
    ssa_id_and_type.min_depth = 3

    def ssa_id_and_type_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='ssa_id_and_type_list', parent=parent)) as current:
            self.ssa_id_and_type(parent=current)
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.ssa_id_and_type(parent=current)
            return current
    ssa_id_and_type_list.min_depth = 4

    def block_arg_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='block_arg_list', parent=parent)) as current:
            UnlexerRule(src='(', parent=current)
            self.optional_ssa_and_type_list(parent=current)
            UnlexerRule(src=')', parent=current)
            return current
    block_arg_list.min_depth = 1

    def operation_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='operation_list', parent=parent)) as current:
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=1, max=inf):
                    self.operation(parent=current)
            return current
    operation_list.min_depth = 3

    def block_label(self, parent=None):
        with RuleContext(self, UnparserRule(name='block_label', parent=parent)) as current:
            self.block_id(parent=current)
            self.optional_block_arg_list(parent=current)
            UnlexerRule(src=':', parent=current)
            return current
    block_label.min_depth = 3

    def successor_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='successor_list', parent=parent)) as current:
            UnlexerRule(src='[', parent=current)
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.block_id(parent=current)
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 1, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.block_id(parent=current)
            UnlexerRule(src=']', parent=current)
            return current
    successor_list.min_depth = 0

    def block(self, parent=None):
        with RuleContext(self, UnparserRule(name='block', parent=parent)) as current:
            self.optional_block_label(parent=current)
            self.operation_list(parent=current)
            return current
    block.min_depth = 4

    def region(self, parent=None):
        with RuleContext(self, UnparserRule(name='region', parent=parent)) as current:
            UnlexerRule(src='{', parent=current)
            if self._max_depth >= 5:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    self.block(parent=current)
            UnlexerRule(src='}', parent=current)
            return current
    region.min_depth = 0

    def region_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='region_list', parent=parent)) as current:
            UnlexerRule(src='(', parent=current)
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.region(parent=current)
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 1, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.region(parent=current)
            UnlexerRule(src=')', parent=current)
            return current
    region_list.min_depth = 0

    def optional_symbol_ref_id(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_symbol_ref_id', parent=parent)) as current:
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.symbol_ref_id(parent=current)
            return current
    optional_symbol_ref_id.min_depth = 0

    def optional_func_mod_attrs(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_func_mod_attrs', parent=parent)) as current:
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    UnlexerRule(src='attributes', parent=current)
                    self.attribute_dict(parent=current)
            return current
    optional_func_mod_attrs.min_depth = 0

    def optional_arg_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_arg_list', parent=parent)) as current:
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.argument_list(parent=current)
            return current
    optional_arg_list.min_depth = 0

    def optional_fn_result_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_fn_result_list', parent=parent)) as current:
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    UnlexerRule(src='->', parent=current)
                    self.function_result_list(parent=current)
            return current
    optional_fn_result_list.min_depth = 0

    def optional_fn_body(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_fn_body', parent=parent)) as current:
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.function_body(parent=current)
            return current
    optional_fn_body.min_depth = 0

    def optional_symbol_id_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_symbol_id_list', parent=parent)) as current:
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.symbol_id_list(parent=current)
            return current
    optional_symbol_id_list.min_depth = 0

    def optional_affine_constraint_conjunction(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_affine_constraint_conjunction', parent=parent)) as current:
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.affine_constraint_conjunction(parent=current)
            return current
    optional_affine_constraint_conjunction.min_depth = 0

    def optional_float_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_float_type', parent=parent)) as current:
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    UnlexerRule(src=':', parent=current)
                    self.float_type(parent=current)
            return current
    optional_float_type.min_depth = 0

    def optional_int_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_int_type', parent=parent)) as current:
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    UnlexerRule(src=':', parent=current)
                    with AlternationContext(self, [2, 3], [1, 1]) as weights0:
                        choice0 = self._model.choice(current, 0, weights0)
                        [self.index_type, self.integer_type][choice0](parent=current)
            return current
    optional_int_type.min_depth = 0

    def optional_type(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_type', parent=parent)) as current:
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    UnlexerRule(src=':', parent=current)
                    self.type(parent=current)
            return current
    optional_type.min_depth = 0

    def optional_int_literal(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_int_literal', parent=parent)) as current:
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    UnlexerRule(src=':', parent=current)
                    self.integer_literal(parent=current)
            return current
    optional_int_literal.min_depth = 0

    def optional_ssa_use_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_ssa_use_list', parent=parent)) as current:
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.ssa_use_list(parent=current)
            return current
    optional_ssa_use_list.min_depth = 0

    def optional_prop_dict(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_prop_dict', parent=parent)) as current:
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.property_dict(parent=current)
            return current
    optional_prop_dict.min_depth = 0

    def optional_attr_dict(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_attr_dict', parent=parent)) as current:
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.attribute_dict(parent=current)
            return current
    optional_attr_dict.min_depth = 0

    def optional_trailing_loc(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_trailing_loc', parent=parent)) as current:
            if self._max_depth >= 5:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.trailing_location(parent=current)
            return current
    optional_trailing_loc.min_depth = 0

    def optional_op_result_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_op_result_list', parent=parent)) as current:
            if self._max_depth >= 5:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.op_result_list(parent=current)
            return current
    optional_op_result_list.min_depth = 0

    def optional_ssa_and_type_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_ssa_and_type_list', parent=parent)) as current:
            if self._max_depth >= 5:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.ssa_id_and_type_list(parent=current)
            return current
    optional_ssa_and_type_list.min_depth = 0

    def optional_block_arg_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_block_arg_list', parent=parent)) as current:
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.block_arg_list(parent=current)
            return current
    optional_block_arg_list.min_depth = 0

    def optional_layout_specification(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_layout_specification', parent=parent)) as current:
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    UnlexerRule(src=',', parent=current)
                    self.layout_specification(parent=current)
            return current
    optional_layout_specification.min_depth = 0

    def optional_memory_space(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_memory_space', parent=parent)) as current:
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    UnlexerRule(src=',', parent=current)
                    self.memory_space(parent=current)
            return current
    optional_memory_space.min_depth = 0

    def optional_block_label(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_block_label', parent=parent)) as current:
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.block_label(parent=current)
            return current
    optional_block_label.min_depth = 0

    def optional_symbol_use_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_symbol_use_list', parent=parent)) as current:
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.symbol_use_list(parent=current)
            return current
    optional_symbol_use_list.min_depth = 0

    def optional_successor_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_successor_list', parent=parent)) as current:
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.successor_list(parent=current)
            return current
    optional_successor_list.min_depth = 0

    def optional_region_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='optional_region_list', parent=parent)) as current:
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.region_list(parent=current)
            return current
    optional_region_list.min_depth = 0

    def named_argument(self, parent=None):
        with RuleContext(self, UnparserRule(name='named_argument', parent=parent)) as current:
            self.ssa_id(parent=current)
            UnlexerRule(src=':', parent=current)
            self.type(parent=current)
            self.optional_attr_dict(parent=current)
            return current
    named_argument.min_depth = 3

    def argument_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='argument_list', parent=parent)) as current:
            with AlternationContext(self, [4, 3], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    self.named_argument(parent=current)
                    if self._max_depth >= 4:
                        for _ in self._model.quantify(current, 0, min=0, max=inf):
                            UnlexerRule(src=',', parent=current)
                            self.named_argument(parent=current)
                elif choice0 == 1:
                    self.type(parent=current)
                    self.optional_attr_dict(parent=current)
                    if self._max_depth >= 3:
                        for _ in self._model.quantify(current, 1, min=0, max=inf):
                            UnlexerRule(src=',', parent=current)
                            self.type(parent=current)
                            self.optional_attr_dict(parent=current)
            return current
    argument_list.min_depth = 3

    def function_result(self, parent=None):
        with RuleContext(self, UnparserRule(name='function_result', parent=parent)) as current:
            self.type(parent=current)
            self.optional_attr_dict(parent=current)
            return current
    function_result.min_depth = 3

    def function_result_list_no_parens(self, parent=None):
        with RuleContext(self, UnparserRule(name='function_result_list_no_parens', parent=parent)) as current:
            self.function_result(parent=current)
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.function_result(parent=current)
            return current
    function_result_list_no_parens.min_depth = 4

    def function_result_list_parens(self, parent=None):
        with RuleContext(self, UnparserRule(name='function_result_list_parens', parent=parent)) as current:
            with AlternationContext(self, [0, 5], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    UnlexerRule(src='(', parent=current)
                    UnlexerRule(src=')', parent=current)
                elif choice0 == 1:
                    UnlexerRule(src='(', parent=current)
                    self.function_result_list_no_parens(parent=current)
                    UnlexerRule(src=')', parent=current)
            return current
    function_result_list_parens.min_depth = 0

    def function_result_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='function_result_list', parent=parent)) as current:
            with AlternationContext(self, [1, 3], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.function_result_list_parens, self.non_function_type][choice0](parent=current)
            return current
    function_result_list.min_depth = 1

    def function_body(self, parent=None):
        with RuleContext(self, UnparserRule(name='function_body', parent=parent)) as current:
            self.region(parent=current)
            return current
    function_body.min_depth = 1

    def module(self, parent=None):
        with RuleContext(self, UnparserRule(name='module', parent=parent)) as current:
            UnlexerRule(src='module', parent=current)
            self.optional_symbol_ref_id(parent=current)
            self.optional_func_mod_attrs(parent=current)
            self.region(parent=current)
            self.optional_trailing_loc(parent=current)
            return current
    module.min_depth = 1

    def function(self, parent=None):
        with RuleContext(self, UnparserRule(name='function', parent=parent)) as current:
            UnlexerRule(src='func.func', parent=current)
            self.symbol_ref_id(parent=current)
            UnlexerRule(src='(', parent=current)
            self.optional_arg_list(parent=current)
            UnlexerRule(src=')', parent=current)
            self.optional_fn_result_list(parent=current)
            self.optional_func_mod_attrs(parent=current)
            self.optional_fn_body(parent=current)
            self.optional_trailing_loc(parent=current)
            return current
    function.min_depth = 3

    def generic_module(self, parent=None):
        with RuleContext(self, UnparserRule(name='generic_module', parent=parent)) as current:
            self.string_literal(parent=current)
            UnlexerRule(src='(', parent=current)
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.argument_list(parent=current)
            UnlexerRule(src=')', parent=current)
            UnlexerRule(src='(', parent=current)
            self.region(parent=current)
            UnlexerRule(src=')', parent=current)
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 1, min=0, max=1):
                    self.attribute_dict(parent=current)
            self.trailing_type(parent=current)
            if self._max_depth >= 5:
                for _ in self._model.quantify(current, 2, min=0, max=1):
                    self.trailing_location(parent=current)
            return current
    generic_module.min_depth = 3

    def dim_id_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='dim_id_list', parent=parent)) as current:
            UnlexerRule(src='(', parent=current)
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.BARE_ID(parent=current)
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 1, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.BARE_ID(parent=current)
            UnlexerRule(src=')', parent=current)
            return current
    dim_id_list.min_depth = 0

    def symbol_id_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='symbol_id_list', parent=parent)) as current:
            UnlexerRule(src='[', parent=current)
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.BARE_ID(parent=current)
            if self._max_depth >= 1:
                for _ in self._model.quantify(current, 1, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.BARE_ID(parent=current)
            UnlexerRule(src=']', parent=current)
            return current
    symbol_id_list.min_depth = 0

    def dim_and_symbol_id_lists(self, parent=None):
        with RuleContext(self, UnparserRule(name='dim_and_symbol_id_lists', parent=parent)) as current:
            self.dim_id_list(parent=current)
            self.optional_symbol_id_list(parent=current)
            return current
    dim_and_symbol_id_lists.min_depth = 1

    def symbol_or_const(self, parent=None):
        with RuleContext(self, UnparserRule(name='symbol_or_const', parent=parent)) as current:
            with AlternationContext(self, [3, 3, 1], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.posneg_integer_literal, self.ssa_id, self.BARE_ID][choice0](parent=current)
            return current
    symbol_or_const.min_depth = 1

    def dim_use_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='dim_use_list', parent=parent)) as current:
            UnlexerRule(src='(', parent=current)
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.ssa_use_list(parent=current)
            UnlexerRule(src=')', parent=current)
            return current
    dim_use_list.min_depth = 0

    def symbol_use_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='symbol_use_list', parent=parent)) as current:
            UnlexerRule(src='[', parent=current)
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    self.ssa_use_list(parent=current)
            UnlexerRule(src=']', parent=current)
            return current
    symbol_use_list.min_depth = 0

    def dim_and_symbol_use_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='dim_and_symbol_use_list', parent=parent)) as current:
            self.dim_use_list(parent=current)
            self.optional_symbol_use_list(parent=current)
            return current
    dim_and_symbol_use_list.min_depth = 1

    def affine_expr(self, parent=None):
        with RuleContext(self, UnparserRule(name='affine_expr', parent=parent)) as current:
            with AlternationContext(self, [2, 2, 2, 3, 3, 2, 2, 2, 2, 3, 3, 3, 1], [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    UnlexerRule(src='(', parent=current)
                    self.affine_expr(parent=current)
                    UnlexerRule(src=')', parent=current)
                elif choice0 == 1:
                    self.affine_expr(parent=current)
                    UnlexerRule(src='+', parent=current)
                    self.affine_expr(parent=current)
                elif choice0 == 2:
                    self.affine_expr(parent=current)
                    UnlexerRule(src='-', parent=current)
                    self.affine_expr(parent=current)
                elif choice0 == 3:
                    self.posneg_integer_literal(parent=current)
                    UnlexerRule(src='*', parent=current)
                    self.affine_expr(parent=current)
                elif choice0 == 4:
                    self.affine_expr(parent=current)
                    UnlexerRule(src='*', parent=current)
                    self.posneg_integer_literal(parent=current)
                elif choice0 == 5:
                    self.affine_expr(parent=current)
                    UnlexerRule(src='&ceildiv&', parent=current)
                    self.integer_literal(parent=current)
                elif choice0 == 6:
                    self.affine_expr(parent=current)
                    UnlexerRule(src='&floordiv&', parent=current)
                    self.integer_literal(parent=current)
                elif choice0 == 7:
                    self.affine_expr(parent=current)
                    UnlexerRule(src='&mod&', parent=current)
                    self.integer_literal(parent=current)
                elif choice0 == 8:
                    UnlexerRule(src='-', parent=current)
                    self.affine_expr(parent=current)
                elif choice0 == 9:
                    UnlexerRule(src='symbol', parent=current)
                    UnlexerRule(src='(', parent=current)
                    self.ssa_id(parent=current)
                    UnlexerRule(src=')', parent=current)
                elif choice0 == 10:
                    self.posneg_integer_literal(parent=current)
                elif choice0 == 11:
                    self.ssa_id(parent=current)
                elif choice0 == 12:
                    self.BARE_ID(parent=current)
            return current
    affine_expr.min_depth = 1

    def semi_affine_expr(self, parent=None):
        with RuleContext(self, UnparserRule(name='semi_affine_expr', parent=parent)) as current:
            with AlternationContext(self, [3, 3, 3, 3, 3, 3, 3, 3, 2, 2], [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    UnlexerRule(src='(', parent=current)
                    self.semi_affine_expr(parent=current)
                    UnlexerRule(src=')', parent=current)
                elif choice0 == 1:
                    self.semi_affine_expr(parent=current)
                    UnlexerRule(src='+', parent=current)
                    self.semi_affine_expr(parent=current)
                elif choice0 == 2:
                    self.semi_affine_expr(parent=current)
                    UnlexerRule(src='-', parent=current)
                    self.semi_affine_expr(parent=current)
                elif choice0 == 3:
                    self.symbol_or_const(parent=current)
                    UnlexerRule(src='*', parent=current)
                    self.semi_affine_expr(parent=current)
                elif choice0 == 4:
                    self.semi_affine_expr(parent=current)
                    UnlexerRule(src='*', parent=current)
                    self.symbol_or_const(parent=current)
                elif choice0 == 5:
                    self.semi_affine_expr(parent=current)
                    UnlexerRule(src='&ceildiv&', parent=current)
                    self.semi_affine_oprnd(parent=current)
                elif choice0 == 6:
                    self.semi_affine_expr(parent=current)
                    UnlexerRule(src='&floordiv&', parent=current)
                    self.semi_affine_oprnd(parent=current)
                elif choice0 == 7:
                    self.semi_affine_expr(parent=current)
                    UnlexerRule(src='&mod&', parent=current)
                    self.semi_affine_oprnd(parent=current)
                elif choice0 == 8:
                    UnlexerRule(src='symbol', parent=current)
                    UnlexerRule(src='(', parent=current)
                    self.symbol_or_const(parent=current)
                    UnlexerRule(src=')', parent=current)
                elif choice0 == 9:
                    self.symbol_or_const(parent=current)
            return current
    semi_affine_expr.min_depth = 2

    def semi_affine_oprnd(self, parent=None):
        with RuleContext(self, UnparserRule(name='semi_affine_oprnd', parent=parent)) as current:
            with AlternationContext(self, [2, 3], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    self.symbol_or_const(parent=current)
                elif choice0 == 1:
                    UnlexerRule(src='(', parent=current)
                    self.semi_affine_expr(parent=current)
                    UnlexerRule(src=')', parent=current)
            return current
    semi_affine_oprnd.min_depth = 2

    def multi_dim_affine_expr_no_parens(self, parent=None):
        with RuleContext(self, UnparserRule(name='multi_dim_affine_expr_no_parens', parent=parent)) as current:
            self.affine_expr(parent=current)
            if self._max_depth >= 2:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.affine_expr(parent=current)
            return current
    multi_dim_affine_expr_no_parens.min_depth = 2

    def multi_dim_semi_affine_expr_no_parens(self, parent=None):
        with RuleContext(self, UnparserRule(name='multi_dim_semi_affine_expr_no_parens', parent=parent)) as current:
            self.semi_affine_expr(parent=current)
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.semi_affine_expr(parent=current)
            return current
    multi_dim_semi_affine_expr_no_parens.min_depth = 3

    def multi_dim_affine_expr(self, parent=None):
        with RuleContext(self, UnparserRule(name='multi_dim_affine_expr', parent=parent)) as current:
            UnlexerRule(src='(', parent=current)
            self.multi_dim_affine_expr_no_parens(parent=current)
            UnlexerRule(src=')', parent=current)
            return current
    multi_dim_affine_expr.min_depth = 3

    def multi_dim_semi_affine_expr(self, parent=None):
        with RuleContext(self, UnparserRule(name='multi_dim_semi_affine_expr', parent=parent)) as current:
            UnlexerRule(src='(', parent=current)
            self.multi_dim_semi_affine_expr_no_parens(parent=current)
            UnlexerRule(src=')', parent=current)
            return current
    multi_dim_semi_affine_expr.min_depth = 4

    def affine_constraint(self, parent=None):
        with RuleContext(self, UnparserRule(name='affine_constraint', parent=parent)) as current:
            with AlternationContext(self, [2, 2], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    self.affine_expr(parent=current)
                    UnlexerRule(src='>=', parent=current)
                    self.DIGIT(parent=current)
                elif choice0 == 1:
                    self.affine_expr(parent=current)
                    UnlexerRule(src='==', parent=current)
                    self.DIGIT(parent=current)
            return current
    affine_constraint.min_depth = 2

    def affine_constraint_conjunction(self, parent=None):
        with RuleContext(self, UnparserRule(name='affine_constraint_conjunction', parent=parent)) as current:
            self.affine_constraint(parent=current)
            if self._max_depth >= 3:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.affine_constraint(parent=current)
            return current
    affine_constraint_conjunction.min_depth = 3

    def affine_map_inline(self, parent=None):
        with RuleContext(self, UnparserRule(name='affine_map_inline', parent=parent)) as current:
            UnlexerRule(src='affine_map', parent=current)
            UnlexerRule(src='<', parent=current)
            self.dim_and_symbol_id_lists(parent=current)
            UnlexerRule(src='->', parent=current)
            self.multi_dim_affine_expr(parent=current)
            UnlexerRule(src='>', parent=current)
            return current
    affine_map_inline.min_depth = 4

    def semi_affine_map_inline(self, parent=None):
        with RuleContext(self, UnparserRule(name='semi_affine_map_inline', parent=parent)) as current:
            self.dim_and_symbol_id_lists(parent=current)
            UnlexerRule(src='->', parent=current)
            self.multi_dim_semi_affine_expr(parent=current)
            return current
    semi_affine_map_inline.min_depth = 5

    def integer_set_inline(self, parent=None):
        with RuleContext(self, UnparserRule(name='integer_set_inline', parent=parent)) as current:
            self.dim_and_symbol_id_lists(parent=current)
            UnlexerRule(src=':', parent=current)
            UnlexerRule(src='(', parent=current)
            self.optional_affine_constraint_conjunction(parent=current)
            UnlexerRule(src=')', parent=current)
            return current
    integer_set_inline.min_depth = 2

    def affine_map(self, parent=None):
        with RuleContext(self, UnparserRule(name='affine_map', parent=parent)) as current:
            with AlternationContext(self, [3, 5], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.map_or_set_id, self.affine_map_inline][choice0](parent=current)
            return current
    affine_map.min_depth = 3

    def semi_affine_map(self, parent=None):
        with RuleContext(self, UnparserRule(name='semi_affine_map', parent=parent)) as current:
            with AlternationContext(self, [3, 6], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.map_or_set_id, self.semi_affine_map_inline][choice0](parent=current)
            return current
    semi_affine_map.min_depth = 3

    def integer_set(self, parent=None):
        with RuleContext(self, UnparserRule(name='integer_set', parent=parent)) as current:
            with AlternationContext(self, [3, 3], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.map_or_set_id, self.integer_set_inline][choice0](parent=current)
            return current
    integer_set.min_depth = 3

    def affine_map_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='affine_map_list', parent=parent)) as current:
            self.affine_map(parent=current)
            if self._max_depth >= 4:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    UnlexerRule(src=',', parent=current)
                    self.affine_map(parent=current)
            return current
    affine_map_list.min_depth = 4

    def type_alias_def(self, parent=None):
        with RuleContext(self, UnparserRule(name='type_alias_def', parent=parent)) as current:
            self.type_alias(parent=current)
            UnlexerRule(src='=', parent=current)
            UnlexerRule(src='type', parent=current)
            self.type(parent=current)
            return current
    type_alias_def.min_depth = 3

    def affine_map_def(self, parent=None):
        with RuleContext(self, UnparserRule(name='affine_map_def', parent=parent)) as current:
            self.map_or_set_id(parent=current)
            UnlexerRule(src='=', parent=current)
            self.affine_map_inline(parent=current)
            return current
    affine_map_def.min_depth = 5

    def semi_affine_map_def(self, parent=None):
        with RuleContext(self, UnparserRule(name='semi_affine_map_def', parent=parent)) as current:
            self.map_or_set_id(parent=current)
            UnlexerRule(src='=', parent=current)
            self.semi_affine_map_inline(parent=current)
            return current
    semi_affine_map_def.min_depth = 6

    def integer_set_def(self, parent=None):
        with RuleContext(self, UnparserRule(name='integer_set_def', parent=parent)) as current:
            self.map_or_set_id(parent=current)
            UnlexerRule(src='=', parent=current)
            self.integer_set_inline(parent=current)
            return current
    integer_set_def.min_depth = 3

    def attribute_alias_def(self, parent=None):
        with RuleContext(self, UnparserRule(name='attribute_alias_def', parent=parent)) as current:
            self.attribute_alias(parent=current)
            UnlexerRule(src='=', parent=current)
            with AlternationContext(self, [2, 5], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.attribute_value, self.trailing_location][choice0](parent=current)
            return current
    attribute_alias_def.min_depth = 2

    def definition(self, parent=None):
        with RuleContext(self, UnparserRule(name='definition', parent=parent)) as current:
            with AlternationContext(self, [4, 6, 7, 4, 3], [1, 1, 1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                [self.type_alias_def, self.affine_map_def, self.semi_affine_map_def, self.integer_set_def, self.attribute_alias_def][choice0](parent=current)
            return current
    definition.min_depth = 3

    def definition_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='definition_list', parent=parent)) as current:
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=1, max=inf):
                    self.definition(parent=current)
            return current
    definition_list.min_depth = 4

    def function_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='function_list', parent=parent)) as current:
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=1, max=inf):
                    self.function(parent=current)
            return current
    function_list.min_depth = 4

    def module_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='module_list', parent=parent)) as current:
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=1, max=inf):
                    with AlternationContext(self, [2, 4], [1, 1]) as weights0:
                        choice0 = self._model.choice(current, 0, weights0)
                        [self.module, self.generic_module][choice0](parent=current)
            return current
    module_list.min_depth = 2

    def definition_and_function_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='definition_and_function_list', parent=parent)) as current:
            with AlternationContext(self, [5, 5, 5], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    self.definition_list(parent=current)
                elif choice0 == 1:
                    self.function_list(parent=current)
                elif choice0 == 2:
                    self.definition_list(parent=current)
                    self.function_list(parent=current)
            return current
    definition_and_function_list.min_depth = 5

    def definition_and_module_list(self, parent=None):
        with RuleContext(self, UnparserRule(name='definition_and_module_list', parent=parent)) as current:
            with AlternationContext(self, [5, 3, 5], [1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    self.definition_list(parent=current)
                elif choice0 == 1:
                    self.module_list(parent=current)
                elif choice0 == 2:
                    self.definition_list(parent=current)
                    self.module_list(parent=current)
            return current
    definition_and_module_list.min_depth = 3

    def mlir_file(self, parent=None):
        with RuleContext(self, UnparserRule(name='mlir_file', parent=parent)) as current:
            with AlternationContext(self, [6, 4], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 0, min=1, max=inf):
                            self.definition_and_function_list(parent=current)
                elif choice0 == 1:
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 1, min=1, max=inf):
                            self.definition_and_module_list(parent=current)
            return current
    mlir_file.min_depth = 4

    def start_rule(self, parent=None):
        with RuleContext(self, UnparserRule(name='start_rule', parent=parent)) as current:
            self.mlir_file(parent=current)
            return current
    start_rule.min_depth = 5

    def ESCAPED_STRING(self, parent=None):
        with RuleContext(self, UnlexerRule(name='ESCAPED_STRING', parent=parent)) as current:
            with AlternationContext(self, [0, 0], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                if choice0 == 0:
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 0, min=0, max=1):
                            UnlexerRule(src=self._model.charset(current, 0, self._charsets[2]), parent=current)
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 1, min=0, max=1):
                            UnlexerRule(src=self._model.charset(current, 1, self._charsets[3]), parent=current)
                elif choice0 == 1:
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 2, min=0, max=1):
                            UnlexerRule(src=self._model.charset(current, 2, self._charsets[4]), parent=current)
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 3, min=0, max=1):
                            UnlexerRule(src=self._model.charset(current, 3, self._charsets[5]), parent=current)
            with AlternationContext(self, [0, 0, 0, 0], [1, 1, 1, 1]) as weights1:
                choice1 = self._model.choice(current, 1, weights1)
                if choice1 == 0:
                    UnlexerRule(src='\'', parent=current)
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 4, min=0, max=inf):
                            with AlternationContext(self, [0, 0], [1, 1]) as weights2:
                                choice2 = self._model.choice(current, 2, weights2)
                                if choice2 == 0:
                                    UnlexerRule(src='\\', parent=current)
                                    with AlternationContext(self, [0, 0], [1, 1]) as weights3:
                                        choice3 = self._model.choice(current, 3, weights3)
                                        if choice3 == 0:
                                            if self._max_depth >= 0:
                                                for _ in self._model.quantify(current, 5, min=1, max=inf):
                                                    UnlexerRule(src=self._model.charset(current, 4, self._charsets[6]), parent=current)
                                            if self._max_depth >= 0:
                                                for _ in self._model.quantify(current, 6, min=0, max=1):
                                                    if self._max_depth >= 0:
                                                        for _ in self._model.quantify(current, 7, min=0, max=1):
                                                            UnlexerRule(src='\r', parent=current)
                                                    UnlexerRule(src='\n', parent=current)
                                        elif choice3 == 1:
                                            UnlexerRule(src=self._model.charset(current, 5, self._charsets[0]), parent=current)
                                elif choice2 == 1:
                                    UnlexerRule(src=self._model.charset(current, 6, self._charsets[7]), parent=current)
                    UnlexerRule(src='\'', parent=current)
                elif choice1 == 1:
                    UnlexerRule(src='"', parent=current)
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 8, min=0, max=inf):
                            with AlternationContext(self, [0, 0], [1, 1]) as weights4:
                                choice4 = self._model.choice(current, 4, weights4)
                                if choice4 == 0:
                                    UnlexerRule(src='\\', parent=current)
                                    with AlternationContext(self, [0, 0], [1, 1]) as weights5:
                                        choice5 = self._model.choice(current, 5, weights5)
                                        if choice5 == 0:
                                            if self._max_depth >= 0:
                                                for _ in self._model.quantify(current, 9, min=1, max=inf):
                                                    UnlexerRule(src=self._model.charset(current, 7, self._charsets[8]), parent=current)
                                            if self._max_depth >= 0:
                                                for _ in self._model.quantify(current, 10, min=0, max=1):
                                                    if self._max_depth >= 0:
                                                        for _ in self._model.quantify(current, 11, min=0, max=1):
                                                            UnlexerRule(src='\r', parent=current)
                                                    UnlexerRule(src='\n', parent=current)
                                        elif choice5 == 1:
                                            UnlexerRule(src=self._model.charset(current, 8, self._charsets[0]), parent=current)
                                elif choice4 == 1:
                                    UnlexerRule(src=self._model.charset(current, 9, self._charsets[9]), parent=current)
                    UnlexerRule(src='"', parent=current)
                elif choice1 == 2:
                    UnlexerRule(src='"""', parent=current)
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 12, min=0, max=inf):
                            with AlternationContext(self, [0, 0], [1, 1]) as weights6:
                                choice6 = self._model.choice(current, 6, weights6)
                                if choice6 == 0:
                                    UnlexerRule(src='\\', parent=current)
                                    UnlexerRule(src=self._model.charset(current, 10, self._charsets[0]), parent=current)
                                elif choice6 == 1:
                                    UnlexerRule(src=self._model.charset(current, 11, self._charsets[10]), parent=current)
                    UnlexerRule(src='"""', parent=current)
                elif choice1 == 3:
                    UnlexerRule(src='\'\'\'', parent=current)
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 13, min=0, max=inf):
                            with AlternationContext(self, [0, 0], [1, 1]) as weights7:
                                choice7 = self._model.choice(current, 7, weights7)
                                if choice7 == 0:
                                    UnlexerRule(src='\\', parent=current)
                                    UnlexerRule(src=self._model.charset(current, 12, self._charsets[0]), parent=current)
                                elif choice7 == 1:
                                    UnlexerRule(src=self._model.charset(current, 13, self._charsets[11]), parent=current)
                    UnlexerRule(src='\'\'\'', parent=current)
            return current
    ESCAPED_STRING.min_depth = 0

    def NONE_TYPE_LITERAL(self, parent=None):
        with RuleContext(self, UnlexerRule(name='NONE_TYPE_LITERAL', parent=parent)) as current:
            UnlexerRule(src='none', parent=current)
            return current
    NONE_TYPE_LITERAL.min_depth = 0

    def INDEX_TYPE_LITERAL(self, parent=None):
        with RuleContext(self, UnlexerRule(name='INDEX_TYPE_LITERAL', parent=parent)) as current:
            UnlexerRule(src='index', parent=current)
            return current
    INDEX_TYPE_LITERAL.min_depth = 0

    def FLOAT_TYPE_LITERAL(self, parent=None):
        with RuleContext(self, UnlexerRule(name='FLOAT_TYPE_LITERAL', parent=parent)) as current:
            with AlternationContext(self, [0, 0, 0, 0], [1, 1, 1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                UnlexerRule(src=['f16', 'bf16', 'f32', 'f64'][choice0], parent=current)
            return current
    FLOAT_TYPE_LITERAL.min_depth = 0

    def FLOAT_LITERAL(self, parent=None):
        with RuleContext(self, UnlexerRule(name='FLOAT_LITERAL', parent=parent)) as current:
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=0, max=1):
                    UnlexerRule(src=self._model.charset(current, 0, self._charsets[12]), parent=current)
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 1, min=1, max=inf):
                    UnlexerRule(src=self._model.charset(current, 1, self._charsets[13]), parent=current)
            UnlexerRule(src=self._model.charset(current, 2, self._charsets[14]), parent=current)
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 2, min=0, max=inf):
                    UnlexerRule(src=self._model.charset(current, 3, self._charsets[15]), parent=current)
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 3, min=0, max=1):
                    UnlexerRule(src=self._model.charset(current, 4, self._charsets[16]), parent=current)
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 4, min=0, max=1):
                            UnlexerRule(src=self._model.charset(current, 5, self._charsets[17]), parent=current)
                    if self._max_depth >= 0:
                        for _ in self._model.quantify(current, 5, min=1, max=inf):
                            UnlexerRule(src=self._model.charset(current, 6, self._charsets[18]), parent=current)
            return current
    FLOAT_LITERAL.min_depth = 0

    def DIGITS(self, parent=None):
        with RuleContext(self, UnlexerRule(name='DIGITS', parent=parent)) as current:
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=1, max=inf):
                    self.DIGIT(parent=current)
            return current
    DIGITS.min_depth = 1

    def NONZERO_DIGIT(self, parent=None):
        with RuleContext(self, UnlexerRule(name='NONZERO_DIGIT', parent=parent)) as current:
            UnlexerRule(src=self._model.charset(current, 0, self._charsets[19]), parent=current)
            return current
    NONZERO_DIGIT.min_depth = 0

    def DIGIT(self, parent=None):
        with RuleContext(self, UnlexerRule(name='DIGIT', parent=parent)) as current:
            UnlexerRule(src=self._model.charset(current, 0, self._charsets[20]), parent=current)
            return current
    DIGIT.min_depth = 0

    def LETTER(self, parent=None):
        with RuleContext(self, UnlexerRule(name='LETTER', parent=parent)) as current:
            UnlexerRule(src=self._model.charset(current, 0, self._charsets[21]), parent=current)
            return current
    LETTER.min_depth = 0

    def TRUE(self, parent=None):
        with RuleContext(self, UnlexerRule(name='TRUE', parent=parent)) as current:
            UnlexerRule(src='true', parent=current)
            return current
    TRUE.min_depth = 0

    def FALSE(self, parent=None):
        with RuleContext(self, UnlexerRule(name='FALSE', parent=parent)) as current:
            UnlexerRule(src='false', parent=current)
            return current
    FALSE.min_depth = 0

    def ID_CHARS(self, parent=None):
        with RuleContext(self, UnlexerRule(name='ID_CHARS', parent=parent)) as current:
            UnlexerRule(src=self._model.charset(current, 0, self._charsets[22]), parent=current)
            return current
    ID_CHARS.min_depth = 0

    def BARE_ID(self, parent=None):
        with RuleContext(self, UnlexerRule(name='BARE_ID', parent=parent)) as current:
            with AlternationContext(self, [1, 0], [1, 1]) as weights0:
                choice0 = self._model.choice(current, 0, weights0)
                src = [None, '_'][choice0]
                rule = [self.LETTER, None][choice0]
                if src is not None:
                    UnlexerRule(src=src, parent=current)
                else:
                    rule(parent=current)
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=0, max=inf):
                    with AlternationContext(self, [1, 1, 0, 1], [1, 1, 1, 1]) as weights1:
                        choice1 = self._model.choice(current, 1, weights1)
                        src = [None, None, '_', None][choice1]
                        rule = [self.LETTER, self.DIGIT, None, self.ID_CHARS][choice1]
                        if src is not None:
                            UnlexerRule(src=src, parent=current)
                        else:
                            rule(parent=current)
            return current
    BARE_ID.min_depth = 0

    def WS(self, parent=None):
        with RuleContext(self, UnlexerRule(name='WS', parent=parent)) as current:
            if self._max_depth >= 0:
                for _ in self._model.quantify(current, 0, min=1, max=inf):
                    UnlexerRule(src=self._model.charset(current, 0, self._charsets[23]), parent=current)
            return current
    WS.min_depth = 0

    _default_rule = bool_literal

    _charsets = {
        0: list(itertools.chain.from_iterable([range(32, 127)])),
        1: list(itertools.chain.from_iterable([range(48, 58), range(65, 71), range(97, 103)])),
        2: list(itertools.chain.from_iterable([range(66, 67), range(85, 86), range(98, 99), range(117, 118)])),
        3: list(itertools.chain.from_iterable([range(82, 83), range(114, 115)])),
        4: list(itertools.chain.from_iterable([range(82, 83), range(114, 115)])),
        5: list(itertools.chain.from_iterable([range(66, 67), range(85, 86), range(98, 99), range(117, 118)])),
        6: list(itertools.chain.from_iterable([range(9, 10), range(32, 33)])),
        7: list(itertools.chain.from_iterable([range(32, 39), range(40, 92), range(93, 127)])),
        8: list(itertools.chain.from_iterable([range(9, 10), range(32, 33)])),
        9: list(itertools.chain.from_iterable([range(32, 34), range(35, 92), range(93, 127)])),
        10: list(itertools.chain.from_iterable([range(32, 92), range(93, 127)])),
        11: list(itertools.chain.from_iterable([range(32, 92), range(93, 127)])),
        12: list(itertools.chain.from_iterable([range(43, 44), range(45, 46)])),
        13: list(itertools.chain.from_iterable([range(48, 58)])),
        14: list(itertools.chain.from_iterable([range(46, 47)])),
        15: list(itertools.chain.from_iterable([range(48, 58)])),
        16: list(itertools.chain.from_iterable([range(69, 70), range(101, 102)])),
        17: list(itertools.chain.from_iterable([range(43, 44), range(45, 46)])),
        18: list(itertools.chain.from_iterable([range(48, 58)])),
        19: list(itertools.chain.from_iterable([range(49, 58)])),
        20: list(itertools.chain.from_iterable([range(48, 58)])),
        21: list(itertools.chain.from_iterable([range(65, 91), range(97, 123)])),
        22: list(itertools.chain.from_iterable([range(36, 37)])),
        23: list(itertools.chain.from_iterable([range(9, 10), range(10, 11), range(13, 14), range(32, 33)])),
    }
