#!/usr/bin/env bash

set -e

# Get the absolute path of the current script
script_path="$(readlink -f "${BASH_SOURCE[0]}")"

# Get the directory of the current script
script_dir="$(dirname "$script_path")"

# Get common variables
. "$script_dir/common.sh"

# Check if the correct number of arguments is provided
if [ "$#" -ne 4 ]; then
  echo "Usage: $0 PARENT_PATH MODE SEED COUNT"
  exit 1
fi

MODE="$2"
SEED="$3"
COUNT="$4"
DEPTH=50

case "$MODE" in
  synthfuzz)
    DISABLED_STRATEGIES="--no-generate --no-recombine"
    ;;
  gramdefault)
    DISABLED_STRATEGIES="--no-edit"
    ;;
  gramoptimal)
    DISABLED_STRATEGIES="--no-generate --no-edit"
    ;;
  *)
    echo "Invalid MODE. Allowed options: synthfuzz, gramdefault, gramoptimal"
    exit 1
    ;;
esac


mkdir -p $parent_path/edit-log
mkdir -p $parent_path/generate

time python -m mlirmut.synthfuzz.generate \
    mlir_2023Generator.mlir_2023Generator \
    -s mlir_2023Generator.mlir_serializer \
    -r start_rule \
    -d $DEPTH \
    --random-seed $SEED \
    --edit-seed $SEED \
    -o $parent_path/generate/%d.mlir \
    -n $COUNT \
    --sys-path $MLIR_GEN_DIR \
    --population $POP_DIR \
    $DISABLED_STRATEGIES \
    --edit-log $parent_path/edit-log

python -m mlirmut.scripts.pad_numbers $parent_path/generate