#!/bin/bash

# Get the absolute path of the current script
script_path="$(readlink -f "${BASH_SOURCE[0]}")"

# Get the directory of the current script
script_dir="$(dirname "$script_path")"

# Get common variables
. "$script_dir/common.sh"

PROFDATA_DIR="$parent_path/profdata"
EXPORT_DIR="$parent_path/export-profdata"

mkdir -p "$EXPORT_DIR"

python -m mlirmut.scripts.export_cov_summary \
    "$PROFDATA_DIR" \
    "$EXPORT_DIR"
