#!/bin/bash

if [ "$#" -lt 1 ]; then
   echo "Usage: \$0 <dirpath>..."
   exit 1
fi

. .env

VOLUMES=""
for arg in "$@"
do
    DIRPATH=$(realpath "$arg")
    VOLUMES="$VOLUMES -v $DIRPATH:$DIRPATH"
done

USERNAME=$(whoami)
USER_ID=$(id -u)
GROUP_ID=$(id -g)

NEXT_CMD="docker run \
    --name $ENV_IMG_NAME \
    $VOLUMES \
    -v /etc/passwd:/etc/passwd:ro \
    -v /etc/group:/etc/group:ro \
    --device=/dev/fuse \
    --security-opt apparmor:unconfined \
    --cap-add SYS_ADMIN \
    --workdir $DIRPATH \
    --user $USER_ID:$GROUP_ID \
    -it \
    -d \
    $ENV_IMG_NAME:$ENV_IMG_TAG"
echo "$NEXT_CMD"
$NEXT_CMD
