#!/bin/bash

. .env

script_dir=$(dirname $(realpath "${BASH_SOURCE}"))
dockerfile_path="$script_dir/Dockerfile"

username=$(whoami)
groupname=$username
userid=$(id -u)
groupid=$(id -g)

docker build "$script_dir" \
	-f "$dockerfile_path" \
	-t $ENV_IMG_NAME:$ENV_IMG_TAG\
	--build-arg USER="$username" \
	--build-arg GROUP="$groupname" \
	--build-arg USER_ID="$userid" \
	--build-arg GROUP_ID="$groupid"
