#!/bin/bash

set -e

# Get the absolute path of the current script
script_path="$(readlink -f "${BASH_SOURCE[0]}")"

# Get the directory of the current script
script_dir="$(dirname "$script_path")"

# Get common variables
. "$script_dir/common.sh"

cd "$script_dir"

fuzzer_config="$2"
SEED="$3"

# Create mull directories
DATA_DIR=$parent_path

echo Generating test cases...
mkdir -p "$DATA_DIR/edit-log"
NEXT_CMD="./generate.sh $1 $fuzzer_config $SEED 5"
echo "$NEXT_CMD"
eval "$NEXT_CMD"

echo Generating reference outputs...
REF_DIR="$DATA_DIR/reference-output"
mkdir -p "$REF_DIR"
INPUT_DIR="$parent_path/generate"
python ./generate-reference-outputs.py "$INPUT_DIR"

REPORT_PREFIX="mull"

TEMP_DIR="/tmp/${fuzzer_config}${SEED}"
mkdir -p "$TEMP_DIR"
LOG_PATH="$DATA_DIR/failure-log"
mkdir -p "$LOG_PATH"

mull-runner-14 \
    $mull_binary_path \
    --reporters Patches \
    --reporters SQLite \
    --report-dir "$DATA_DIR" \
    --report-name "$REPORT_PREFIX" \
    --coverage-info "$COV_PATH" \
    --test-program=python -- test-runner.py "$INPUT_DIR" "$REF_DIR" --temp-dir "$TEMP_DIR" --log-path "$LOG_PATH"

rm -rf "$TEMP_DIR"
