#!/bin/bash

set -e

# Get the absolute path of the current script
script_path="$(readlink -f "${BASH_SOURCE[0]}")"

# Get the directory of the current script
script_dir="$(dirname "$script_path")"

# Get common variables
. "$script_dir/common.sh"

echo Generating reference outputs...
DATA_DIR="/path/to/synthfuzz-data/circt"
INPUT_DIR="/path/to/synthfuzz-data/circt/filter-cases"
REF_DIR="/path/to/synthfuzz-data/circt/filter-cases-ref-output"
python ./generate-reference-outputs.py "$INPUT_DIR" --output-dir  "$REF_DIR"

REPORT_PREFIX="mull"

TEMP_DIR="/tmp/circtbaseline"
mkdir -p "$TEMP_DIR"
LOG_PATH="/path/to/synthfuzz-data/circt/filter-cases-failure-log"
mkdir -p "$LOG_PATH"

mull-runner-14 \
    $mull_binary_path \
    --reporters Patches \
    --reporters SQLite \
    --report-dir "$DATA_DIR" \
    --report-name "$REPORT_PREFIX" \
    --coverage-info "$COV_PATH" \
    --test-program=python -- test-runner.py "$INPUT_DIR" "$REF_DIR" --temp-dir "$TEMP_DIR" --log-path "$LOG_PATH"

rm -rf "$TEMP_DIR"
