#!/bin/bash

set -e

# Get the absolute path of the current script
script_path="$(readlink -f "${BASH_SOURCE[0]}")"

# Get the directory of the current script
script_dir="$(dirname "$script_path")"

# Get common variables
. "$script_dir/common.sh"

MUTANT_DIR="$parent_path/generate"
PROFDATA_DIR="$parent_path/profdata"
CUMULATIVE_DIR="$parent_path/cumulative"
EXPORT_DIR="$parent_path/export"
TEMP_DIR="/tmp/$dir_name"

mkdir -p "$TEMP_DIR"

echo Measuring coverage...
python -m mlirmut.scripts.measure_cov \
    --max-threads "$max_threads" \
    --command-prefix "$binary_path $command_args" \
    "$MUTANT_DIR" \
    "$PROFDATA_DIR"

echo Accumulating coverage...
python -m mlirmut.scripts.accumulate_cov \
    --interval 100 \
    "$PROFDATA_DIR" \
    "$CUMULATIVE_DIR"

echo Exporting coverage summaries...
python -m mlirmut.scripts.export_cov_summary \
    --max-threads "$max_threads" \
    --target-binary "$binary_path" \
    "$CUMULATIVE_DIR" \
    "$EXPORT_DIR"
