% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mtcdForEntireDataFrame.R
\name{mtcdForEntireDataFrame}
\alias{mtcdForEntireDataFrame}
\title{Create Synthetic Dataset}
\usage{
mtcdForEntireDataFrame(df, seed = 0, niters = 1e+05, burnin = 30000,
  stride = 500, numModel = 10)
}
\arguments{
\item{df}{A dataframe with three columns, the last column containing count to be synthesized, the first two must be numeric, numbers that uniquely identify counties}

\item{seed}{positive integer for random number generation}

\item{niters}{positive integer, number of iterations for parameter generation}

\item{burnin}{a positive integer specifying the number of burnins(iterations of parameters will not be saved)}

\item{stride}{the model will save a model(set of parameters) for every stride number of models}

\item{numModel}{a positive integer specifying the number of synthetic datasets to be generated}
}
\value{
A dataframe containing the synthetic datasets and disclosure risk measures
}
\description{
Returns synthetic datasets from a Bayesian hierarchical model. This function wraps C++
code proposed in "Synthesizing Truncated Count Data for Confidentiality," and developed
by Sam Hawala, Jerry Reiter and Quanli Wang. References can be found in the package
description.
}
\section{Details}{
 The first three columns of output are the original dataset. The next numModel columns are the synthetic datasets. The next two colunms give the 95 percent confidence intevals estimated using all saved models. The following columns give the dt, Rall and Runq risk measurements.
}
\examples{
setwd("00_pkg_src/Rmtcd/test")
read.table("data.txt") -> dataFrame
mtcdForEntireDataFrame(dataFrame, numModel = 5)
}
\seealso{
\code{\link{Rmtcd}}
}

