(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[     54713,       1262]
NotebookOptionsPosition[     50467,       1182]
NotebookOutlinePosition[     50805,       1197]
CellTagsIndexPosition[     50762,       1194]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"$HistoryLength", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"LaunchKernels", "[", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"StartTime", "=", 
   RowBox[{"SessionTime", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.87862190996004*^9, 3.878621913273439*^9}, 
   3.878631818699809*^9, {3.878715979600503*^9, 3.8787159802025013`*^9}, {
   3.878716067380403*^9, 3.878716069493479*^9}, 3.878716473106461*^9, {
   3.878716509738706*^9, 3.8787165103086767`*^9}, {3.87983765884753*^9, 
   3.8798376593908253`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"f720684b-decf-4c50-9eeb-2e7a58180af0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ssize", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "100.0"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.880690281153887*^9, 3.880690286134734*^9}, {
  3.880690823898144*^9, 3.880690824336405*^9}, {3.8806922299267178`*^9, 
  3.880692230585281*^9}, {3.880692857813313*^9, 3.880692888648274*^9}, {
  3.880695249320966*^9, 3.8806952511605043`*^9}, {3.883561407880321*^9, 
  3.883561408989973*^9}, {3.884264123791666*^9, 3.884264123876171*^9}, {
  3.8853006614656267`*^9, 3.885300661565428*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"1ed4b6d2-06ac-418d-9f75-fb179df5d77b"],

Cell[BoxData["$ConfiguredKernels"], "Input",
 CellChangeTimes->{{3.878716454660874*^9, 3.8787164584262247`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"f02de342-b4be-4d08-93a4-8dc1afc60909"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LRT", "[", "site_", "]"}], ":=", 
   RowBox[{
    RowBox[{"LRT", "[", "site", "]"}], "=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"source", ",", "data", ",", "tmp", ",", "i"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
       "source", "=", "\"\<OBC_reference_Delta1.0_g0.0000_m0.0000.dat\>\""}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{"Import", "[", "source", "]"}]}], ";", "\[IndentingNewLine]", 
       
       RowBox[{"tmp", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", 
             RowBox[{"data", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[Equal]", "3"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "2"}], "]"}], "]"}], " ", "\[Equal]", 
               "site"}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"tmp", "=", 
                RowBox[{"Append", "[", 
                 RowBox[{"tmp", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"data", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"data", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}], "-", "0.5"}], 
                    ")"}]}]}], "}"}]}], "]"}]}], ";"}]}], 
             "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "data", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"data", "=", "tmp"}], ";", "\[IndentingNewLine]", 
       RowBox[{"tmp", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"tmp", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ",", 
              RowBox[{"data", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "data", "]"}], ",", "2", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{"Join", "[", 
         RowBox[{"tmp", ",", "data"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "data"}]}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.86938232453403*^9, 3.869382390054947*^9}, {
   3.869382480555532*^9, 3.869382806328741*^9}, {3.869383266669777*^9, 
   3.8693832698816833`*^9}, {3.8693833245735273`*^9, 3.86938336289152*^9}, {
   3.86938407062304*^9, 3.8693843244130993`*^9}, 3.869385233053306*^9, 
   3.869387360862966*^9, {3.869550551862997*^9, 3.8695505631621103`*^9}, {
   3.869550594844036*^9, 3.8695507092596283`*^9}, {3.87862108019499*^9, 
   3.878621134149129*^9}, {3.878622039880024*^9, 3.8786220403191977`*^9}, {
   3.878623436534862*^9, 3.8786234839019003`*^9}, {3.878623642150826*^9, 
   3.87862366944724*^9}, {3.878628653472477*^9, 3.878628656399817*^9}, 
   3.878628694654271*^9, {3.878628864713423*^9, 3.878628864759923*^9}, 
   3.878631895660853*^9, 3.87863199449597*^9, {3.879322145379734*^9, 
   3.8793221494704247`*^9}, {3.879323005295598*^9, 3.879323012310411*^9}, {
   3.879326225543124*^9, 3.879326232835258*^9}, {3.8794983409243*^9, 
   3.879498341026854*^9}, {3.879498871114716*^9, 3.879498871739771*^9}, 
   3.8794990408259706`*^9, {3.879500610537146*^9, 3.879500614660357*^9}, {
   3.879837452727262*^9, 3.8798374547720003`*^9}, {3.879837643083179*^9, 
   3.8798376463785067`*^9}, {3.880523502513221*^9, 3.880523507511919*^9}, {
   3.8808049511008673`*^9, 3.880804963668461*^9}, {3.8808087354934053`*^9, 
   3.88080874200185*^9}, {3.88191151604784*^9, 3.8819115161490993`*^9}, {
   3.883481568652905*^9, 3.88348156999417*^9}, {3.883548670498103*^9, 
   3.883548670754163*^9}, 3.8840996005266123`*^9, {3.884264126907106*^9, 
   3.88426412825779*^9}, {3.8853006563176727`*^9, 3.8853006563573093`*^9}, 
   3.885300687563881*^9},ExpressionUUID->"d3dd7bdc-5c3b-4985-be56-\
e2f3b074a335"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"LRT", "[", "0", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f2", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"LRT", "[", "19", "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8834815822370043`*^9, 3.8834815838709497`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"cf630415-fbee-4002-8706-af39824482b9"],

Cell[BoxData[{
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "tmax"}], ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", ".1"}], ",", "1.2"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f2", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "tmax"}], ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", ".1"}], ",", "1.2"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.878628712484227*^9, {3.8793230475910807`*^9, 3.879323047707341*^9}, {
   3.879326238301387*^9, 3.879326238656664*^9}, {3.879498318632358*^9, 
   3.879498318703185*^9}, {3.879498538029934*^9, 3.879498551770474*^9}, {
   3.879498658821518*^9, 3.879498664627058*^9}, 3.8794989532082977`*^9, {
   3.879500572363254*^9, 3.8795006383295927`*^9}, {3.879853513131242*^9, 
   3.8798535168237953`*^9}, {3.879858037350301*^9, 3.879858044162497*^9}, {
   3.8798590284379663`*^9, 3.879859028781304*^9}, 3.880805000178343*^9, {
   3.883483895081314*^9, 3.883483896048892*^9}, {3.884097199828116*^9, 
   3.884097215000478*^9}, {3.884099667364749*^9, 3.884099667961549*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"e40be50e-9763-458f-8c75-a7d76f7e8acb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"JumpTimes", "[", 
    RowBox[{"tmax_", ",", "gamma_"}], "]"}], " ", ":=", " ", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", ",", "l", ",", "r", ",", "t", ",", "tau"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"s", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"l", "=", 
       RowBox[{"{", "0.", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"s", "\[LessEqual]", "tmax"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"r", "=", 
          RowBox[{"RandomReal", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"tau", "=", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Log", "[", "r", "]"}]}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "*", "gamma"}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"s", "+=", "tau"}], ";", "\[IndentingNewLine]", 
         RowBox[{"t", "=", 
          RowBox[{"tau", "+", 
           RowBox[{"l", "[", 
            RowBox[{"[", 
             RowBox[{"Length", "[", "l", "]"}], "]"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"t", "\[LessEqual]", "tmax"}], ",", "\[IndentingNewLine]", 
           
           RowBox[{
            RowBox[{"l", "=", 
             RowBox[{"Append", "[", 
              RowBox[{"l", ",", "t"}], "]"}]}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}],
       ";", "\[IndentingNewLine]", "l"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.869381442681048*^9, 3.869381876596469*^9}, {
   3.869381963255755*^9, 3.869381965028845*^9}, {3.869381996638918*^9, 
   3.8693820280036097`*^9}, {3.869382071111865*^9, 3.869382218790571*^9}, {
   3.869384997373003*^9, 3.869384997721064*^9}, {3.8693852679972277`*^9, 
   3.869385268122386*^9}, {3.869385732061214*^9, 3.869385743081196*^9}, 
   3.873184487669973*^9, {3.8786220431781683`*^9, 3.878622043577327*^9}, {
   3.878622111477063*^9, 3.878622130943589*^9}, 3.8792419644066687`*^9, {
   3.879324533927239*^9, 3.87932453401538*^9}, {3.879860261033998*^9, 
   3.8798602657222424`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"2c60896b-6ac5-4f51-b54c-40dfa7c069f3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fsiteInterpolation", "[", "site_", "]"}], ":=", 
   RowBox[{
    RowBox[{"fsiteInterpolation", "[", "site", "]"}], "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"LRT", "[", "site", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"fsiteInterpolation", "[", "site", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"site", ",", "0", ",", 
     RowBox[{"ssize", "-", "1"}]}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.878623403533752*^9, 3.878623406157297*^9}, 
   3.878623611693903*^9, {3.878623765161303*^9, 3.878623781549549*^9}, {
   3.879498680738378*^9, 3.879498707570743*^9}, {3.880696884876103*^9, 
   3.8806968850188627`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"1bede55f-a1a8-4db2-91f1-4f3d61dcc307"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "site"}], "-", "1"}], ",", "20"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"site", ",", "0", ",", 
     RowBox[{"ssize", "-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.883483478388578*^9, 3.883483511849395*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"708fdf6b-8dfa-496d-b521-f894580be0be"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Dynamics", "[", 
    RowBox[{"l_", ",", "tmax_", ",", "site_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "mu", ",", "x", ",", "i", ",", "t", ",", "a", ",", "n", ",", "data"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"mu", "=", "0.1"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"g", "[", "x_", "]"}], "=", "0."}], ";", "\[IndentingNewLine]", 
      RowBox[{"fsite", "=", 
       RowBox[{"fsiteInterpolation", "[", "site", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"f2site", "=", 
         RowBox[{"fsiteInterpolation", "[", 
          RowBox[{"Mod", "[", 
           RowBox[{
            RowBox[{"site", "+", "10"}], ",", "20"}], "]"}], "]"}]}], ";"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"f2site", "=", 
       RowBox[{"fsiteInterpolation", "[", 
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "site"}], "-", "1"}], ",", "20"}], "]"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"gsite", "[", "x_", "]"}], "=", "0."}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"t", "=", 
          RowBox[{"l", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"a", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"mu", "-", 
             RowBox[{"2.", "*", 
              RowBox[{"g", "[", "t", "]"}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"2.", "-", 
             RowBox[{"4.", "*", "mu", "*", 
              RowBox[{"g", "[", "t", "]"}]}]}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"h", "[", "x_", "]"}], "=", 
          RowBox[{
           RowBox[{"g", "[", "x", "]"}], "+", 
           RowBox[{".5", "*", 
            RowBox[{"(", 
             RowBox[{"a", "-", 
              RowBox[{"g", "[", "t", "]"}]}], ")"}], "*", 
            RowBox[{"UnitStep", "[", 
             RowBox[{"x", "-", "t"}], "]"}], "*", 
            RowBox[{"f", "[", 
             RowBox[{"x", "-", "t"}], "]"}]}], "\[IndentingNewLine]", "-", 
           RowBox[{".5", "*", 
            RowBox[{"(", 
             RowBox[{"a", "-", 
              RowBox[{"g", "[", "t", "]"}]}], ")"}], "*", 
            RowBox[{"UnitStep", "[", 
             RowBox[{"x", "-", "t"}], "]"}], "*", 
            RowBox[{"f2", "[", 
             RowBox[{"x", "-", "t"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"hsite", "[", "x_", "]"}], "=", 
          RowBox[{
           RowBox[{"gsite", "[", "x", "]"}], "+", 
           RowBox[{".5", "*", 
            RowBox[{"(", 
             RowBox[{"a", "-", 
              RowBox[{"g", "[", "t", "]"}]}], ")"}], "*", 
            RowBox[{"UnitStep", "[", 
             RowBox[{"x", "-", "t"}], "]"}], "*", 
            RowBox[{"fsite", "[", 
             RowBox[{"x", "-", "t"}], "]"}]}], "\[IndentingNewLine]", "-", 
           RowBox[{".5", "*", 
            RowBox[{"(", 
             RowBox[{"a", "-", 
              RowBox[{"g", "[", "t", "]"}]}], ")"}], "*", 
            RowBox[{"UnitStep", "[", 
             RowBox[{"x", "-", "t"}], "]"}], "*", 
            RowBox[{"f2site", "[", 
             RowBox[{"x", "-", "t"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
            RowBox[{"h", "[", "x_", "]"}], "=", 
            RowBox[{
             RowBox[{"g", "[", "x", "]"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a", "-", 
                RowBox[{"g", "[", "t", "]"}]}], ")"}], "*", 
              RowBox[{"f", "[", 
               RowBox[{"x", "-", "t"}], "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"hsite", "[", "x_", "]"}], "=", 
            RowBox[{
             RowBox[{"gsite", "[", "x", "]"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a", "-", 
                RowBox[{"g", "[", "t", "]"}]}], ")"}], "*", 
              RowBox[{"fsite", "[", 
               RowBox[{"x", "-", "t"}], "]"}]}]}]}], ";"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"g", "[", "x_", "]"}], "=", 
          RowBox[{"h", "[", "x", "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"gsite", "[", "x_", "]"}], "=", 
          RowBox[{"hsite", "[", "x", "]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", 
          RowBox[{"Length", "[", "l", "]"}]}], "}"}]}], "\[IndentingNewLine]",
        "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"n", "=", "1000."}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "*", 
            RowBox[{"tmax", "/", "n"}]}], ",", 
           RowBox[{"gsite", "[", 
            RowBox[{"i", "*", 
             RowBox[{"tmax", "/", "n"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "data"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8693830808262787`*^9, 3.869383184983239*^9}, {
   3.869383228748538*^9, 3.869383230425487*^9}, 3.869383289261693*^9, {
   3.8693834027638607`*^9, 3.869384021291087*^9}, {3.8693850023964157`*^9, 
   3.869385002713499*^9}, 3.869385654141893*^9, {3.8693858797877197`*^9, 
   3.869385906121483*^9}, {3.869385974766115*^9, 3.869385975098041*^9}, {
   3.869386283054698*^9, 3.8693862933246593`*^9}, {3.869386402334516*^9, 
   3.869386447468981*^9}, {3.869387251887371*^9, 3.869387286699239*^9}, {
   3.8695507745343246`*^9, 3.869550777637645*^9}, {3.869550820743869*^9, 
   3.869550826846632*^9}, {3.869550867407881*^9, 3.8695508800299797`*^9}, {
   3.869550930312374*^9, 3.869551116555766*^9}, {3.8695511615084133`*^9, 
   3.8695511905007563`*^9}, {3.869551224076708*^9, 3.869551225261381*^9}, {
   3.8695512811386433`*^9, 3.869551330556384*^9}, {3.869555380465838*^9, 
   3.869555382717444*^9}, {3.8698031163110867`*^9, 3.869803277575761*^9}, {
   3.87318599495006*^9, 3.873185999246708*^9}, {3.8731877849509706`*^9, 
   3.873187787893962*^9}, {3.878622046817849*^9, 3.878622047264484*^9}, {
   3.8786230405169992`*^9, 3.8786230556909924`*^9}, {3.878623088480624*^9, 
   3.878623091041287*^9}, {3.878623167428047*^9, 3.8786231685650663`*^9}, {
   3.878623705992147*^9, 3.878623726591269*^9}, {3.878623790813677*^9, 
   3.878623795110188*^9}, 3.878624341445177*^9, {3.878624410806047*^9, 
   3.878624486491743*^9}, {3.8793221285818253`*^9, 3.879322140201092*^9}, {
   3.8793226159503717`*^9, 3.8793226304415693`*^9}, 3.879322693019587*^9, {
   3.8793227774697437`*^9, 3.879322781082735*^9}, {3.8793263092150393`*^9, 
   3.879326326241804*^9}, {3.8794981922787323`*^9, 3.879498227450729*^9}, {
   3.879498300741219*^9, 3.879498311910934*^9}, 3.8794989007132463`*^9, {
   3.879837737111154*^9, 3.8798377466755857`*^9}, {3.879846863022538*^9, 
   3.879846865165667*^9}, {3.879857300561398*^9, 3.879857303373698*^9}, 
   3.879857415649126*^9, {3.8798575872751627`*^9, 3.879857595658342*^9}, {
   3.8798576816321917`*^9, 3.879857690522479*^9}, 3.879857751310966*^9, {
   3.879857785019517*^9, 3.87985778542181*^9}, {3.8798578481033773`*^9, 
   3.879857859573897*^9}, 3.879858391878751*^9, {3.879858555093133*^9, 
   3.879858562014072*^9}, {3.879858603441703*^9, 3.879858606893949*^9}, {
   3.879859003544952*^9, 3.879859006276474*^9}, {3.879859043482511*^9, 
   3.879859059681177*^9}, {3.879859512809423*^9, 3.879859517216873*^9}, {
   3.8798596818736353`*^9, 3.87985968570912*^9}, {3.879862635509601*^9, 
   3.879862658402247*^9}, {3.8798626963691187`*^9, 3.879862696391151*^9}, {
   3.879862883059697*^9, 3.879862890444539*^9}, {3.879924076308045*^9, 
   3.879924103842437*^9}, {3.879924200506981*^9, 3.879924233014306*^9}, {
   3.8802095987103577`*^9, 3.880209599008768*^9}, {3.880209673577054*^9, 
   3.880209676481607*^9}, {3.883481629737255*^9, 3.8834816392826138`*^9}, {
   3.883482151444592*^9, 3.883482151917048*^9}, {3.883482933682118*^9, 
   3.883482937336932*^9}, {3.883483522100226*^9, 3.8834835227423964`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"ae8be8f4-e682-4437-ade4-f7603461378f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ltest", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0.", ",", "10.", ",", "20.", ",", "30.", ",", "40."}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"seqdata", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Dynamics", "[", 
      RowBox[{"ltest", ",", "50.0", ",", 
       RowBox[{"site", "-", "1"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"site", ",", "1", ",", "20"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Dynamics", "[", 
      RowBox[{"ltest", ",", "50.0", ",", "0"}], "]"}], ",", 
     RowBox[{"Dynamics", "[", 
      RowBox[{"ltest", ",", "50.0", ",", "19"}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", ".05"}], ",", "0.05"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8794989083533783`*^9, 3.879498930883933*^9}, 
   3.8798585274996853`*^9, {3.8798585646203213`*^9, 3.8798585661358624`*^9}, {
   3.879858785781289*^9, 3.8798588125711403`*^9}, {3.87985952514229*^9, 
   3.879859529452922*^9}, {3.879859726692842*^9, 3.879859741753902*^9}, {
   3.879862238411911*^9, 3.8798622532965317`*^9}, {3.879862911499352*^9, 
   3.8798629164908648`*^9}, {3.879924090668075*^9, 3.8799240924866*^9}, {
   3.880039751123473*^9, 3.880039926418474*^9}, {3.8802089289519463`*^9, 
   3.880208929786034*^9}, {3.880209108721879*^9, 3.880209117470488*^9}, {
   3.883482097716852*^9, 3.883482098161255*^9}, {3.883482236455393*^9, 
   3.883482253931513*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"5425f684-098e-452f-a7ba-0bd2b8ace761"],

Cell[CellGroupData[{

Cell["Average", "Section",
 CellChangeTimes->{{3.880527645298526*^9, 
  3.880527646498764*^9}},ExpressionUUID->"06dc4cf2-8c2f-47ad-bf76-\
1eb17d80a387"],

Cell[CellGroupData[{

Cell["No parallelization", "Subsection",
 CellChangeTimes->{{3.880527580036537*^9, 
  3.8805275829486103`*^9}},ExpressionUUID->"02ad95fd-f4d6-4901-8ca7-\
5f17ed106285"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AverageDynamics", "[", 
    RowBox[{"tmax_", ",", "gamma_", ",", "samples_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"l", ",", "data", ",", "s", ",", "i", ",", "site", ",", "j"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"l", "=", 
       RowBox[{"JumpTimes", "[", 
        RowBox[{"tmax", ",", "gamma"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Dynamics", "[", 
          RowBox[{"l", ",", "tmax", ",", 
           RowBox[{"site", "-", "1"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"site", ",", "1", ",", "ssize"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"s", "=", "data"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Mod", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"i", "/", "samples"}], "*", "100"}], ",", "10"}], 
             "]"}], "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{
                RowBox[{"i", "/", "samples"}], "*", "100"}], "]"}], "<>", 
              "\"\<% of \>\"", "<>", 
              RowBox[{"ToString", "[", "samples", "]"}], "<>", 
              "\"\< samples done!\>\""}], "]"}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"l", "=", 
          RowBox[{"JumpTimes", "[", 
           RowBox[{"tmax", ",", "gamma"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"data", "=", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Dynamics", "[", 
             RowBox[{"l", ",", "tmax", ",", 
              RowBox[{"site", "-", "1"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"site", ",", "1", ",", "ssize"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}], "+=", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", "samples"}], "}"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"s", "[", 
        RowBox[{"[", 
         RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}], "/=", "samples"}],
       ";", "\[IndentingNewLine]", "s"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.869384680650875*^9, 3.869384981066822*^9}, {
   3.869385080780333*^9, 3.869385081097096*^9}, {3.869385127597068*^9, 
   3.869385186937264*^9}, {3.8693852879555387`*^9, 3.869385292378841*^9}, {
   3.869385347122353*^9, 3.8693853512250967`*^9}, {3.869385479533023*^9, 
   3.869385511577338*^9}, 3.869385559149295*^9, {3.869386185102252*^9, 
   3.869386209801724*^9}, {3.869386499582264*^9, 3.8693867106827307`*^9}, {
   3.869386742174733*^9, 3.869386823246338*^9}, {3.869386891758718*^9, 
   3.869386892187235*^9}, 3.869386952174752*^9, {3.8693870226225643`*^9, 
   3.86938702493897*^9}, {3.8693871152148438`*^9, 3.869387185310936*^9}, {
   3.8693872157428923`*^9, 3.8693872300431213`*^9}, {3.869387306785063*^9, 
   3.86938733871905*^9}, {3.8693874170555696`*^9, 3.86938742292343*^9}, {
   3.869390568112082*^9, 3.869390645075499*^9}, {3.869390700623083*^9, 
   3.869390716383162*^9}, 3.869390750976474*^9, {3.869391105863196*^9, 
   3.869391108931583*^9}, {3.869391651114599*^9, 3.8693916572361107`*^9}, 
   3.8693918011463423`*^9, {3.8693923602506647`*^9, 3.869392364228984*^9}, {
   3.86939335839485*^9, 3.869393363042889*^9}, {3.869551562698032*^9, 
   3.869551758410886*^9}, {3.86955179385211*^9, 3.869551794043009*^9}, {
   3.869551844238326*^9, 3.869551847821639*^9}, 3.8695518824247713`*^9, {
   3.869551915606978*^9, 3.869552044310719*^9}, {3.869552089858502*^9, 
   3.869552158888233*^9}, {3.869552323757848*^9, 3.869552450645014*^9}, {
   3.869552505472313*^9, 3.869552511501607*^9}, {3.869552558298688*^9, 
   3.869552684512248*^9}, {3.8695527819943132`*^9, 3.869552791233398*^9}, {
   3.8695529291831217`*^9, 3.869552981933014*^9}, {3.869553092617182*^9, 
   3.8695531019756517`*^9}, {3.869553146944129*^9, 3.869553147367036*^9}, {
   3.869554113798326*^9, 3.869554205013688*^9}, {3.869554236894998*^9, 
   3.8695542528797092`*^9}, {3.8695542861279488`*^9, 
   3.8695543334879837`*^9}, {3.869554374585094*^9, 3.869554376809273*^9}, {
   3.869554423866905*^9, 3.869554450386392*^9}, {3.869555602037032*^9, 
   3.8695556271652727`*^9}, {3.869555769306286*^9, 3.869555769751108*^9}, {
   3.869555832265006*^9, 3.869555857992688*^9}, {3.869555958394001*^9, 
   3.869556030763*^9}, 3.8695560886831417`*^9, {3.869556133404284*^9, 
   3.869556168756226*^9}, {3.8695563038055067`*^9, 3.8695563878071423`*^9}, {
   3.869556481787642*^9, 3.869556513141345*^9}, {3.8695566391992598`*^9, 
   3.8695566934942627`*^9}, {3.86955676353611*^9, 3.869556767871091*^9}, {
   3.869556863708552*^9, 3.869556876209042*^9}, {3.869556918278223*^9, 
   3.869556919793543*^9}, 3.8695570254193497`*^9, 3.869563689137718*^9, {
   3.869628727657803*^9, 3.869628755227305*^9}, {3.8698033439154*^9, 
   3.869803359416931*^9}, {3.8698034147253933`*^9, 3.8698034236203814`*^9}, {
   3.8698035780411987`*^9, 3.869803631064176*^9}, {3.869803674412877*^9, 
   3.869803693511792*^9}, {3.869803841530798*^9, 3.869803841666142*^9}, {
   3.8698042560094357`*^9, 3.869804257025201*^9}, {3.869805024764929*^9, 
   3.8698050294516497`*^9}, {3.8698130795062723`*^9, 3.8698130972130213`*^9}, 
   3.8698297606762037`*^9, {3.87318445052559*^9, 3.873184469703539*^9}, 
   3.873184664906846*^9, {3.873185974051001*^9, 3.873185987572731*^9}, {
   3.873186386746572*^9, 3.873186393129364*^9}, 3.873186570493311*^9, {
   3.873187760844708*^9, 3.873187776537649*^9}, 3.873189063706675*^9, 
   3.873342126439752*^9, 3.8786213371516533`*^9, {3.878621386170764*^9, 
   3.878621391546671*^9}, {3.878621454837761*^9, 3.878621455329134*^9}, {
   3.8786216400507793`*^9, 3.878621642522759*^9}, {3.878621716576701*^9, 
   3.8786217853313026`*^9}, {3.878621939003024*^9, 3.87862193946834*^9}, 
   3.878622154869082*^9, {3.878622186341557*^9, 3.8786222679627523`*^9}, {
   3.87862232383884*^9, 3.878622342817626*^9}, {3.8786225374446383`*^9, 
   3.878622640789525*^9}, {3.8786227083921223`*^9, 3.878622719458621*^9}, {
   3.8786229252422953`*^9, 3.878622981040126*^9}, {3.878624815988184*^9, 
   3.878624836437791*^9}, {3.878628331976399*^9, 3.8786283322884398`*^9}, {
   3.878629364892087*^9, 3.878629384535406*^9}, {3.878630271681922*^9, 
   3.878630271781439*^9}, {3.878710842040607*^9, 3.878710845638171*^9}, {
   3.879322103739077*^9, 3.879322123491067*^9}, {3.879924339938549*^9, 
   3.879924342158333*^9}, {3.879924624918694*^9, 3.8799246257829103`*^9}, {
   3.880527587945118*^9, 3.880527627774335*^9}, {3.880693615651885*^9, 
   3.88069361930551*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"fa9dbc8c-981e-422d-a77e-ce12b5ccdd46"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parallelize over sites", "Subsection",
 CellChangeTimes->{{3.878711392241825*^9, 
  3.8787114214568043`*^9}},ExpressionUUID->"cc4f629a-a970-4f44-a9f2-\
ce137f3bdbef"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AverageDynamics", "[", 
    RowBox[{"tmax_", ",", "gamma_", ",", "samples_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"l", ",", "data", ",", "s", ",", "i", ",", "site", ",", "j"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"l", "=", 
       RowBox[{"JumpTimes", "[", 
        RowBox[{"tmax", ",", "gamma"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"ParallelTable", "[", 
        RowBox[{
         RowBox[{"Dynamics", "[", 
          RowBox[{"l", ",", "tmax", ",", 
           RowBox[{"site", "-", "1"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"site", ",", "1", ",", "ssize"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"s", "=", "data"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Mod", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"i", "/", "samples"}], "*", "100"}], ",", "10"}], 
             "]"}], "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{
                RowBox[{"i", "/", "samples"}], "*", "100"}], "]"}], "<>", 
              "\"\<% of \>\"", "<>", 
              RowBox[{"ToString", "[", "samples", "]"}], "<>", 
              "\"\< samples done!\>\""}], "]"}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"l", "=", 
          RowBox[{"JumpTimes", "[", 
           RowBox[{"tmax", ",", "gamma"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"data", "=", 
          RowBox[{"ParallelTable", "[", 
           RowBox[{
            RowBox[{"Dynamics", "[", 
             RowBox[{"l", ",", "tmax", ",", 
              RowBox[{"site", "-", "1"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"site", ",", "1", ",", "ssize"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}], "+=", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", "samples"}], "}"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"s", "[", 
        RowBox[{"[", 
         RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}], "/=", "samples"}],
       ";", "\[IndentingNewLine]", "s"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.878710863173573*^9, 3.8787109345739737`*^9}, {
   3.878710999685038*^9, 3.878711025352705*^9}, {3.8787196080362673`*^9, 
   3.878719609978757*^9}, {3.879315796594838*^9, 3.8793157980858307`*^9}, {
   3.87932207962046*^9, 3.879322099955701*^9}, {3.8793223267790327`*^9, 
   3.879322347438457*^9}, {3.879326562587129*^9, 3.8793265655942793`*^9}, 
   3.879326707161569*^9, {3.879497431206194*^9, 3.879497599341537*^9}, 
   3.879497693275358*^9, {3.880210185512747*^9, 3.880210187474272*^9}, {
   3.880693608583709*^9, 3.8806936118425198`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"994a952e-bc52-4061-abd1-a96a71cd1de1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parallelize over samples", "Subsection",
 CellChangeTimes->{{3.878711392241825*^9, 
  3.8787114026009912`*^9}},ExpressionUUID->"a001f6d1-4ee3-49eb-b975-\
1681168ac30a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"!!", 
    RowBox[{"not", " ", "thread", " ", 
     RowBox[{"safe", "!!"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"AverageDynamics", "[", 
      RowBox[{"tmax_", ",", "gamma_", ",", "samples_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"l", ",", "data", ",", "s", ",", "i", ",", "site", ",", "j"}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"l", "=", 
         RowBox[{"JumpTimes", "[", 
          RowBox[{"tmax", ",", "gamma"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"data", "=", 
         RowBox[{"ParallelTable", "[", 
          RowBox[{
           RowBox[{"Dynamics", "[", 
            RowBox[{"l", ",", "tmax", ",", 
             RowBox[{"site", "-", "1"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"site", ",", "1", ",", "20"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"SetSharedVariable", "[", "s", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"s", "=", "data"}], ";", "\[IndentingNewLine]", 
        RowBox[{"ParallelDo", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"l", "=", 
            RowBox[{"JumpTimes", "[", 
             RowBox[{"tmax", ",", "gamma"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"data", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"Dynamics", "[", 
               RowBox[{"l", ",", "tmax", ",", 
                RowBox[{"site", "-", "1"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"site", ",", "1", ",", "20"}], "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}], "+=", 
            RowBox[{"data", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}], ";"}], 
          "\[IndentingNewLine]", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "2", ",", "samples"}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"s", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}], "/=", 
         "samples"}], ";", "\[IndentingNewLine]", "s"}]}], "]"}]}], ";"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.878711434900976*^9, 3.878711442067819*^9}, {
   3.878711482676216*^9, 3.8787114831670303`*^9}, {3.878711532919977*^9, 
   3.878711552705098*^9}, {3.878711665293481*^9, 3.8787117201867723`*^9}, {
   3.87871175488662*^9, 3.878711756081955*^9}, {3.879322044972046*^9, 
   3.879322073673848*^9}, 3.880527550800933*^9, {3.880532980219136*^9, 
   3.88053298978832*^9}, {3.880695806583482*^9, 
   3.880695809687215*^9}},ExpressionUUID->"8761b297-51b3-4872-9566-\
4d1ec53bedca"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AverageDynamics", "[", 
    RowBox[{"tmax_", ",", "gamma_", ",", "samples_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "l", ",", "data", ",", "s", ",", "i", ",", "site", ",", "j", ",", 
       "scount", ",", "count"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"l", "=", 
       RowBox[{"JumpTimes", "[", 
        RowBox[{"tmax", ",", "gamma"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"ParallelTable", "[", 
        RowBox[{
         RowBox[{"Dynamics", "[", 
          RowBox[{"l", ",", "tmax", ",", 
           RowBox[{"site", "-", "1"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"site", ",", "1", ",", "ssize"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetSharedVariable", "[", 
       RowBox[{"s", ",", "scount"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"scount", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"s", "=", "data"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ParallelDo", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"l", "=", 
          RowBox[{"JumpTimes", "[", 
           RowBox[{"tmax", ",", "gamma"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"data", "=", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Dynamics", "[", 
             RowBox[{"l", ",", "tmax", ",", 
              RowBox[{"site", "-", "1"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"site", ",", "1", ",", "ssize"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"s", "+=", "data"}], ";", "\[IndentingNewLine]", 
         RowBox[{"count", "=", 
          RowBox[{"++", "scount"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Mod", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"count", "/", "samples"}], "*", "100"}], ",", "10"}], 
             "]"}], "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{
                RowBox[{"count", "/", "samples"}], "*", "100"}], "]"}], "<>", 
              "\"\<% of \>\"", "<>", 
              RowBox[{"ToString", "[", "samples", "]"}], "<>", 
              "\"\< samples done!\>\""}], "]"}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", "samples"}], "}"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"s", "/=", "samples"}], ";", "\[IndentingNewLine]", "s"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.880532674622972*^9, 3.880532698368291*^9}, {
  3.880532730748006*^9, 3.880532746801565*^9}, {3.88053287739977*^9, 
  3.8805328977389708`*^9}, {3.880693601234939*^9, 3.880693604574554*^9}, {
  3.880695677696527*^9, 3.880695760718707*^9}, {3.880696197554493*^9, 
  3.880696199188517*^9}, {3.880696235395616*^9, 3.880696237834278*^9}, {
  3.8807008963176823`*^9, 3.88070091523237*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"a7dbc4cc-3130-40c7-b131-32602ec11eb1"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"AbsoluteTiming", "[", 
    RowBox[{"result", "=", 
     RowBox[{"AverageDynamics", "[", 
      RowBox[{"50.0", ",", "0.1", ",", "10"}], "]"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.880210196155199*^9, 3.8802101962616177`*^9}, {
  3.880527667868216*^9, 
  3.880527676572435*^9}},ExpressionUUID->"7266f806-d263-45ae-b51b-\
e8af4f7cb550"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Run average", "Section",
 CellChangeTimes->{{3.880527691116633*^9, 
  3.880527696126913*^9}},ExpressionUUID->"f8ab2840-fd76-4592-be13-\
dc554a55c814"],

Cell[CellGroupData[{

Cell["1k", "Subsubsection",
 CellChangeTimes->{{3.88052770536115*^9, 
  3.880527705524852*^9}},ExpressionUUID->"8742a87c-638c-4e87-92dc-\
87e3301047e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AbsoluteTiming", "[", 
   RowBox[{"result", "=", 
    RowBox[{"AverageDynamics", "[", 
     RowBox[{"tmax", ",", "0.1", ",", "1000"}], "]"}]}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.880210528344657*^9, 3.880210532707677*^9}, {
   3.880696849641932*^9, 3.880696850149015*^9}, 3.883483565327948*^9, 
   3.883555948747205*^9},
 CellLabel->"In[15]:=",ExpressionUUID->"c81645a6-0a4a-48cd-bed4-f47b6e0cd853"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"result", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", ".02"}], ",", ".02"}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}], ",", " ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.880526927620995*^9, 3.880526928373063*^9}, {
  3.88348345342951*^9, 3.8834834555070744`*^9}, {3.8835563360095778`*^9, 
  3.883556338990776*^9}, {3.884097283644205*^9, 3.884097287574409*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"8034c7cc-6f90-468f-8790-163df6526898"]
}, Open  ]],

Cell[CellGroupData[{

Cell["10k", "Subsubsection",
 CellChangeTimes->{{3.880527712145125*^9, 
  3.880527712541067*^9}},ExpressionUUID->"d88111c1-b133-4a40-9539-\
207900e2d39d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AbsoluteTiming", "[", 
   RowBox[{"result10k", "=", 
    RowBox[{"AverageDynamics", "[", 
     RowBox[{"tmax", ",", "0.1", ",", "10000"}], "]"}]}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8787191843853397`*^9, 3.878719208869895*^9}, {
  3.878719344601131*^9, 3.878719345400552*^9}, {3.87871945770785*^9, 
  3.878719457818811*^9}, {3.879313614917692*^9, 3.879313616989564*^9}, {
  3.880210521245694*^9, 3.880210536065884*^9}, {3.880437089495522*^9, 
  3.880437100322096*^9}, {3.880443894701564*^9, 3.880443895972713*^9}, {
  3.880524464887456*^9, 3.880524468041626*^9}, {3.880696854997158*^9, 
  3.880696855415359*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"922c607a-1bab-40de-953d-4132b5122986"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"result10k", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", ".02"}], ",", ".02"}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.880526405468357*^9, 3.880526455701277*^9}, {
  3.883561022765297*^9, 3.8835610245614357`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"64fb234a-19e2-4f33-8080-10a62fcdae28"]
}, Open  ]],

Cell[CellGroupData[{

Cell["100k", "Subsubsection",
 CellChangeTimes->{{3.880527764929022*^9, 
  3.880527765549437*^9}},ExpressionUUID->"96660b8a-4e63-4a07-b14f-\
585d7608b682"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AbsoluteTiming", "[", 
   RowBox[{"result100k", "=", 
    RowBox[{"AverageDynamics", "[", 
     RowBox[{"tmax", ",", "0.1", ",", "100000"}], "]"}]}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.880527489394924*^9, {3.8805277466336517`*^9, 3.8805277746064987`*^9}, {
   3.880696858912426*^9, 3.8806968594451437`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"6a921bdc-b475-4e92-bcd6-739a7996858d"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"result100k", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", ".01"}], ",", ".01"}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.880526405468357*^9, 3.880526455701277*^9}, 
   3.88052777863505*^9},
 CellLabel->"In[23]:=",ExpressionUUID->"7f0a50e0-9698-41b2-bfd3-c6ad44ad0b05"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Export"], "Section",
 CellChangeTimes->{{3.880524367643756*^9, 
  3.88052437795463*^9}},ExpressionUUID->"fca35eee-09cb-4be0-a283-\
dab41202a077"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xresult", "=", "result"}], ";"}]], "Input",
 CellChangeTimes->{{3.880433419234528*^9, 3.88043342779377*^9}, 
   3.880524381357542*^9, 3.880538282558548*^9, 3.880808689422534*^9, 
   3.8808649989793577`*^9, 3.883561227848433*^9, {3.8842680305601892`*^9, 
   3.884268031618195*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"735a3d1e-d71d-49f9-bfe1-721adead1195"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConvertResult", "[", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"site", ",", "j"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"xresult", "[", 
            RowBox[{"[", 
             RowBox[{"site", ",", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Mod", "[", 
               RowBox[{
                RowBox[{"site", "-", "1", "+", "10"}], ",", "20"}], "]"}], 
              "+", "1"}], ",", 
             RowBox[{"xresult", "[", 
              RowBox[{"[", 
               RowBox[{"site", ",", "j", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"xresult", "[", 
              RowBox[{"[", 
               RowBox[{"site", ",", "j", ",", "2"}], "]"}], "]"}]}], "}"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", 
            RowBox[{"Length", "[", 
             RowBox[{"xresult", "[", 
              RowBox[{"[", "site", "]"}], "]"}], "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"site", ",", "1", ",", "20"}], "}"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"data", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"data", ",", 
            RowBox[{"xresult", "[", 
             RowBox[{"[", "site", "]"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"data", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"data", ",", 
            RowBox[{"{", "\"\<\>\"", "}"}]}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"site", ",", "11", ",", "20"}], "}"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"data", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"data", ",", 
            RowBox[{"xresult", "[", 
             RowBox[{"[", "site", "]"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"data", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"data", ",", 
            RowBox[{"{", "\"\<\>\"", "}"}]}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"site", ",", "1", ",", "10"}], "}"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xresult", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"data", ",", "1"}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.880211805780237*^9, 3.880211826502082*^9}, {
  3.880443634394602*^9, 3.880443634493169*^9}, {3.880513835897668*^9, 
  3.880513838770158*^9}, {3.880524385314267*^9, 3.880524400673377*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"a5817ae4-1d8f-4137-87f4-559b3949235f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConvertResult", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.880524421863859*^9, 3.880524425412809*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"a949d7e4-93f6-4264-ba9a-947435809c58"],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<2baths_prediction_all_amplitudes_OBC_D10_t200.dat\>\"", ",", 
   "xresult"}], "]"}]], "Input",
 CellChangeTimes->{
  3.880524429524817*^9, {3.880526364311252*^9, 3.880526365434874*^9}, {
   3.8805382924589243`*^9, 3.880538299162266*^9}, {3.880696864836706*^9, 
   3.880696865642889*^9}, {3.8808086968757257`*^9, 3.880808697332129*^9}, {
   3.8808650089095383`*^9, 3.8808650121446657`*^9}, {3.883561238031433*^9, 
   3.8835612474205923`*^9}, {3.884268038005713*^9, 3.8842680542106533`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"5bcaaa93-1764-4e88-80b9-8c97966e09da"]
}, Open  ]]
},
WindowSize->{970, 847},
WindowMargins->{{327, Automatic}, {Automatic, 44}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[400, 13, 797, 16, 110, "Input",ExpressionUUID->"f720684b-decf-4c50-9eeb-2e7a58180af0",
 InitializationCell->True],
Cell[1200, 31, 663, 12, 68, "Input",ExpressionUUID->"1ed4b6d2-06ac-418d-9f75-fb179df5d77b",
 InitializationCell->True],
Cell[1866, 45, 191, 2, 30, "Input",ExpressionUUID->"f02de342-b4be-4d08-93a4-8dc1afc60909"],
Cell[2060, 49, 5059, 110, 446, "Input",ExpressionUUID->"d3dd7bdc-5c3b-4985-be56-e2f3b074a335",
 InitializationCell->True],
Cell[7122, 161, 460, 11, 68, "Input",ExpressionUUID->"cf630415-fbee-4002-8706-af39824482b9",
 InitializationCell->True],
Cell[7585, 174, 1407, 32, 52, "Input",ExpressionUUID->"e40be50e-9763-458f-8c75-a7d76f7e8acb"],
Cell[8995, 208, 2452, 57, 299, "Input",ExpressionUUID->"2c60896b-6ac5-4f51-b54c-40dfa7c069f3",
 InitializationCell->True],
Cell[11450, 267, 917, 22, 131, "Input",ExpressionUUID->"1bede55f-a1a8-4db2-91f1-4f3d61dcc307",
 InitializationCell->True],
Cell[12370, 291, 426, 11, 30, "Input",ExpressionUUID->"708fdf6b-8dfa-496d-b521-f894580be0be"],
Cell[12799, 304, 8567, 183, 509, "Input",ExpressionUUID->"ae8be8f4-e682-4437-ade4-f7603461378f",
 InitializationCell->True],
Cell[21369, 489, 1674, 38, 73, "Input",ExpressionUUID->"5425f684-098e-452f-a7ba-0bd2b8ace761"],
Cell[CellGroupData[{
Cell[23068, 531, 152, 3, 67, "Section",ExpressionUUID->"06dc4cf2-8c2f-47ad-bf76-1eb17d80a387"],
Cell[CellGroupData[{
Cell[23245, 538, 168, 3, 54, "Subsection",ExpressionUUID->"02ad95fd-f4d6-4901-8ca7-5f17ed106285"],
Cell[23416, 543, 7379, 135, 325, "Input",ExpressionUUID->"fa9dbc8c-981e-422d-a77e-ce12b5ccdd46"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30832, 683, 172, 3, 54, "Subsection",ExpressionUUID->"cc4f629a-a970-4f44-a9f2-ce137f3bdbef"],
Cell[31007, 688, 3527, 82, 325, "Input",ExpressionUUID->"994a952e-bc52-4061-abd1-a96a71cd1de1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34571, 775, 174, 3, 54, "Subsection",ExpressionUUID->"a001f6d1-4ee3-49eb-b975-1681168ac30a"],
Cell[34748, 780, 3022, 72, 304, "Input",ExpressionUUID->"8761b297-51b3-4872-9566-4d1ec53bedca"],
Cell[37773, 854, 3378, 77, 404, "Input",ExpressionUUID->"a7dbc4cc-3130-40c7-b131-32602ec11eb1",
 InitializationCell->True],
Cell[41154, 933, 440, 11, 30, "Input",ExpressionUUID->"7266f806-d263-45ae-b51b-e8af4f7cb550"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41643, 950, 156, 3, 67, "Section",ExpressionUUID->"f8ab2840-fd76-4592-be13-dc554a55c814"],
Cell[CellGroupData[{
Cell[41824, 957, 152, 3, 45, "Subsubsection",ExpressionUUID->"8742a87c-638c-4e87-92dc-87e3301047e6"],
Cell[41979, 962, 478, 10, 30, "Input",ExpressionUUID->"c81645a6-0a4a-48cd-bed4-f47b6e0cd853"],
Cell[42460, 974, 632, 13, 30, "Input",ExpressionUUID->"8034c7cc-6f90-468f-8790-163df6526898"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43129, 992, 154, 3, 45, "Subsubsection",ExpressionUUID->"d88111c1-b133-4a40-9539-207900e2d39d"],
Cell[43286, 997, 771, 14, 30, "Input",ExpressionUUID->"922c607a-1bab-40de-953d-4132b5122986"],
Cell[44060, 1013, 478, 11, 30, "Input",ExpressionUUID->"64fb234a-19e2-4f33-8080-10a62fcdae28"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44575, 1029, 155, 3, 45, "Subsubsection",ExpressionUUID->"96660b8a-4e63-4a07-b14f-585d7608b682"],
Cell[44733, 1034, 467, 10, 30, "Input",ExpressionUUID->"6a921bdc-b475-4e92-bcd6-739a7996858d"],
Cell[45203, 1046, 453, 11, 30, "Input",ExpressionUUID->"7f0a50e0-9698-41b2-bfd3-c6ad44ad0b05"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45705, 1063, 159, 3, 68, "Section",ExpressionUUID->"fca35eee-09cb-4be0-a283-dab41202a077"],
Cell[45867, 1068, 394, 7, 30, "Input",ExpressionUUID->"735a3d1e-d71d-49f9-bfe1-721adead1195"],
Cell[46264, 1077, 3332, 83, 451, "Input",ExpressionUUID->"a5817ae4-1d8f-4137-87f4-559b3949235f"],
Cell[49599, 1162, 224, 4, 30, "Input",ExpressionUUID->"a949d7e4-93f6-4264-ba9a-947435809c58"],
Cell[49826, 1168, 625, 11, 30, "Input",ExpressionUUID->"5bcaaa93-1764-4e88-80b9-8c97966e09da"]
}, Open  ]]
}
]
*)

