dir="../plotdata"

gamma=1.
mu=0.1
Delta=1.5
samples=183880
L=20

file(r,L,D,g,m,samp)=sprintf("< awk '$2==%d'  %s/2baths_Quantum_chain_density_L%d_Delta%.1f_g%.4f_m%.4f_N_E%d_t50.0_dt0.01.joined",r,dir,L,D,g,m,samp)
file_t(t,L,D,g,m,samp)=sprintf("< awk '$1==%f'  %s/2baths_Quantum_chain_density_L%d_Delta%.1f_g%.4f_m%.4f_N_E%d_t50.0_dt0.01.joined",t,dir,L,D,g,m,samp)

eqno="prediction"


#############   output   ######################################################
set terminal epslatex size 3.5,3.5 standalone color colortext 10
set output sprintf("%s.tex",outputname)

########### color-palettes ####################################################
gpscriptdir="."
palette="rdbu.pal"
load gpscriptdir."/".palette

############# multiplot #######################################################
load gpscriptdir."/multiplot.gp"

set size 1,1

left=.2
right=.95
bottom=.1
top=.98
dx=.02
dy=.02
rows=2
cols=1

# init_margins(left, right, bottom, top, dx, dy, rows, cols)
eval(init_margins(left, right, bottom, top, dx, dy, rows, cols))    

set multiplot

########################################################
row=1
col=1
eval(set_margins(col,row))

set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,0
set xlabel '$t J$' offset 0,0

set label '(a)'.sprintf(' $\gamma/J = %.1f, \ \mu = %.1f$',gamma,mu) at graph 0.05, 0.08

xmin = -.5
xmax = 50.5
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1

ymin = -0.65
ymax = 0.65
set yrange [ymin:ymax]
set ytics .5 offset 0,0
set mytics 2

set arrow from 45,0.5 to 45,-0.5 lw 2 lc rgb 'black' head filled front
set label '$r=1$'  at graph 0.83, 0.92 left
set label '$r=11$' at graph 0.83, 0.06 left

unset colorbox

unset xlabel
set format x ''

set key at graph 0.6, 0.97 right  samplen 1 maxrows 1 width -3

mod(x,m)=x-(floor(x/m)*m)

p	for  [i=0:10] sprintf("< awk '$1==%d' %s/2baths_prediction_all_amplitudes_large_gamma.dat",mod(i+10,20)+1,dir) u 2:($3/0.05):(i) ti '' w l dt 1 lw 3 lc palette, \
	for [i=0:10] file(i,L,Delta,gamma,mu,samples) u 1:(0.5*($3-0.5)/0.05):(i) every 10 ti '' w p pt 6 ps 1 lw 2 lc palette, \
	NaN ti 'data' w p pt 6 ps 1 lw 2 lc rgb "black", \
    NaN ti eqno w l  dt 1 lw 2 lc rgb "black"

unset arrow
unset label
unset object
#set key default

unset logscale x
unset logscale y

set format x 

########################################################
row=2

eval(set_margins(col,row))

gamma=.1
mu=1.
samples=61440

set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,0
set xlabel '$t J$' offset 0,0

set label '(b)'.sprintf(' $\gamma/J = %.1f, \ \mu = %.1f$',gamma,mu) at graph 0.05, 0.08

xmin = -.5
xmax = 50.5
set xrange [xmin:xmax]
set xtics 10 offset 0,0
set mxtics 1

ymin = -0.4
ymax = 0.4
set yrange [ymin:ymax]
set ytics 0.3 offset 0,0
set mytics 3

set arrow from 45,0.31 to 45,-0.31 lw 2 lc rgb 'black' head filled front
set label '$r=1$'  at graph 0.83, 0.92 left
set label '$r=11$' at graph 0.83, 0.06 left


unset colorbox

mod(x,m)=x-(floor(x/m)*m)

p	for  [i=0:10] sprintf("< awk '$1==%d' %s/2baths_prediction_all_amplitudes_large_mu.dat",mod(i+10,20)+1,dir) u 2:($3/(mu/2)):(i) ti '' w l dt 1 lw 3 lc palette, \
	for [i=0:10] file(i,L,Delta,gamma,mu,samples) u 1:(0.5*($3-0.5)/(mu/2)):(i) every 10 ti '' w p pt 6 ps 1 lw 2 lc palette, \
	NaN ti 'data' w p pt 6 ps 1 lw 2 lc rgb "black", \
    NaN ti eqno w l  dt 1 lw 2 lc rgb "black"


unset arrow
unset label
unset object
set key default

unset logscale x
unset logscale y
