dir="../plotdata/OBC"
dirTEBD="../plotdata/TEBD"

gamma=0.1
mu=0.1
Delta=1.5
samples=365220
L=20

file(r,L,D,g,m,samp)=sprintf("< awk '$2==%d'  %s/2baths_OBC_Quantum_chain_density_L%d_Delta%.1f_g%.4f_m%.4f_N_E%d_t50.0_dt0.01.joined",r,dir,L,D,g,m,samp)
file_t(t,L,D,g,m,samp)=sprintf("< awk '$1==%f'  %s/2baths_OBC_Quantum_chain_density_L%d_Delta%.1f_g%.4f_m%.4f_N_E%d_t50.0_dt0.01.joined",t,dir,L,D,g,m,samp)
TEBDfile(dt,r)=sprintf("< awk  '{print %f*(NR-1), $%d}' %s/Spin_config_L20.txt",dt,r,dirTEBD)
TEBDfile_t(t,dt,r)=sprintf("< awk  '%f*(NR-1)==%f {print %d, $%d}' %s/Spin_config_L20.txt",dt,t,r,r,dirTEBD)

eqno="prediction"


#############   output   ######################################################
set terminal epslatex size 3.5,4. standalone color colortext 10
set output sprintf("%s.tex",outputname)

########### color-palettes ####################################################
gpscriptdir="."
palette="rdbu.pal"
load gpscriptdir."/".palette

############# multiplot #######################################################
load gpscriptdir."/multiplot.gp"

set size 1,1

left=.2
right=.95
bottom=.6
top=.95
dx=.02
dy=.02
rows=1
cols=1

# init_margins(left, right, bottom, top, dx, dy, rows, cols)
eval(init_margins(left, right, bottom, top, dx, dy, rows, cols))    

set multiplot

########################################################
row=1
col=1
eval(set_margins(col,row))

set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,0
set xlabel '$t J$' offset 0,.8

set label '($\gamma/J = \mu = 0.1$)' at graph 0.3, 1.08

set label '(a)' at graph 0.02, 0.92

xmin = -.2
xmax = 25.2
set xrange [xmin:xmax]
set xtics 5 offset 0,0
set mxtics 1

ymin = -0.45
ymax = 0.45
set yrange [ymin:ymax]
set ytics .4 offset 0,0

set arrow from graph .5,.86 to graph .5,.14 lw 2 lc rgb 'black' head filled front
set label '$r=1$'  at graph 0.43, 0.92 left
set label '$r=20$' at graph 0.43, 0.06 left

unset colorbox

darkgrey='#666666'

set key at graph 0.38, 0.97 right samplen 1

mod(x,m)=x-(floor(x/m)*m)

p	for  [i=0:19] sprintf("< awk '$1==%d' %s/2baths_OBC_prediction_all_amplitudes_D%d.dat",mod(i+10,20)+1,dir,Delta*10) u 2:($3/0.05):(i) ti '' w l dt 1 lw 3 lc palette, \
	for [i=1:20] TEBDfile(1,i) u (1.00*$1):(0.50*$2/(0.05)) every 1 ti ''  w p pt 7 ps .8 lc rgb darkgrey, \
	for [i=0:19] file(i,L,Delta,gamma,mu,samples) using 1:(0.5*($3-0.5)/0.05):(i) every 5 ti '' w p pt 6 ps .6 lw 2 lc palette, \
	NaN ti 'data' w p pt 6 ps 1 lw 2 lc rgb "black", \
	NaN ti 'TEBD' w p pt 7 ps 1 lw 2 lc rgb darkgrey
	
set key at graph 0.38, 0.15 right samplen 1

p 	NaN ti eqno w l  dt 1 lw 2 lc rgb "black"


unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################
# init_margins(left, right, bottom, top, dx, dy, rows, cols)
bottom=.0
top=.53
dy=.08
rows=2
eval(init_margins(left, right, bottom, top, dx, dy, rows, cols))   
eval(set_margins(col,row))

time=50

set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,0.2
set xlabel '$r$' offset 0,1.2

set label '(b) $t J = $'.sprintf("%d",time) at graph 0.02, 0.15

xmin = .8
xmax = 20.2
set xrange [xmin:xmax]
set xtics 1,19,20 offset 0,0
set mxtics 1

ymin = -0.6
ymax =  0.6
set yrange [ymin:ymax]
set ytics .5 offset 0,0

set key at graph 1., 0.97 right samplen 1 maxrows 2 width -3

######### fit ###########

a = 1.
b = 1.

f(x) = a*x+b

range=5
fit [11-range:11+range] f(x) sprintf("< awk '$2==%d' %s/2baths_OBC_prediction_all_amplitudes_D%d.dat",time,dir,Delta*10) u (mod($1+9,20)+1):($3/0.05) via a,b

set print sprintf("fits_%s.dat",outputname)
print '# f(x)=a*x+b'
print '# fit    a   b'
print sprintf('f1 %+f %+f',a,b)

######################

p	file_t(time,L,Delta,gamma,mu,samples) u ($2+1):(0.5*($3-0.5)/0.05) ti 'data' w p pt 6 ps 1.2 lw 3 lc rgb "orange",\
	for [i=1:20] TEBDfile_t(time,1,i) u 1:(0.50*$2/(0.05)) every 1 ti '' w p pt 7 ps .8 lc rgb darkgrey,\
	NaN ti 'TEBD' w p pt 7 ps 1 lw 2 lc rgb darkgrey, \
    sprintf("< awk '$2==%d' %s/2baths_OBC_prediction_all_amplitudes_D%d.dat",time,dir,Delta*10) u (mod($1+9,20)+1):($3/0.05) ti eqno w p pt 2 ps 1.2 lw 2 lc rgb "blue" ,\
    f(x) ti 'linear fit' w l dt 1 lw 2 lc rgb "black" 

unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################
row=2
eval(set_margins(col,row))

set ylabel '$\langle \delta S_{\mathrm{B}_1}^{z}(t) \rangle / (\mu/2)$' offset -1,0
#set ylabel '\Large $\frac{\langle \delta S_{\mathrm{B},1}^{z}(t) \rangle}{ 2 \, (\mu/2)}$' offset -0,0
#set ylabel '$\langle \delta S_{\mathrm{B},1}^{z}(t) \rangle / \mu$' offset -1,0
set xlabel '$t J$' offset 0,.8

set label '(c)' at graph 0.02, 0.85

xmin = -.5
xmax = time+.5
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1

ymin = -.05
ymax = 2
set yrange [ymin:ymax]
set ytics 1.5 offset 0,0
#set mytics 3

set key at graph 0.98, 0.45 samplen 1

######### fit ###########
a = 1.
b = 1.
f(x) = a*x+b

fit [time-10:time] f(x) dir.sprintf("/2baths_OBC_prediction_all_amplitudes_D%d_current.dat",Delta*10) u 1:($2/0.05) via a,b

print sprintf('f3 %+f %+f',a,b)
#########################

p	dir.sprintf("/2baths_OBC_prediction_all_amplitudes_D%d_current.dat",Delta*10) u 1:($2/0.05) every 20 ti eqno w p pt 2 ps 1.2 lw 2 lc rgb "blue" ,\
    f(x) ti 'linear fit' w l dt 1 lw 2        lc rgb "black"

unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################