dir="../plotdata"

gamma=0.1
mu=0.1
Delta=1.5
L=36

prediction(r)=sprintf("< awk '$1==%d' %s/2baths_prediction_all_amplitudes_perfect.dat",r,dir)
prediction_t(t)=sprintf("< awk '$2==%f' %s/2baths_prediction_all_amplitudes_perfect.dat",t,dir)

eqno="prediction"

#############   output   ######################################################
set terminal epslatex size 3.5,4. standalone color colortext 10
set output sprintf("%s.tex",outputname)

########### color-palettes ####################################################
gpscriptdir="."
palette="rdbu.pal"
load gpscriptdir."/".palette

############# multiplot #######################################################
load gpscriptdir."/multiplot.gp"

set size 1,1

left=.2
right=.95
bottom=.6
top=.95
dx=.02
dy=.02
rows=1
cols=1

# init_margins(left, right, bottom, top, dx, dy, rows, cols)
eval(init_margins(left, right, bottom, top, dx, dy, rows, cols))    

set multiplot

########################################################
row=1
col=1
eval(set_margins(col,row))


set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,0
set xlabel '$t J$' offset 0,.8

set label '($\gamma/J = \mu = 0.1$)' at graph 0.3, 1.08

set label '(a)' at graph 0.05, 0.08

xmin =   0
xmax = 100
set xrange [xmin:xmax]
set xtics 0,20,100 offset 0,0
set mxtics 1

ymin = -0.35
ymax = 0.35
set yrange [ymin:ymax]
set ytics .3 offset 0,0
set mytics 3

set arrow from 58,0.32 to 58,-0.32 lw 2 lc rgb 'black' head filled front
set label '$r=1$'  at graph 0.56, 0.94 right
set label '$r=19$' at graph 0.56, 0.05 right 

unset colorbox

set key at graph 0.38, 0.97 right samplen 1

mod(x,m)=x-(floor(x/m)*m)

p	for [i=0:18]  prediction(mod(i+18,36)+1) u 2:($3/0.05):(i) ti '' w l dt 1 lw 3 lc palette, \
	NaN ti eqno w l  dt 1 lw 2 lc rgb "black"


unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################
# init_margins(left, right, bottom, top, dx, dy, rows, cols)
bottom=.0
top=.53
dy=.08
rows=2
eval(init_margins(left, right, bottom, top, dx, dy, rows, cols))   
eval(set_margins(col,row))

set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,0.2
set xlabel '$r$' offset -7,1

set label '(b) $t J = 100$' at graph 0.05, 0.15

xmin = -.5
xmax = 35.5
set xrange [xmin:xmax]
set xtics 0,19,19 offset 0,0
set mxtics 1
set xtics ("1" 0, "19" 18, "36" 35)

ymin = -0.4
ymax = 0.4
set yrange [ymin:ymax]
set ytics -0.4,0.4,0.4 offset 0,0
set mytics 4

set key at graph 0.69, 0.90 samplen 1

######### fit ###########

a = 1.
c = 1.
b = 1.
d = 1.

f(x) = a*x+b
g(x) = c*x+d

fit [2:18] f(x) prediction_t(100) u 1:(-$3/0.05) via a,b

fit [20:36] g(x) prediction_t(100) u 1:(-$3/0.05) via c,d

set print sprintf("fits_%s.dat",outputname)
print '# f(x)=a*x+b'
print '# fit    a   b'
print sprintf('f1 %+f %+f',a,b)
print sprintf('f2 %+f %+f',c,d)

######################

plot prediction_t(100) u ($1-1):(-$3/0.05) ti eqno w p pt 2 ps 1.2 lw 2 lc rgb "blue" ,\
    f(x+1) ti 'linear fit' w l dt 1 lw 2 lc rgb "black" ,\
    g(x+1) ti '' w l  dt 1 lw 2 lc rgb "black"

unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################
row=2
eval(set_margins(col,row))

set ylabel '$\langle \delta S_{\mathrm{B}_1}^{z}(t) \rangle / [2\,(\mu/2)]$' offset -3.0,0
set xlabel '$t J$' offset 0,.8

set label '(c)' at graph 0.05, 0.85

xmin =   -1
xmax = 101
set xrange [xmin:xmax]
set xtics 20 offset 0,0
set mxtics 1

ymin = -.2
ymax = 3
set yrange [ymin:ymax]
set ytics 0,3,3 offset 0,0
set mytics 3

set key at graph 0.98, 0.45 samplen 1

######### fit ###########
a = 1.
b = 1.
f(x) = a*x+b

fit [60:100] f(x) dir."/2baths_prediction_all_amplitudes_perfect_current.dat" u 1:(0.5*$2/0.05) via a,b

print sprintf('f3 %+f %+f',a,b)

#########################

plot dir."/2baths_prediction_all_amplitudes_perfect_current.dat" u 1:(0.5*$2/0.05) every 20 ti eqno w p pt 2 ps 1.2 lw 2 lc rgb "blue" ,\
        f(x) ti 'linear fit' w l dt 1 lw 3 lc rgb "black"

unset arrow
unset label
unset object

unset logscale x
unset logscale y


########################################################