dir="../plotdata"

D=1.5
L=36



#############   output   ######################################################
set terminal epslatex size 3.5,1. color colortext 10 standalone
set output sprintf("%s.tex",outputname)

########### color-palettes ####################################################
gpscriptdir="."
palette="bugn.pal"
load gpscriptdir."/".palette

############# multiplot #######################################################
load gpscriptdir."/multiplot.gp"

set size 1,1

left=.2
right=.95
bottom=.12
top=.97
dx=.02
dy=.15
rows=1
cols=1

# init_margins(left, right, bottom, top, dx, dy, rows, cols)
eval(init_margins(left, right, bottom, top, dx, dy, rows, cols))    

set multiplot

########################################################
row=1
col=1
eval(set_margins(col,row))

set ylabel '$\partial_t \langle S_r^z(t) \rangle / \nabla^2\langle S_r^z(t) \rangle$' offset 0,0
set ylabel '$\frac{\partial_t \langle S_r^z(t) \rangle}{\nabla^2\langle S_r^z(t) \rangle}$' offset 0,0
set ylabel '$D(t)/J$' offset 0,0
set xlabel '$tJ$' offset 0,1.

darkgrey='#333745'

#set label '(a)' at graph 0.05,0.85 front textcolor rgb "black" 

xmin =  0
xmax = 50
set xtics 10
set xrange [xmin:xmax]
ymin =  0.0
ymax =  .9
set ytics .2
set yrange [ymin:ymax]


unset colorbox

#set key at graph .95,.9 right samplen 1 maxrows 1 width -1

set arrow from xmin,.6 to xmax,.6 lc rgb 'grey' dt 4 nohead 

mod(x,m)=x-(floor(x/m)*m)
set label 1 '\scriptsize {\color[rgb]{.11, .11, .11}$N=36,$ $r=12$}' at graph .92,.32 right rotate by -12
set label 2 '\tiny {\color[rgb]{.44, .44, .44}$N=28,$ $r=10$}' at graph .72,.23 right rotate by -15
set label 3 '\tiny {\color[rgb]{.55, .55, .55}$N=20,$ $r=8$}' at graph .56,.13 right rotate by -18 

set tics scale .5
#set arrow from graph .64,.72 to 31,.42 head filled front lc rgb darkgrey lw 2
	
p	dir.'/Dt_example_L20.dat' u 1:2 w l ls 4 lw 3  ti '', \
	dir.'/Dt_example_L28.dat' u 1:2 w l ls 6 lw 3  ti '', \
	dir.'/Dt_example_L36.dat' u 1:2 w l ls 8 lw 3 ti ''

unset arrow
unset label
unset object

unset logscale x
unset logscale y
set key default

