dir="../plotdata"

gamma=0.1
mu=0.1
Delta=1.5
samples=384800
L=20

file(r,L,D,g,m,samp)=sprintf("< awk '$2==%d'  %s/2baths_Quantum_chain_density_L%d_Delta%.1f_g%.4f_m%.4f_N_E%d_t50.0_dt0.01.joined",r,dir,L,D,g,m,samp)
file_t(t,L,D,g,m,samp)=sprintf("< awk '$1==%f'  %s/2baths_Quantum_chain_density_L%d_Delta%.1f_g%.4f_m%.4f_N_E%d_t50.0_dt0.01.joined",t,dir,L,D,g,m,samp)

eqno="prediction"


#############   output   ######################################################
set terminal epslatex size 3.5,2.9 standalone color colortext 10
set output sprintf("%s.tex",outputname)

########### color-palettes ####################################################
gpscriptdir="."
palette="rdbu.pal"
load gpscriptdir."/".palette

############# multiplot #######################################################
load gpscriptdir."/multiplot.gp"

set size 1,1

left=.2
right=.95
bottom=.46
top=.93
dx=.02
dy=.02
rows=1
cols=1

# init_margins(left, right, bottom, top, dx, dy, rows, cols)
eval(init_margins(left, right, bottom, top, dx, dy, rows, cols))    

set multiplot

########################################################
row=1
col=1
eval(set_margins(col,row))

set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,0
set xlabel '$t J$' offset 0,.8

set label '($\gamma/J = \mu = 0.1$)' at graph 0.3, 1.1

set label '(a)' at graph 0.05, 0.08

xmin = -.5
xmax = 50.5
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1

ymin = -0.34
ymax = 0.34
set yrange [ymin:ymax]
set ytics -0.3,0.3,0.3 offset 0,0
set mytics 3

set arrow from 45,0.25 to 45,-0.26 lw 2 lc rgb 'black' head filled front
set label '$r=1$'  at graph 0.83, 0.92 left
set label '$r=11$' at graph 0.83, 0.06 left

unset colorbox

set key at graph -.05, 0.97 left samplen 1 maxrows 1 width -3

mod(x,m)=x-(floor(x/m)*m)

p 	for [i=0:10] sprintf("< awk '$1==%d' %s/2baths_prediction_all_amplitudes_01.dat",mod(i+10,20)+1,dir) using 2:($3/0.05):(i) title ''  with lines  dt 1 lw 3 lc palette, \
	for [i=0:10] file(i,L,Delta,gamma,mu,samples) using 1:(0.5*($3-0.5)/0.05):(i) every 10 title '' with points pt 6 ps 1 lw 2 lc palette, \
	NaN ti 'data' w p pt 6 ps 1 lw 2 lc rgb "black", \
   	NaN ti eqno w l  dt 1 lw 2 lc rgb "black"


unset arrow
unset label
unset object

unset logscale x
unset logscale y
set key default

########################################################
# init_margins(left, right, bottom, top, dx, dy, rows, cols)
bottom=.02
top=.35
dy=.08
rows=1
eval(init_margins(left, right, bottom, top, dx, dy, rows, cols))   
eval(set_margins(col,row))

set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,.2
set xlabel '$r$' offset -7,1.

set label '(b) $t J = 50$' at graph 0.05, 0.15

xmin = -.2
xmax = 19.2
set xrange [xmin:xmax]
set xtics 0,19,19 offset 0,0
set mxtics 1
set xtics ("1" 0, "11" 10, "20" 19)

ymin = -0.3
ymax =  0.3
set yrange [ymin:ymax]
set ytics -0.3,0.3,0.3 offset 0,0
set mytics 3

set key at graph 1., 0.92 samplen 1 maxrows 1 width -3

######### fit ###########

a = 1.
c = 1.
b = 1.
d = 1.

f(x) = a*x+b
g(x) = c*x+d

range=4
mid1=5
mid2=15

#fit [1:9] f(x) file_t(50,L,Delta,gamma,mu,samples) using 2:(0.5*($3-0.5)/0.05) via a,b
#fit [11:19] g(x-10) file_t(50,L,Delta,gamma,mu,samples) using 2:(0.5*($3-0.5)/0.05) via c,d

fit [mid1-range:mid1+range] f(x) sprintf("< awk '$2==%d' %s/2baths_prediction_all_amplitudes_01.dat",50,dir,Delta*10)   using (mod($1+9,20)):($3/0.05) via a,b
fit [mid2-range:mid2+range] g(x-10) sprintf("< awk '$2==%d' %s/2baths_prediction_all_amplitudes_01.dat",50,dir,Delta*10)   using (mod($1+9,20)):($3/0.05) via c,d

set print sprintf("fits_%s.dat",outputname)
print '# f(x)=a*x+b'
print '# fit    a   b'
print sprintf('f1 %+f %+f',a,b)
print sprintf('f2 %+f %+f',c,d)

######### fit current ###########
a1 = 1.
b1 = 1.
f1(x) = a1*x+b1

fit [20:50] f1(x) dir."/2baths_prediction_all_amplitudes_01_current.dat" using 1:(0.5*$2/0.05) via a1,b1

print sprintf('f3 %+f %+f',a1,b1)

######################

p 	for [i=50:50:50] file_t(i,L,Delta,gamma,mu,samples) using 2:(0.5*($3-0.5)/0.05) ti 'data' w p pt 6 ps 1.2 lw 3   lc rgb "orange" ,\
    for [i=50:50:50] sprintf("< awk '$2==%d' %s/2baths_prediction_all_amplitudes_01.dat",i,dir) u ($1-1):(-$3/0.05) ti eqno w p pt 2 ps 1.2 lw 2 lc rgb "blue" ,\
     f(x) ti 'linear fit' w l  dt 1 lw 2 lc rgb "black" ,\
     g(x-10) ti '' w l dt 1 lw 2 lc rgb "black"

unset arrow
unset label
unset object

unset logscale x
unset logscale y

