dir="../plotdata"
dataroot="../plotdata/closed_system"

D=1.5
L=36
t0="0"
t1="5"
t2="10" 
t3="20"

XXZfileQ(L,D,t)=sprintf("< awk '$2 == %s' %s/Quantum_data_Fengping_%dspin_ring_randomamplitudes_d%.1f_data_.dat",t,dataroot,L,D)
sigXXZfileQ(L,D)=sprintf("%s/Quantum_data_Fengping_%dspin_ring_randomamplitudes_d%.1f_data_.dat_SigSq",dataroot,L,D)

sig(t,L,D) = system(sprintf("cat %s/Quantum_data_Fengping_%dspin_ring_randomamplitudes_d%.1f_data_.dat_SigSq | awk '$1==%s {print $2}' ",dataroot,L,D,t))

#############   output   ######################################################
set terminal epslatex size 3.5,2. standalone color colortext 10
set output sprintf("%s.tex",outputname)

########### color-palettes ####################################################
gpscriptdir="."
palette="rdbu.pal"
load gpscriptdir."/".palette

############# multiplot #######################################################
load gpscriptdir."/multiplot.gp"

set size 1,1

left=.2
right=.95
bottom=-.02
top=.92
dx=.02
dy=.15
rows=2
cols=1

# init_margins(left, right, bottom, top, dx, dy, rows, cols)
eval(init_margins(left, right, bottom, top, dx, dy, rows, cols))    

set multiplot

########################################################
row=1
col=1
eval(set_margins(col,row))

set ylabel '$\langle S_r^z(t)S^z_{N/2}(0)\rangle_{\mathrm{eq}}$' offset 0,-.2
set xlabel '$r$' offset 0,1.2

darkgrey='#333745'

set label '(a)' at graph 0.05,0.8 front textcolor rgb "black" 

xmin =  0.5
xmax = 36.5
set xrange [xmin:xmax]
set xtics ("$1$" 1, "$36$" 36)
ymin =  0.00001
ymax =  0.5
set yrange [ymin:ymax]
set log y
set ytics ("$10^{-1}$" 0.1, "$10^{-2}$" 0.01, "$10^{-3}$" 0.001, "$10^{-4}$" 0.0001, "$10^{-5}$" 0.00001)
set ytics ("$10^{-1}$" 0.1, "$10^{-3}$" 0.001, "$10^{-5}$" 0.00001)

set arrow from 20,0.0002 to 30,0.05 head filled front lc rgb darkgrey lw 2
set label sprintf('\small $t J = %s$, $%s$, $%s$',t1,t2,t3) at 24,0.00006 right

unset colorbox

set key at graph -.05, 0.97 left samplen 1 maxrows 1 width -1

mod(x,m)=x-(floor(x/m)*m)

########## fit ###########
a = sqrt(sig(t1,L,D))
f(x) = 0.5/(sqrt(2*3.14)*a)*exp(-(x-L/2-1)**2/(2*a**2))
#fit f(x) XXZfileQ(L,D,t1) using 1:((($3+1)/2-0.5)) via a

b = sqrt(sig(t2,L,D))
g(x) = 0.5/(sqrt(2*3.14)*b)*exp(-(x-L/2-1)**2/(2*b**2))
#fit g(x) XXZfileQ(L,D,t2) using 1:((($3+1)/2-0.5)) via b

c = sqrt(sig(t3,L,D))
h(x) = 0.5/(sqrt(2*3.14)*c)*exp(-(x-L/2-1)**2/(2*c**2))
#fit h(x) XXZfileQ(L,D,t3) using 1:((($3+1)/2-0.5)) via c


p	XXZfileQ(L,D,t0) u 1:(($3+1)/2-0.5) w p pt    6 ps 1.0 lw 2 lc rgb "red" ti '',\
	XXZfileQ(L,D,t1) u 1:(($3+1)/2-0.5) w p pt    4 ps 1.0 lw 2 lc rgb "orange" ti '',\
	XXZfileQ(L,D,t2) u 1:(($3+1)/2-0.5) w p pt    8 ps 1.5 lw 2 lc rgb "green" ti '',\
	XXZfileQ(L,D,t3) u 1:(($3+1)/2-0.5) w p pt  10 ps 1.5 lw 2 lc rgb "blue" ti '',\
   	f(x) w l lt 1 dt 2 lw 2 lc rgb "black" title '',\
   	g(x) w l lt 1 dt 2 lw 2 lc rgb "black" title '',\
   	h(x) w l lt 1 dt 2 lw 2 lc rgb "black" title ''


unset arrow
unset label
unset object

unset logscale x
unset logscale y
set key default

########################################################
# init_margins(left, right, bottom, top, dx, dy, rows, cols)
row=2
eval(set_margins(col,row))


set ylabel '$D(t)/J,\,\Sigma(t)$' offset -3,-.4

xmin = 0
xmax = 20.0
set xrange [xmin:xmax]
set xtics 5

#set xtics ("$10^{-1}$" 0.1, "$10^{0}$" 1, "$10^{1}$" 10)

unset format

ymin = 0
ymax = 5
set yrange [ymin:ymax]
set ytics 2
#set ytics ("$10^{-1}$" 0.1, "$10^{0}$" 1, "$10^{1}$" 10)

x0=NaN
y0=NaN
fitxmin=2.5
fitxmax=5
Diff = .6
d(x) = Diff
fit [fitxmin:fitxmax] d(x) sigXXZfileQ(L,D) u (dx=$1-x0,x0=$1,$1-dx/2):(dy=$2-y0,y0=$2,0.5*dy/dx) via Diff

set xlabel '$tJ$' offset 4,1.

set label '(b)' at graph 0.9,0.65 front textcolor rgb "black" 
          
set key at graph .52,.92 samplen 1.7 right  maxrows 2 width -5

#set arrow 1 from fitxmin,ymin to fitxmin,ymax dt 2 lc rgb 'grey' nohead 
#set arrow 2 from fitxmax,ymin to fitxmax,ymax dt 2 lc rgb 'grey' nohead

set arrow 3 from fitxmax*1.05,Diff*2 to .5*fitxmax+.5*fitxmin,Diff*.95 dt 1 lw 2  lc rgb 'dark-grey' head filled 

set label '\footnotesize $D(t)/J=$'.sprintf(" %.1f",Diff) at fitxmax*1.1,Diff*2.2 left front textcolor rgb 'dark-grey' 

colSig='#01665e'
colD='#8c510a'

x0=NaN
y0=NaN

########## fit ###########
b = -1
Diff=0.6
s(x) = 2*Diff*x+b
fit [2.5:5] s(x) sigXXZfileQ(L,D) u 1:2 via b,Diff

p 	Diff w l lw 2 lc rgb 'dark-grey' t '',\
	sigXXZfileQ(L,D) u 1:(sqrt($2)) w l lw 3 lc rgb colSig t '\footnotesize $\Sigma(t)$',\
	sigXXZfileQ(L,D) u (dx=$1-x0,x0=$1,$1-dx/2):(dy=$2-y0,y0=$2,0.5*dy/dx) w l lw 3 lc rgb colD dt 4 ti '\footnotesize $D(t)/J$',\
	sqrt(s(x)) w l dt 2 lc rgb 'dark-grey' lw 3 ti '\footnotesize $\propto \sqrt{t}$'


unset arrow
unset label
unset object


