function [tab_merged,tab_all] = readAbundancesFromFile(fileName)
%% [tab_merged,tab_all] = readAbundancesFromFile(fileName)
% read abundance table from a text file, generated by usearch
% Input:
%       char fileName:              file name containing OTU abundances
% Output:
%       table tab_merged:           sum of abundances for all samples
%                                   combined
%       table tab_all:              table as it is read from file

% read the table from file
tab_all = readtable(fileName,...
    'ReadVariableNames', true,...
    'ReadRowNames', true);

% calculate row sums (for every feature)
abundances = sum(table2array(tab_all), 2);
tab_merged = array2table(abundances,...
    'RowNames', tab_all.Properties.RowNames,...
    'VariableNames', {'abundances'});

end

