% Convert all models to a uniform standard
options; clear
%% gapseq
% Tables
tablesDir = 'data/tables';
ModelSEEDRxnEC = fullfile(tablesDir, 'ModelSEED_RXN_EC.csv');
%ecTransFile = fullfile(tablesDir, 'corrected-EC-numbers.csv');
formulaeFile = fullfile(tablesDir, 'MNXref', 'MNXref_MET_FORMULAE.csv');

formulaTab = readtable(formulaeFile, 'ReadVariableNames', true, 'Delimiter', '\t');
ecRxnTable = readtable(ModelSEEDRxnEC, 'ReadVariableNames', false);
%ecTranslationTable = readtable(ecTransFile, 'ReadVariableNames', false);
translationDB = loadTranslationDB;

% Add E.C. numbers
fprintf('\nAdding EC numbers\n')
for j=1:numel(models)
    % Retrieve ec numbers from ModelSEED reaction database
    models{j}.EC = ecNumbersFromModelSEED(models{j}.rxns, ecRxnTable);
end

% convert the model to the the standard format
%    fprintf('\nConverting to standard format and translating to MNXref namespace\n')
for j=1:numel(models)
    %fprintf('\mModel %d/%d:\n', num2str(j))
    models{j} = convertgapseqModel(models{j}, true, translationDB);
    % add a formula
    models{j} = addMetFormulae(models{j}, formulaTab);
end
    
save('data/models/seawater/gapseq/models_mnx.mat', 'models');


