% Convert all models to a uniform standard
options; clear
%% CarveMe
% Tables
tablesDir = '~/COMMIT/data/tables';
ecTransFile = fullfile(tablesDir, 'corrected-EC-numbers.csv');
coFactorFile = fullfile(tablesDir, 'cofactors_from_KEGG.csv');
formulaeFile = fullfile(tablesDir, 'MNXref', 'MNXref_MET_FORMULAE.csv');

formulaTab = readtable(formulaeFile, 'ReadVariableNames', true, 'Delimiter', '\t');
ecTranslationTable = readtable(ecTransFile, 'ReadVariableNames', false);
coFactorsTab = readtable(coFactorFile, 'Delimiter', '\t', 'ReadVariableNames', false);
translationDB = loadTranslationDB;

for j=1:numel(models)
    models{j} = convertCarveMeModel(models{j}, true, translationDB);
    models{j}.EC = correctEC(models{j}.EC, ecTranslationTable);
    % add a formula
    models{j} = addMetFormulae(models{j}, formulaTab);
end
    
save('data/models/seawater/carveme/models_mnx.mat', 'models')
