% add formulae to models

formulaTab = readtable('data/tables/MNXref/MNXref_MET_FORMULAE.csv',...
    'ReadVariableNames', true);
habitats = {'coral', 'seawater'};
methods = {'carveme','gapseq','kbase'};
modelDir = 'data/models';

for i = 1:numel(habitats)
    disp(habitats{i})

    for j = 1:numel(methods)
        disp(methods{j})
        workspace = fullfile(modelDir, habitats{i}, methods{j}, strcat(methods{j}, '_models_no_medium_no_biomass.mat'));
        load(workspace)
        
        for k=1:numel(models)
           models{k} = addMetFormulae(models{k}, formulaTab);
        end

        save_workspace = fullfile(modelDir, habitats{i}, methods{j},  strcat(methods{j},'_models_metFormulas.mat'));
        save(save_workspace, 'models')
        clear models
    end
end