rm(list=ls())
setwd('~/comparison of tools/data/figures/exchanged_reactions_flux')

sink_max_100 <- read.table('seawater__sink_max_100flux.csv',header = T,sep = ',')

max_100 <- as.data.frame(c(sink_max_100$CarveMe,sink_max_100$gapseq,
                           sink_max_100$KBase,sink_max_100$Consensus))

colnames(max_100) <- 'flux'

max_100$modelID <- c(rep(sink_max_100$modelID, 4))

max_100$Methods <- c(rep('CarveMe',length(sink_max_100$modelID)),
                     rep('gapseq',length(sink_max_100$modelID)),
                     rep('KBase',length(sink_max_100$modelID)),
                     rep('Consensus',length(sink_max_100$modelID)))

max_100$modelID <- factor(max_100$modelID,
                          levels=c('SW_MAG_1','SW_MAG_2','SW_MAG_3','SW_MAG_4','SW_MAG_5',
                                   'SW_MAG_6','SW_MAG_7','SW_MAG_8','SW_MAG_9','SW_MAG_10',
                                   'SW_MAG_11','SW_MAG_12','SW_MAG_13','SW_MAG_14','SW_MAG_15',
                                   'SW_MAG_16','SW_MAG_17','SW_MAG_18','SW_MAG_19','SW_MAG_20',
                                   'SW_MAG_21','SW_MAG_22','SW_MAG_23','SW_MAG_24','SW_MAG_25',
                                   'SW_MAG_26','SW_MAG_27','SW_MAG_28','SW_MAG_29','SW_MAG_30',
                                   'SW_MAG_31','SW_MAG_33','SW_MAG_34','SW_MAG_35',
                                   'SW_MAG_36','SW_MAG_37','SW_MAG_38','SW_MAG_39','SW_MAG_40',
                                   'SW_MAG_41','SW_MAG_42','SW_MAG_43','SW_MAG_44','SW_MAG_45',
                                   'SW_MAG_46','SW_MAG_47','SW_MAG_49','SW_MAG_50',
                                   'SW_MAG_51','SW_MAG_52','SW_MAG_53','SW_MAG_54','SW_MAG_55'))

max_100$Methods <- factor(max_100$Methods,
                          levels=c('CarveMe','gapseq','KBase','Consensus'))


max_100$flux <- log10(max_100$flux+1)

library(ggplot2)
library(ggpubr)

ggplot(max_100, aes(modelID, flux))+
  geom_boxplot(aes(color = Methods))+
  facet_wrap(vars(max_100$modelID),scales = "free_x", nrow = 5)+
  theme_bw()+
  labs(x = '', y = 'Log(10) predicted flux')+
  theme(axis.title.y = element_text(size = 20, face = "bold"),
        strip.text.x = element_text(size = 10, face = "bold"),
        legend.title = element_text(size = 10, face = "bold"),
        legend.text = element_text(size = 10, face = "bold"),
        axis.text.y = element_text(size = 13),
        axis.text.x=element_blank(),
        axis.ticks.x=element_blank())

ggsave(filename = "~/comparison of tools/Figure_S9.svg",
       width = 35,height = 20,units = "cm")
