rm(list=ls())
setwd('~/comparison of tools/data/figures/exchanged_reactions_flux')

sink_max_100 <- read.table('coral__sink_max_100flux.csv',header = T,sep = ',')

max_100 <- as.data.frame(c(sink_max_100$CarveMe,sink_max_100$gapseq,
                                 sink_max_100$KBase,sink_max_100$Consensus))

colnames(max_100) <- 'flux'

max_100$modelID <- c(rep(sink_max_100$modelID, 4))

max_100$Methods <- c(rep('CarveMe',length(sink_max_100$modelID)),
                        rep('gapseq',length(sink_max_100$modelID)),
                        rep('KBase',length(sink_max_100$modelID)),
                        rep('Consensus',length(sink_max_100$modelID)))

max_100$modelID <- factor(max_100$modelID,
                          levels=c('Plut_MAG_1','Plut_MAG_2','Plut_MAG_3','Plut_MAG_4','Plut_MAG_5',
                                   'Plut_MAG_6','Plut_MAG_7','Plut_MAG_8','Plut_MAG_9','Plut_MAG_10',
                                   'Plut_MAG_11','Plut_MAG_12','Plut_MAG_13','Plut_MAG_14','Plut_MAG_15',
                                   'Plut_MAG_16','Plut_MAG_17','Plut_MAG_18','Plut_MAG_19',
                                   'Plut_MAG_21','Plut_MAG_22','Plut_MAG_23','Plut_MAG_24','Plut_MAG_25',
                                   'Plut_MAG_26','Plut_MAG_27','Plut_MAG_28','Plut_MAG_29','Plut_MAG_30',
                                   'Plut_MAG_31','Plut_MAG_32','Plut_MAG_33','Plut_MAG_34','Plut_MAG_35',
                                   'Plut_MAG_36','Plut_MAG_37','Plut_MAG_38','Plut_MAG_40',
                                   'Plut_MAG_41','Plut_MAG_42','Plut_MAG_43','Plut_MAG_44','Plut_MAG_45',
                                   'Plut_MAG_46','Plut_MAG_47','Plut_MAG_48','Plut_MAG_50'))

max_100$Methods <- factor(max_100$Methods,
                          levels=c('CarveMe','gapseq','KBase','Consensus'))

max_100$flux <- log10(max_100$flux+1)

library(ggplot2)
library(ggpubr)

ggplot(max_100, aes(modelID, flux))+
  geom_boxplot(aes(color = Methods))+
  facet_wrap(vars(max_100$modelID),scales = "free_x", nrow = 5)+
  theme_bw()+
  labs(x = '', y = 'Log(10) predicted flux')+
  theme(axis.title.y = element_text(size = 20, face = "bold"),
        strip.text.x = element_text(size = 10, face = "bold"),
        legend.title = element_text(size = 10, face = "bold"),
        legend.text = element_text(size = 10, face = "bold"),
        axis.text.y = element_text(size = 13),
        axis.text.x=element_blank(),
        axis.ticks.x=element_blank())

ggsave(filename = "~/comparison of tools/Figure_S7.svg",
       width = 35,height = 20,units = "cm")
        