topDir <- "~/comparison of tools/data/exchanged_metabolites"

data <- read.table(paste0(topDir, "dist_methods.txt"),
                   header = T, na.strings = "NaN", row.names = 1)

colnames(data) <- c('C_CarveMe','C_gapseq','C_KBase','C_Consensus',
                    'S_CarveMe','S_gapseq','S_KBase','S_Consensus')
rownames(data) <- c('C_CarveMe','C_gapseq','C_KBase','C_Consensus',
                    'S_CarveMe','S_gapseq','S_KBase','S_Consensus')

library(pheatmap)
library(grid)

draw_colnames_45 <- function (coln, gaps, ...) {
  coord = pheatmap:::find_coordinates(length(coln), gaps)
  x = coord$coord - 0.5 * coord$size
  res = textGrob(coln, x = x, y = unit(1, "npc") - unit(3,"bigpts"), vjust = 0.5, hjust = 1, rot = 45, gp = gpar(...))
  return(res)}

## 'Overwrite' default draw_colnames with your own version 
assignInNamespace(x="draw_colnames", value="draw_colnames_45",
                  ns=asNamespace("pheatmap"))

exchange_met <- pheatmap(data, cluster_cols = F,cluster_rows = F,fontsize = 12)

library(ggplot2)
ggsave(exchange_met,filename = "~/comparison of tools/Figure_S6.svg",
       width = 25,height = 20,units = "cm")
