setwd('~/comparison of tools/figures')

rm(list=ls())

ck_unblock_enrich <- read.table('enrich/ck_unblock_enrich_in_each_model_coral.csv',header = T, sep = ',')
cg_unblock_enrich <- read.table('enrich/cg_unblock_enrich_in_each_model_coral.csv',header = T, sep = ',')
gk_unblock_enrich <- read.table('enrich/gk_unblock_enrich_in_each_model_coral.csv',header = T, sep = ',')
ck_shared_enrich <- read.table('enrich/ck_shared_enrich_in_each_model_coral.csv',header = T, sep = ',')
cg_shared_enrich <- read.table('enrich/cg_shared_enrich_in_each_model_coral.csv',header = T, sep = ',')
gk_shared_enrich <- read.table('enrich/gk_shared_enrich_in_each_model_coral.csv',header = T, sep = ',')
c_unblock_enrich <- read.table('enrich/c_unblock_enrich_coral.csv',header = T, sep = ',')
g_unblock_enrich <- read.table('enrich/g_unblock_enrich_coral.csv',header = T, sep = ',')
k_unblock_enrich <- read.table('enrich/k_unblock_enrich_coral.csv',header = T, sep = ',')
m_unblock_enrich <- read.table('enrich/m_unblock_enrich_coral.csv',header = T, sep = ',')

ck_unblock_enrich <- ck_unblock_enrich[,-(1:2)]
cg_unblock_enrich <- cg_unblock_enrich[,-(1:2)]
gk_unblock_enrich <- gk_unblock_enrich[,-(1:2)]
ck_shared_enrich <- ck_shared_enrich[,-(1:2)]
cg_shared_enrich <- cg_shared_enrich[,-(1:2)]
gk_shared_enrich <- gk_shared_enrich[,-(1:2)]

c_unblock<- as.data.frame(c_unblock_enrich[which(c_unblock_enrich$p_adjust < 0.05),7])
c_unblock[,2] <- as.data.frame(c_unblock_enrich[which(c_unblock_enrich$p_adjust < 0.05),4])
colnames(c_unblock) <- c('Enzyme','Number')

g_unblock<- as.data.frame(g_unblock_enrich[which(g_unblock_enrich$p_adjust < 0.05),7])
g_unblock[,2] <- as.data.frame(g_unblock_enrich[which(g_unblock_enrich$p_adjust < 0.05),4])
colnames(g_unblock) <- c('Enzyme','Number')

k_unblock<- as.data.frame(k_unblock_enrich[which(k_unblock_enrich$p_adjust < 0.05),7])
k_unblock[,2] <- as.data.frame(k_unblock_enrich[which(k_unblock_enrich$p_adjust < 0.05),4])
colnames(k_unblock) <- c('Enzyme','Number')

m_unblock<- as.data.frame(m_unblock_enrich[which(m_unblock_enrich$p_adjust < 0.05),7])
m_unblock[,2] <- as.data.frame(m_unblock_enrich[which(m_unblock_enrich$p_adjust < 0.05),4])
colnames(m_unblock) <- c('Enzyme','Number')


unblock_vs_share <- merge(cg_shared_enrich,cg_unblock_enrich,by = 'Enzyme',all=T)
unblock_vs_share <- merge(unblock_vs_share,ck_shared_enrich,by = 'Enzyme',all=T)
unblock_vs_share <- merge(unblock_vs_share,ck_unblock_enrich,by = 'Enzyme',all=T)
unblock_vs_share <- merge(unblock_vs_share,gk_shared_enrich,by = 'Enzyme',all=T)
unblock_vs_share <- merge(unblock_vs_share,gk_unblock_enrich,by = 'Enzyme',all=T)
unblock_vs_share <- merge(unblock_vs_share,c_unblock,by = 'Enzyme',all=T)
unblock_vs_share <- merge(unblock_vs_share,g_unblock,by = 'Enzyme',all=T)
unblock_vs_share <- merge(unblock_vs_share,k_unblock,by = 'Enzyme',all=T)
unblock_vs_share <- merge(unblock_vs_share,m_unblock,by = 'Enzyme',all=T)

colnames(unblock_vs_share) <- c('Function','cg_shared_rxns','cg_unblock_shared_rxns',
                               'ck_shared_rxns','ck_unblock_shared_rxns',
                               'gk_shared_rxns','gk_unblock_shared_rxns',
                               'CarveMe_unblock_rxns','gapseq_unblock_rxns','KBase_unblock_rxns','Consensus_unblock_rxns')

library(pheatmap)

rownames(unblock_vs_share) = unblock_vs_share$Function
unblock_vs_share = unblock_vs_share[,-1]
trans = function(x) {log10(x+1)}
unblock_vs_share = trans(unblock_vs_share)

heatmap_order = pheatmap(unblock_vs_share,
                         cluster_rows = F,
                         cluster_cols = F, na_col = 'gray')

ggsave(heatmap_order,filename = "~/comparison of tools/Figure_6.svg",
       width = 25,height = 20,units = "cm")

