setwd('~/comparison of tools/data/memote')
rm(list=ls())

# coral memote score file
c_memote <- read.table('coral_memote.csv',header = T,sep = ',')

data <- as.data.frame(c(c_memote$Total.Score,
                        c_memote$Consistency.Score,
                        c_memote$Unbounded.Flux.in.Default.Medium,
                        c_memote$Presnece.of.Reaction.Annotation))
data[,2] <- as.data.frame(c(c_memote$Approache,
                           c_memote$Approache,
                           c_memote$Approache,
                           c_memote$Approache))

vari <- c(rep('Total Score',200),rep('Consistency Score',200),
         rep('Unbounded Flux in Default Medium',200),rep('Presnece of Reaction Annotation',200))
data[3] <- as.data.frame(vari)
colnames(data) <- c('Score', 'Approach', 'Type')
data$Type <- factor(data$Type , levels=c('Total Score','Consistency Score', 
                                       'Unbounded Flux in Default Medium', 'Presnece of Reaction Annotation'))
data$Approach <- factor(data$Approach , levels=c('CarveMe', 'gapseq', 'KBase', 'Consensus'))


# seawater memote file
s_memote <- read.table('SW_memote.csv',header = T,sep = ',')

s_data <- as.data.frame(c(s_memote$Total.Score,
                        s_memote$Consistency.Score,
                        s_memote$Unbounded.Flux.in.Default.Medium,
                        s_memote$Presnece.of.Reaction.Annotation))
s_data[,2] <- as.data.frame(c(s_memote$Approache,
                              s_memote$Approache,
                              s_memote$Approache,
                              s_memote$Approache))

vari <- c(rep('Total Score',220),rep('Consistency Score',220),
          rep('Unbounded Flux in Default Medium',220),rep('Presnece of Reaction Annotation',220))
s_data[3] <- as.data.frame(vari)
colnames(s_data) <- c('Score', 'Approach', 'Type') 
s_data$Type <- factor(s_data$Type , levels=c('Total Score','Consistency Score', 
                                       'Unbounded Flux in Default Medium', 'Presnece of Reaction Annotation'))
s_data$Approach <- factor(s_data$Approach , levels=c('CarveMe', 'gapseq', 'KBase', 'Consensus'))


# plot figure
library(ggplot2)
library(ggpubr)

coral <- ggplot(data, aes(Type, Score)) +
  geom_boxplot(aes(color = Approach))+
  ylim(0,100)+
  theme_bw()+
  ggtitle('a. Coral-associated bacteria')+
  stat_compare_means(aes(group = Approach), label = "p.signif", label.y = 100, na.rm = T)+
  theme(text = element_text(size = 10),
        plot.title = element_text(face = "bold"),
        axis.title.x = element_blank(),
        axis.title.y = element_text(face = "bold", size = 13),
        axis.text.y = element_text(size = 13),
        axis.text.x = element_text(size = 10, angle = 45, hjust = 1),
        panel.grid = element_blank())

seawater <- ggplot(s_data, aes(Type, Score)) +
  geom_boxplot(aes(color = Approach))+
  ylim(0,100)+
  theme_bw()+
  ggtitle('b. Seawater bacteria')+
  stat_compare_means(aes(group = Approach), label = "p.signif", label.y = 100, na.rm = T)+
  theme(text = element_text(size = 10),
        plot.title = element_text(face = "bold"),
        axis.title.x = element_blank(),
        axis.title.y = element_blank(),
        axis.text.y = element_text(size = 13),
        axis.text.x = element_text(size = 10, angle = 45, hjust = 1),
        panel.grid = element_blank())

ggarrange(coral, seawater, 
          common.legend = TRUE,
          legend = 'right')


ggsave(filename = "~/comparison of tools/Figure_5.svg",
       width = 20,height = 15,units = "cm")
