# Personal immune profiles from the 300BCG cohort

This repository contains personal immune profiles of 323 healthy individuals (300BCG) subjected to Bacillus Calmette-Guérin (BCG) with blood samples collected immediately before (day 0), and 14 and 90 days after the vaccination. The personal immune profiles comprise:
 - immune cell concentrations measured with flow cytometry and a hematology analyzer
 - plasma concentrations of 73 circulating inflammatory markers
 - 30 measurements of cytokine and lactate production capacity of peripheral blood mononuclear cells (PBMCs) in response to four microbial stimuli (Candida albicans, Escherichia coli lipopolysaccharide [LPS], Staphylococcus aureus, Mycobacterium tuberculosis).

 Visit [http://300BCG.bocklab.org/](http://300BCG.bocklab.org/) to learn more.

# Contents

 - `300BCG_whole_blood_million_per_ml_concentrations.csv`
   - immune cell concentrations measured with flow cytometry in whole blood
 - `300BCG_whole_blood_million_per_ml_concentrations_names.csv`
   - scientific names and cell markers of the quantified cell types
 - `300BCG_PBMC_million_per_ml_concentrations.csv`
   - immune cell concentrations measured with Sysmex hematology analyzer (XN-450) in PBMCs
 - `300BCG_PBMC_million_per_ml_concentrations_names.csv`
   - scientific names and cell markers of the quantified cell types
 - `300BCG_circulating_inflammatory_markers.csv`
   - plasma concentrations of 73 circulating inflammatory markers
 - `300BCG_circulating_inflammatory_markers_names.csv`
   - scientific names of the inflammatory markers
 - `300BCG_cytokine_production_capacity.csv`
   - 30 measurements of cytokine and lactate production capacity of PBMCs in response to four microbial stimuli
 - `300BCG_cytokine_production_capacity_names.csv`
   - scientific names of the cytokines
 - `unprocessed_flow_cytometry_whole_blood.xlsx`
   - unprocessed (raw) flow cytomery data in whole blood
 - `unprocessed_sysmex_PBMCs.xlsx`
   - unprocessed (raw) Sysmex hematology analyzer (XN-450) data in PBMCs
 - `cell_fractions_from_concentrations.ipynb`
   - Jupyter notebook (Python 3.6.10) for converting cell concentrations to cell fractions
 - `impute_PBMC_cell_fractions.ipynb`
   - Jupyter notebook (Python 3.6.10) for imputing PBMC fractions from whole-blood concentrations

# Citation

If you use this data, please cite the following article:

**Multi-omics analysis of innate and adaptive responses to BCG vaccination reveals epigenetic predictors of trained immunity**. *Immunity*. 2024; **57**(1).

Simone J.C.F.M. Moorlag\*, Lukas Folkman\*, Rob ter Horst\*, Thomas Krausgruber\*, Daniele Barreca, Linda C. Schuster, Victoria Fife, Vasiliki Matzaraki, Wenchao Li, Stephan Reichl, Vera P. Mourits, Valerie A.C.M. Koeken, L. Charlotte J. de Bree, Helga Dijkstra, Heidi Lemmers, Bram van Cranenbroek, Esther van Rijssen, Hans J.P.M. Koenen, Irma Joosten, Cheng-Jian Xu, Yang Li, Leo A.B. Joosten, Reinout van Crevel, Mihai G. Netea#, and Christoph Bock#.

\* These authors contributed equally to this work; \# These authors contributed equally to this work.
