# -*- coding: utf-8 -*-
import os

import pytest
from linopy import available_solvers


@pytest.mark.skipif("gurobi" not in available_solvers, reason="Gurobi not installed")
def test_lopf_quadratic(ac_dc_network):
    n = ac_dc_network

    status, _ = n.optimize(solver_name="gurobi")

    assert status == "ok"

    gas_i = n.generators.index[n.generators.carrier == "gas"]

    objective_linear = n.objective

    # quadratic costs
    n.generators.loc[gas_i, "marginal_cost_quadratic"] = 2
    status, _ = n.optimize(solver_name="gurobi")

    assert status == "ok"
    assert n.objective > objective_linear
