% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariantSummary.R
\name{redeemR.read}
\alias{redeemR.read}
\title{Function to read in redeemV outputs}
\usage{
redeemR.read(
  path,
  thr = "S",
  Processed = F,
  rdsname = "/VariantsGTSummary.RDS"
)
}
\arguments{
\item{path}{The XX/final folder, the output from mitoV}

\item{thr}{The thredhold of filtering T(Total),LS(Less Stringent:c=0.75,a1=2,a2=1), S(Stringent:c=0.75,a1=3,a2=2), VS(Very Stringent:c=0.75,a1=4,a2=3)"}

\item{Processed}{Boolean variable (Default F), if true directly readRDS("VariantsGTSummary.RDS") or, generate and saveout "VariantsGTSummary.RDS"}
}
\value{
this returns depth which is a list of 4 df (Total/VerySensitive/Sensitive/Specific), each is a genotype summary
}
\description{
This function allows you to read raw data from XX/final folder, the output from redeemV
It process the data same way as CW_mgatk.read but need to specify one threadhold(thr)
}
\examples{
WD<-"/lab/solexa_weissman/cweng/Projects/MitoTracing_Velocity/SecondaryAnalysis/Donor01_CD34_1_Multiomekit/MTenrichCombine/Enrich/CW_mgatk/final"
DN1CD34_1.VariantsGTSummary<-CW_mgatk.read(WD,Processed =T)
}
