% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/General_functions.R
\name{Translate_RNA2ATAC}
\alias{Translate_RNA2ATAC}
\title{Function to translate the RNA barcode into ATAC barcode and add a column}
\usage{
Translate_RNA2ATAC(
  meta = bmmc.filtered@meta.data,
  PostFix = T,
  bclength = 16,
  from = c(1, 2, 3),
  to = c(1, 2, 3)
)
}
\arguments{
\item{meta}{a dataframe with the row names as the RNA cell barcode usually with the post -1}

\item{bclength}{The cell barcode length, default is 16}

\item{from}{A vector of the postfix,  usually is c(1,2,3,...), it depends on how many samples are aggregated in Cellranger RNA part}

\item{to}{A vector of the postfix, those cooresponds to the postfix added in redeemR, in general, if it matches, then simply c(1,2,3,...),
but in case not match, here provides a way to transform into scredeemR order}
}
\value{
meta a dataframe
}
\description{
This function allows you to input the metadata with row name as cell barcode
}
\examples{
Translate_RNA2ATAC(meta)
}
