% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuidTree.R
\name{Make_AnnTable}
\alias{Make_AnnTable}
\title{Make_AnnTable, Make a big dataframe, each row is a cell, each column includes info such as clonal UMAP, Clonal ID, ATAC/RNA/WNN UMAP, PCA, gene expression of chosen gene, etc.  Require a redeemR object and a multiome wrapper that better matches the cells in the redeemR}
\usage{
Make_AnnTable(
  redeemR = DN4_HSC_redeemR.Sensitive,
  Multiome = Donor04_HSC_Multiome_wrapper,
  clonal_features = c("nCount_mitoV", "seurat_clusters"),
  clonal_features_rename = c("nCount_mitoV", "clone_clusters"),
  CellMeta_features = c("meanCov", "nCount_RNA", "nFeature_RNA", "nCount_ATAC",
    "nFeature_ATAC", "CellType"),
  CellMeta_features_rename = c("Mito_meanCov", "nCount_RNA", "nFeature_RNA",
    "nCount_ATAC", "nFeature_ATAC", "CellType"),
  multiome_features = c("seurat_clusters"),
  multiome_features_rename = c("NewSeurat_cluster"),
  RNAUMAP = T,
  ATACUMAP = T,
  WNNUMAP = T,
  PCA = F,
  LSI = F,
  Variants = "",
  genes = "",
  peaks = "",
  PostTrans_from = c(2, 3),
  PostTrans_to = c(2, 1)
)
}
\arguments{
\item{redeemR}{eg. DN4_HSC_redeemR.Sensitive}

\item{Multiome}{eg. Donor04_HSC_Multiome_wrapper,  Multiome_wrapper object that matches with the redeemR, a reclustering using Multi_Wrapper() is recommended}

\item{clonal_features}{eg. c("nCount_mitoV","seurat_clusters"), The column names take from redeemR@Seurat@meta.data, importantly the clonal clusterings}

\item{clonal_features_rename}{eg. c("nCount_mitoV","clone_clusters") Rename the clonal_features}

\item{CellMeta_features}{eg. c("meanCov","nCount_RNA","nFeature_RNA","nCount_ATAC","nFeature_ATAC","CellType") The column names take from  redeemR@CellMeta, may useful cell features}

\item{CellMeta_features_rename}{eg. c("Mito_meanCov","nCount_RNA","nFeature_RNA","nCount_ATAC","nFeature_ATAC","CellType") Rename the CellMeta}

\item{multiome_features}{eg. c("seurat_clusters")  The column names take from Multiome@meta.data}

\item{multiome_features_rename}{eg. c("NewSeurat_cluster")   Rename the column names for multiome_features}

\item{RNAUMAP}{default T}

\item{ATACUMAP}{Default T}

\item{WNNUMAP}{Default T}

\item{PCA}{Default T}

\item{LSI}{Default T}

\item{Variants}{Default ""  can be a vector of variant names format is eg "Variants10020TC"}

\item{genes}{Default ""  can be a vector of gene names, for example c("HLF","CD34")}

\item{peaks}{Default ""  can be a vector of peaks names}

\item{PostTrans_from}{Default c(2,3)  # This is a tricky part eh nmerging files are involved, find the postfix from cellranger agg for different sample}

\item{PostTrans_to}{Default c(2,1)}
}
\value{
AnnTable
}
\description{
Make_AnnTable, Make a big dataframe, each row is a cell, each column includes info such as clonal UMAP, Clonal ID, ATAC/RNA/WNN UMAP, PCA, gene expression of chosen gene, etc.  Require a redeemR object and a multiome wrapper that better matches the cells in the redeemR
}
