% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariantSummary.R
\name{DepthSummary}
\alias{DepthSummary}
\title{Function to summarize the depth (Total that passed Q30)}
\usage{
DepthSummary(path, CellSubset = NA, only_Total = T)
}
\arguments{
\item{path}{The XX/final folder, the output from mitoV}

\item{CellSubset}{A vector of ATAC cell names for subsetting, default is NA}

\item{only_Total}{Default is T, Only return total depth summary. Don't care about depth in different quality filtering}

\item{Processed}{Boolean variable(Default T), if true directly readRDS("depth.RDS") or, generate and saveout "depth.RDS"}
}
\value{
this returns depth which is a list of 4 list(Total/VerySensitive/Sensitive/Specific), each contains 2 df, summarize mito coverage by Pos/Cell
}
\description{
This function allows you to summarize the depth
}
\examples{
WD<-"/lab/solexa_weissman/cweng/Projects/MitoTracing_Velocity/SecondaryAnalysis/Donor01_CD34_1_Multiomekit/MTenrichCombine/Enrich/CW_mgatk/final"
DN1CD34_1.depth<-DepthSummary(WD,Processed = T)
}
