# Bubaak

Bubaak is a set of scripts that run program verifiers in parallel and
exchange verification artifacts between the verifiers at runtime. Right now, the default
verifiers are [BubaaK-LEE](https://github.com/mchalupa/bubaak-lee)
(a fork of [JetKLEE](https://github.com/staticafi/JetKlee)) and
[SlowBeast](https://gitlab.com/mchalupa/slowbeast). To exchange the data,
the tools must be manually modified to share partial results of analyses.

NOTE: sharing the information is a work in progress and does not work yet.
Bubaak still can be used, the verifiers run, they just do not exchange any information.



         ????
        ? 00 ?
      >-|  O |-<



# Building


Cloning and initial setup:

```
git clone https://gitlab.com/mchalupa/bubaak
cd bubaak
git submodule update --init
make setup
```

The command `make setup` tries to get and build dependencies.
If the command for some reason fails, you can try to obtain and build
the dependencies manually:

```
## We'll need curl or wget:
apt-get install curl

## Basic dependencies
apt-get install cmake clang llvm pip

## Dependencies of BubaaK-LEE
apt-get install libsqlite3-dev libz3-dev zlib1g
pip install lit # to run tests with KLEE, can be skipped

## Setup build dir for  Bubaak-LEE
cd klee; mkdir build && cd build

## Configure Bubaak-LEE.
# Also, either install tcmalloc or use
# -DENABLE_TCMALLOC=off in the following command
cmake .. -DCMAKE_INSTALL_PREFIX=$(pwd)/install

## Build Bubaak-LEE
make -j4
make install
```
```
### Building slowbeast package
cd ../..
cd slowbeast
pip install z3-solver
git clone https://github.com/mchalupa/llvmlite
cd llvmlite && python3 ./setup.py build && cd ..

# that's it for slowbeast, but if you want to build a package:
pip install pyinstaller
pyinstaller sb
```

Once the project is all setup, you can build a zip with `make archive`.


### Optional dependencies
```
# To read SV-COMP .yml files on input instead of C programs
pip install pyyaml
```

## Author & Support
Marek Chalupa, mchqwerty@gmail.com
